/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.planningNotification.PlanningNotification;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.file.FileFinder;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.PlanningNotificationDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.exception.FileHandleException;
import java.io.File;
import java.util.ArrayList;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class PlanningNotificationMimeSource
implements VisitlessMimeSource {
    private PlanningNotificationDAO planningNotificationDAO;
    private FileFinder fileFinder;
    private NetworkDAO networkDAO;
    private ProjectDAO projectDAO;

    public String getActionName() {
        return "downloadPlanningNotification";
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        Integer planningNotificationId = (Integer)parameters[0];
        PlanningNotification planningNotification = this.planningNotificationDAO.get(planningNotificationId);
        Integer nwId = planningNotification.getNetwork().getId();
        ArrayList<Project> projects = new ArrayList<Project>(planningNotification.getAssociatedProjects().values());
        Integer prId = ((Project)projects.get(0)).getId();
        if (prId != null) {
            return this.projectDAO.get(prId);
        }
        return this.networkDAO.get(nwId);
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        String unique;
        File file;
        Integer id = (Integer)parameters[0];
        PlanningNotification pn = this.planningNotificationDAO.get(id);
        try {
            file = this.fileFinder.findFile(pn.getPath(), CDESFileRepository.PLANNINGNOTIFICATIONREPOSITORY);
            unique = this.fileFinder.makeUniqueName(pn.getPath(), CDESFileRepository.PLANNINGNOTIFICATIONREPOSITORY);
        }
        catch (FileHandleException e) {
            throw new IOError("Invalid file handle when fetching the documentversion", (Throwable)e);
        }
        return new FileMimeInputStream(file, unique, pn.getFilename(), DefaultHttpContext.getInstance().getMimeType(pn.getPath()));
    }

    public void setPlanningNotificationDAO(PlanningNotificationDAO planningNotificationDAO) {
        this.planningNotificationDAO = planningNotificationDAO;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }
}

