/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.label;

import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.TemporaryDocumentVersion;
import at.cdes.bo.data.label.BoldRichTextItem;
import at.cdes.bo.data.label.CDataRichTextItem;
import at.cdes.bo.data.label.DocumentVersionTextField;
import at.cdes.bo.data.label.FreeTextLabelTextField;
import at.cdes.bo.data.label.ParagraphRichTextItem;
import at.cdes.bo.data.label.RichTextItemContainer;
import at.cdes.bo.data.label.SignatureTextField;
import at.cdes.bo.data.object.CDESObject;
import at.cdes.bo.data.object.CDESObjectImpl;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.label.AbstractTextFieldRenderer;
import at.cdes.db.dao.DocumentDAO;
import at.cdes.util.TapestryI18nHelper;
import java.io.IOException;
import java.text.SimpleDateFormat;

public class TemporaryDocumentVersionTextFieldRenderer
extends AbstractTextFieldRenderer {
    private TemporaryDocumentVersion temporaryDocumentVersion;
    private DocumentDAO documentDAO;

    public TemporaryDocumentVersionTextFieldRenderer(TemporaryDocumentVersion _temporaryDocumentVersion, double xoff, double yoff, boolean respectUserUnit, DocumentDAO documentDAO) {
        super(_temporaryDocumentVersion.getLabelXOffset() + xoff, _temporaryDocumentVersion.getLabelYOffset() + yoff, respectUserUnit ? _temporaryDocumentVersion.getUserUnit() : 1.0);
        this.temporaryDocumentVersion = _temporaryDocumentVersion;
        this.documentDAO = documentDAO;
    }

    @Override
    public void visit(SignatureTextField field) throws IOException {
        if (this.temporaryDocumentVersion.getDestinationCellId() != null && !this.temporaryDocumentVersion.getDestinationCellId().equals(field.getReviewCycleNode().getReviewCycleCell().getId()) || this.temporaryDocumentVersion.getRevisionCellConnectionId() != null && !this.temporaryDocumentVersion.getRevisionCellConnectionId().equals(field.getReviewCycleNode().getReviewCycleCell().getId()) || this.temporaryDocumentVersion.getInvalidationCellConnectionId() != null && !this.temporaryDocumentVersion.getInvalidationCellConnectionId().equals(field.getReviewCycleNode().getReviewCycleCell().getId())) {
            return;
        }
        RichTextItemContainer root = new RichTextItemContainer();
        root.addItem(new ParagraphRichTextItem(new BoldRichTextItem(new CDataRichTextItem(TapestryI18nHelper.getLocalizedString(field.getReviewCycleNode().getName()) + "\r"))));
        root.addItem(new ParagraphRichTextItem(new CDataRichTextItem("Pr\u00fcfung ausst\u00e4ndig\r")));
        super.renderFDFObject(field, TapestryI18nHelper.getLocalizedString(field.getReviewCycleNode().getName()), "c.des", this.temporaryDocumentVersion.getUploaded(), root, 0, 1);
    }

    @Override
    public void visit(DocumentVersionTextField field) throws IOException {
        CDESObjectImpl object;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        DocumentImpl document = this.documentDAO.get(this.temporaryDocumentVersion.getDocumentId());
        String cdata = field.getContent();
        cdata = cdata.replace("${name}", this.temporaryDocumentVersion.getName());
        cdata = cdata.replace("${alt_name}", this.temporaryDocumentVersion.getAlternativeName() != null ? this.temporaryDocumentVersion.getAlternativeName() : "");
        cdata = cdata.replace("${comment}", this.temporaryDocumentVersion.getComment() != null ? this.temporaryDocumentVersion.getComment() : "");
        cdata = cdata.replace("${uploaded}", df.format(this.temporaryDocumentVersion.getUploaded()));
        cdata = cdata.replace("${version_parta}", this.temporaryDocumentVersion.getVersionPartA());
        if ((cdata = cdata.replace("${version_partb}", this.temporaryDocumentVersion.getVersionPartB())).contains("${object_code}") || cdata.contains("${object_name}")) {
            CDESObject obj = document.getObjectPlanner().getObject();
            cdata = cdata.replace("${object_code}", obj.getCode());
            cdata = cdata.replace("${object_name}", obj.getName());
        }
        if (cdata.contains("${as_built_name}")) {
            DocumentImpl asBuiltDoc = document.getAsBuiltReference();
            DocumentVersion lastVersion = asBuiltDoc != null ? asBuiltDoc.getLastDocumentVersion() : null;
            cdata = cdata.replace("${as_built_name}", lastVersion != null ? lastVersion.getName() : "");
        }
        if (cdata.contains("project") || cdata.contains("subProject")) {
            SubProject subProject = document.getDocumentList().getSubProject();
            Project project = document.getDocumentList().getSubProject().getProject();
            cdata = cdata.replace("${project_code}", project.getCode());
            cdata = cdata.replace("${project_name}", project.getName());
            cdata = cdata.replace("${principal_project}", project.getPrincipalProject() != null ? project.getPrincipalProject() : "");
            cdata = cdata.replace("${project_stretch}", project.getStretchName() != null ? project.getStretchName() : "");
            cdata = cdata.replace("${project_route}", project.getRouteName() != null ? project.getRouteName() : "");
            cdata = cdata.replace("${project_kms}", project.getKms() != null ? project.getKms() : "");
            cdata = cdata.replace("${subProject_code}", subProject.getCode());
            cdata = cdata.replace("${subProject_name}", subProject.getName());
        }
        cdata = cdata.replace("${object_type}", (object = (CDESObjectImpl)document.getObjectPlanner().getObject()).getObjectType() != null ? object.getObjectType().getCode() : "");
        cdata = cdata.replace("${object_kms}", object.getKms() != null ? object.getKms() : "");
        cdata = cdata.replace("${document_title}", TapestryI18nHelper.getLocalizedString(document.getContent()));
        if ((cdata = cdata.replace("${scale}", document.getScale())).length() <= 0) {
            return;
        }
        CDataRichTextItem name_item = new CDataRichTextItem(cdata + "\r");
        super.renderFDFObject(field, this.temporaryDocumentVersion.getName(), "c.des", this.temporaryDocumentVersion.getUploaded(), new ParagraphRichTextItem(name_item), 0, 1);
    }

    @Override
    public void visit(FreeTextLabelTextField textField) throws IOException {
        String cdata = textField.getContent();
        CDataRichTextItem name_item = new CDataRichTextItem(cdata + "\r");
        super.renderFDFObject(textField, this.temporaryDocumentVersion.getName(), "c.des", this.temporaryDocumentVersion.getUploaded(), new ParagraphRichTextItem(name_item), 0, 1);
    }
}

