/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.digest;

import at.cdes.bo.data.order.Order;
import at.cdes.bo.data.order.OrderAddress;
import at.cdes.bo.data.order.OrderItem;
import at.cdes.bo.data.order.OrganisationOrderStep;
import at.cdes.bo.data.order.OrganisationPersonOrderStep;
import at.cdes.bo.data.order.ProjectParticipationOrderStep;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.OrderStepDigestCalculator;
import at.cdes.bo.sec.digest.UncheckedDigestCalculatorException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import org.bouncycastle.util.encoders.Base64;

public class OrderStepDigesterV1
extends OrderStepDigestCalculator {
    private static final long serialVersionUID = 1L;

    @Override
    public String visit(OrganisationPersonOrderStep step) throws UncheckedDigestCalculatorException {
        DigestOutputStream dos;
        if (step.getDigest() != null) {
            return step.getDigest();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        try {
            dos = new DigestOutputStream(osd, this.getMessageDigest());
        }
        catch (DigestCalculatorException e) {
            throw new UncheckedDigestCalculatorException("Hashing DocumentList = ", e);
        }
        try {
            dos.write(("id=" + step.getId()).getBytes());
            dos.write(("created=" + step.getCreated()).getBytes());
            dos.write(("finished=" + step.getFinished()).getBytes());
            dos.write(("organisationPersonId=" + step.getOrganisationPerson().getId()).getBytes());
            dos.write(("comment=" + step.getComment()).getBytes());
        }
        catch (IOException e) {
            throw new UncheckedDigestCalculatorException("Hashing DocumentList = ", e);
        }
        String res = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
        return res;
    }

    @Override
    public String visit(ProjectParticipationOrderStep step) throws UncheckedDigestCalculatorException {
        DigestOutputStream dos;
        if (step.getDigest() != null) {
            return step.getDigest();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        try {
            dos = new DigestOutputStream(osd, this.getMessageDigest());
        }
        catch (DigestCalculatorException e) {
            throw new UncheckedDigestCalculatorException("Hashing DocumentList = ", e);
        }
        try {
            dos.write(("id=" + step.getId()).getBytes());
            dos.write(("created=" + step.getCreated()).getBytes());
            dos.write(("finished=" + step.getFinished()).getBytes());
            dos.write(("projectParticipationId=" + step.getProjectParticipation().getId()).getBytes());
            dos.write(("comment=" + step.getComment()).getBytes());
        }
        catch (IOException e) {
            throw new UncheckedDigestCalculatorException("Hashing DocumentList = ", e);
        }
        String res = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
        return res;
    }

    protected void digestOrder(Order order, DigestOutputStream dos) throws IOException {
        dos.write(("orderid=" + order.getId()).getBytes());
        this.digestOrderAddress(order.getBillingAddress(), dos);
    }

    protected void digestOrderAddress(OrderAddress address, DigestOutputStream dos) throws IOException {
        dos.write(("addid=" + address.getId()).getBytes());
        dos.write(("addgn=" + address.getGivenName()).getBytes());
        dos.write(("addsv=" + address.getSurName()).getBytes());
        dos.write(("addln=" + address.getLocalityName()).getBytes());
        dos.write(("addpa=" + address.getPostalAddress()).getBytes());
        dos.write(("addpc=" + address.getPostalCode()).getBytes());
        dos.write(("addtitle=" + address.getTitle()).getBytes());
        dos.write(("addgen=" + address.getGender()).getBytes());
        dos.write(("addcountryId=" + address.getCountry().getId()).getBytes());
    }

    protected void digestOrder(OrderItem item, DigestOutputStream dos) throws IOException {
        dos.write(("itemid=" + item.getId()).getBytes());
        this.digestOrderAddress(item.getDeliveryAddress(), dos);
    }

    @Override
    public Object visit(OrganisationOrderStep step) {
        DigestOutputStream dos;
        if (step.getDigest() != null) {
            return step.getDigest();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        try {
            dos = new DigestOutputStream(osd, this.getMessageDigest());
        }
        catch (DigestCalculatorException e) {
            throw new UncheckedDigestCalculatorException("Hashing DocumentList = ", e);
        }
        try {
            dos.write(("id=" + step.getId()).getBytes());
            dos.write(("created=" + step.getCreated()).getBytes());
            dos.write(("finished=" + step.getFinished()).getBytes());
            dos.write(("organisationPersonId=" + step.getOrganisationPerson().getId()).getBytes());
            dos.write(("comment=" + step.getComment()).getBytes());
        }
        catch (IOException e) {
            throw new UncheckedDigestCalculatorException("Hashing DocumentList = ", e);
        }
        String res = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
        return res;
    }
}

