/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.data.certificate.CDESCertificate;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.order.JobNumberGenerator;
import at.cdes.bo.data.order.OrderAddress;
import at.cdes.bo.data.order.OrderAddressExtractorVisitorImpl;
import at.cdes.bo.data.order.OrderItem;
import at.cdes.bo.data.order.OrderStep;
import at.cdes.bo.data.order.OrderStepCopier;
import at.cdes.bo.data.order.OrderStepImpl;
import at.cdes.bo.data.order.OrganisationOrderStep;
import at.cdes.bo.data.order.OrganisationPersonOrderStep;
import at.cdes.bo.data.order.PlotOrderTemplateResolverRegistry;
import at.cdes.bo.data.order.ProjectParticipationOrderStep;
import at.cdes.bo.data.order.orig.OriginalDocumentOrder;
import at.cdes.bo.data.order.orig.OriginalDocumentOrderItem;
import at.cdes.bo.data.order.plott.PlottOrder;
import at.cdes.bo.data.order.plott.PlottOrderItem;
import at.cdes.bo.data.order.plott.PlottOrderItemTemplate;
import at.cdes.bo.data.order.plott.PlottOrderTemplate;
import at.cdes.bo.data.order.plott.PlottProperties;
import at.cdes.bo.data.order.plott.ReviewCycleNodeInstancePlottOrderListener;
import at.cdes.bo.data.order.plott.TemplatePropertyResolver;
import at.cdes.bo.data.organisation.Organisation;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.sec.CDESSignature;
import at.cdes.bo.data.sec.DigestCalculatorType;
import at.cdes.bo.data.task.OriginalDocumentTask;
import at.cdes.bo.data.task.OriginalDocumentTaskDone;
import at.cdes.bo.data.task.PlotOrderAcceptanceTask;
import at.cdes.bo.data.task.PlotOrderAcceptanceTaskDone;
import at.cdes.bo.data.task.ReviewCyclePlottTask;
import at.cdes.bo.data.task.ReviewCyclePlottTaskDone;
import at.cdes.bo.data.task.TaskBase;
import at.cdes.bo.file.UploadFileHandler;
import at.cdes.bo.plot.LengthCalculator;
import at.cdes.bo.plot.LengthUnit;
import at.cdes.bo.sec.digest.DigestCalculator;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DigestCalculatorFactory;
import at.cdes.bo.sec.signature.SignatureCalculator;
import at.cdes.bo.sec.signature.SignatureCalculatorException;
import at.cdes.bo.sec.signature.SignatureCalculatorFactory;
import at.cdes.controller.apiHelper.SubProjectCopyContainer;
import at.cdes.controller.helper.DataSourceHelper;
import at.cdes.db.dao.DigestCalculatorDAO;
import at.cdes.db.dao.EMailDAO;
import at.cdes.db.dao.ObjectPlannerDAO;
import at.cdes.db.dao.OrderDAO;
import at.cdes.db.dao.OrganisationDAO;
import at.cdes.db.dao.OrganisationPersonDAO;
import at.cdes.db.dao.ProjectParticipationDAO;
import at.cdes.db.dao.ReviewCycleNodeInstanceDAO;
import at.cdes.db.dao.ReviewCycleNodeListenerDAO;
import at.cdes.db.dao.SignatureDAO;
import at.cdes.db.dao.TaskDAO;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.service.CertificateOperations;
import at.cdes.service.OrderOperations;
import at.cdes.service.PersonOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.service.TaskOperations;
import at.cdes.service.exception.ActionException;
import at.cdes.service.exception.FileHandleException;
import at.cdes.service.exception.NoCertificateException;
import at.cdes.service.exception.WrongPasswordException;
import at.cdes.util.TapestryI18nHelper;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import org.apache.log4j.Logger;

public class OrderOperationsImpl
implements OrderOperations {
    private static final long serialVersionUID = 1L;
    private OrderDAO orderDAO;
    private TaskDAO taskDAO;
    private EMailDAO mailDAO;
    private TaskOperations taskOperations;
    private DigestCalculatorFactory digestCalculatorFactory;
    private SignatureCalculatorFactory signatureCalculatorFactory;
    private SignatureDAO signatureDAO;
    private DigestCalculatorDAO digestCalculatorDAO;
    private PlotOrderTemplateResolverRegistry plotOrderTemplateResolverRegistry;
    private JobNumberGenerator jobNumberGenerator;
    private ReviewOperations reviewOperations;
    private PersonOperations personOperations;
    private CertificateOperations certificateOperations;
    private ObjectPlannerDAO objectPlannerDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private OrganisationDAO organisationDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private UploadFileHandler uploadHandler;
    private ReviewCycleNodeListenerDAO reviewCycleNodeListenerDAO;
    private ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO;
    private static final Logger logger = Logger.getLogger(OrderOperationsImpl.class);

    @Override
    public PlottOrderTemplate getTemplate(Integer id) {
        return this.orderDAO.getPlottOrderTemplate(id);
    }

    @Override
    public PlottOrderTemplate saveOrUpdateTemplate(PlottOrderTemplate template, List items) {
        if (template.getId() == null) {
            this.orderDAO.savePlottOrderTemplate(template);
        }
        if (template.getOrderItems() == null) {
            template.setOrderItems(new HashMap());
        }
        if (items == null) {
            return template;
        }
        for (int i = 0; i < items.size(); ++i) {
            PlottOrderItemTemplate poi = (PlottOrderItemTemplate)items.get(i);
            if (poi.getOrderContract() == null) {
                poi.setOrderContract(template);
            }
            if (poi.getPlottProperties().getCount() <= 0 || poi.getDeliveryAddressId() == null && !template.getTemplateResolver().equals("ManualPlotTemplate")) continue;
            PlottOrderItemTemplate newItem = null;
            newItem = poi.getId() == null || poi.getId() < 0 ? this.orderDAO.savePlottOrderItemTemplate(poi) : this.orderDAO.updatePlottOrderItemTemplate(poi);
            template.getOrderItems().put(newItem.getId(), newItem);
            PlottProperties props = poi.getPlottProperties();
            poi.setPlottProperties(this.saveOrUpdatePlottProperties(props));
        }
        return this.orderDAO.updatePlottOrderTemplate(template);
    }

    @Override
    public void deleteTemplate(PlottOrderTemplate template) {
        if (template.getOrderItems() != null && !template.getOrderItems().isEmpty()) {
            Collection coll = template.getOrderItems().values();
            for (PlottOrderItemTemplate item : coll) {
                this.deleteTemplateItem(item);
            }
        }
        OrderAddress oa = null;
        if (template.getBillingAddressId() != null) {
            oa = this.orderDAO.getOrderAddress(template.getBillingAddressId());
        }
        this.orderDAO.delete(template);
        if (oa != null) {
            this.orderDAO.deleteOrderAddress(oa);
        }
    }

    @Override
    public boolean updateInvalidateTemplate(PlottOrderTemplate template) {
        if (!template.getListeners().values().isEmpty()) {
            return false;
        }
        if (template.getOrderItems() != null && !template.getOrderItems().isEmpty()) {
            Collection coll = template.getOrderItems().values();
            for (PlottOrderItemTemplate item : coll) {
                this.updateInvalidateTemplateItem(item);
            }
        }
        template.setInvalidated(true);
        this.orderDAO.updatePlottOrderTemplate(template);
        return true;
    }

    @Override
    public void deleteTemplateWithReferences(Integer templateId) {
        PlottOrderTemplate template = this.getTemplate(templateId);
        Collection listeners = template.getListeners().values();
        for (ReviewCycleNodeInstancePlottOrderListener listener : listeners) {
            this.reviewCycleNodeListenerDAO.delete(listener);
        }
        template.setListeners(new HashMap());
        if (!this.updateInvalidateTemplate(template)) {
            throw new ActionException("Could not delete template!");
        }
    }

    @Override
    public List<String> getTemplateReferences(Integer plottOrderTemplateId) {
        ArrayList<String> refs = new ArrayList<String>();
        PlottOrderTemplate template = this.getTemplate(plottOrderTemplateId);
        Collection listenerInstances = template.getListeners().values();
        for (ReviewCycleNodeInstancePlottOrderListener listener : listenerInstances) {
            refs.add("Zugewiesen als Vorlage f\u00fcr automatisch generierte Plotauftr\u00e4ge im Pr\u00fcfknoten '" + TapestryI18nHelper.getLocaleString(listener.getReviewCycleNodeInstance().getReviewCycleNode().getName(), "de") + "' aus dem Pr\u00fcfblatt '" + listener.getReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance().getName() + "'");
        }
        return refs;
    }

    @Override
    public void deletePlottOrder(PlottOrder order) {
        ReviewCyclePlottTaskDone pTaskDone;
        OrderStepImpl osAcc = order.getAcceptance();
        OrderStepImpl osReq = order.getRequest();
        ReviewCyclePlottTask pTask = this.taskOperations.getReviewCyclePlottTask(osAcc.getId());
        if (pTask != null) {
            this.taskOperations.removeTask(pTask.getId());
        }
        if ((pTaskDone = this.taskOperations.getReviewCyclePlottTaskDone(osAcc.getId())) != null) {
            this.taskOperations.removeTask(pTaskDone.getId());
        }
        Collection pAcceptanceTasks = this.taskOperations.getPlottAcceptanceTasks(order.getId());
        for (Object pAcceptanceTask : pAcceptanceTasks) {
            this.taskOperations.removeTask(((TaskBase)pAcceptanceTask).getId());
        }
        Collection pAcceptanceTasksDone = this.taskOperations.getPlottAcceptanceTasksDone(order.getId());
        for (PlotOrderAcceptanceTaskDone pAcceptanceTaskDone : pAcceptanceTasksDone) {
            this.taskOperations.removeTask(pAcceptanceTaskDone.getId());
        }
        if (order.getOrderItems() != null && !order.getOrderItems().isEmpty()) {
            Collection items = order.getOrderItems().values();
            for (PlottOrderItem item : items) {
                this.deletePlottOrderItem(item);
            }
        }
        this.orderDAO.delete(order);
        if (osAcc != null) {
            this.orderDAO.delete(osAcc);
        }
        if (osReq != null) {
            this.orderDAO.delete(osReq);
        }
        logger.info((Object)("PlottOrder [id=" + order.getId() + "] successfully deleted!"));
    }

    @Override
    public void deletePlottOrderItem(PlottOrderItem item) {
        if (item == null) {
            return;
        }
        this.orderDAO.delete(item);
        if (item.getPlottProperties() != null) {
            this.orderDAO.deletePlottProperties(item.getPlottProperties());
        }
        if (item.getDeliveryAddress() != null) {
            this.orderDAO.deleteOrderAddress(item.getDeliveryAddress());
        }
    }

    @Override
    public void deletePlottOrderItemsByDocumentVersion(Integer documentVersionId) {
        List plottOrderItems = this.orderDAO.getPlotOrderItemsByDocumentVersion(documentVersionId);
        if (plottOrderItems == null || plottOrderItems.isEmpty()) {
            return;
        }
        PlottOrder plottOrder = ((PlottOrderItem)plottOrderItems.iterator().next()).getOrderContract();
        int numberOfOrdersItems = plottOrder.getOrderItems().size();
        int numberOfItemsToDelete = plottOrderItems.size();
        if (numberOfItemsToDelete == numberOfOrdersItems) {
            this.deletePlottOrder(plottOrder);
        } else {
            for (PlottOrderItem plottOrderItem : plottOrderItems) {
                this.deletePlottOrderItem(plottOrderItem);
            }
        }
    }

    @Override
    public PlottOrder generatePlottOrderFromTemplateSigned(PlottOrderTemplate template, ProjectParticipation plotter, ProjectParticipant signer, CDESCertificate cert, String password, DocumentVersion version) throws WrongPasswordException {
        PlottOrder order = new PlottOrder();
        TemplatePropertyResolver resolver = this.plotOrderTemplateResolverRegistry.lookupResolver(template.getTemplateResolver());
        order = resolver.resolveProperties(version, order, template, false);
        order = this.generatePlottOrder(order, plotter, signer, cert, password, version);
        return order;
    }

    @Override
    public PlottOrder generatePlottOrderFromTemplate(PlottOrderTemplate template, ProjectParticipant client, ProjectParticipation plotter, DocumentVersion version) {
        TemplatePropertyResolver resolver = this.plotOrderTemplateResolverRegistry.lookupResolver(template.getTemplateResolver());
        PlottOrder order = null;
        Collection openPOs = this.getPlottOrdersByPlotter(template.getProject().getId(), plotter.getOrganisation().getId(), true);
        boolean orderFound = false;
        for (PlottOrder o : openPOs) {
            if (!o.getBillingAddress().getId().equals(template.getBillingAddressId())) continue;
            order = o;
            orderFound = true;
            break;
        }
        if (openPOs.isEmpty() || !orderFound) {
            order = new PlottOrder();
            if ((order = resolver.resolveProperties(version, order, template, false)) == null) {
                return null;
            }
            order = this.saveOrUpdatePlottOrder(order);
            OrderStepImpl req = this.generateOrderStep(client.getParticipation());
            Network network = client.getParticipation().getProject().getNetwork();
            this.finishOrderStep(req, client, network);
            OrderStepImpl acc = this.generateOrderStep(plotter);
            order.setRequest(req);
            order.setAcceptance(acc);
            this.taskOperations.generateReviewCyclePlottTask(version, order, acc, plotter, true);
            logger.info((Object)("Generated PlottOrder [template=" + template.getName() + "] [version=" + version.getName() + "]"));
        } else {
            if ((order = resolver.resolveProperties(version, order, template, true)) == null) {
                return null;
            }
            order = this.saveOrUpdatePlottOrder(order);
            logger.info((Object)("PlottOrderItem added [orderJobNumber=" + order.getJobNumber() + "] [version=" + version.getName() + "]"));
        }
        return order;
    }

    @Override
    public PlottOrder generatePlottOrder(PlottOrder order, ProjectParticipation plotter, ProjectParticipant signer, CDESCertificate cert, String password, DocumentVersion version) throws WrongPasswordException {
        order = this.saveOrUpdatePlottOrder(order);
        OrderStepImpl req = this.generateOrderStep(signer.getParticipation());
        this.signOrderStep(req, signer, cert, password);
        OrderStepImpl acc = this.generateOrderStep(plotter);
        order.setRequest(req);
        order.setAcceptance(acc);
        this.taskOperations.generateReviewCyclePlottTask(version, order, acc, plotter, true);
        return order;
    }

    private PlottOrder saveOrUpdatePlottOrder(PlottOrder order) {
        Collection items = order.getOrderItems().values();
        if (order.getId() == null) {
            OrderAddress billingAddress = order.getBillingAddress();
            billingAddress = this.saveOrUpdateOrderAddress(billingAddress);
            order.setBillingAddress(billingAddress);
            order.setJobNumber(this.jobNumberGenerator.getJobNumber());
            order = this.orderDAO.savePlottOrder(order);
        }
        HashMap<Integer, PlottOrderItem> newItems = new HashMap<Integer, PlottOrderItem>();
        for (PlottOrderItem item : items) {
            OrderAddress deliveryAddress = item.getDeliveryAddress();
            item.setDeliveryAddress(this.saveOrUpdateOrderAddress(deliveryAddress));
            PlottProperties props = item.getPlottProperties();
            item.setPlottProperties(this.saveOrUpdatePlottProperties(props));
            item.setOrderContract(order);
            PlottOrderItem newItem = this.orderDAO.savePlottOrderItem(item);
            newItems.put(newItem.getId(), newItem);
        }
        order.setOrderItems(newItems);
        this.orderDAO.updateMergePlottOrder(order);
        return order;
    }

    @Override
    public PlottOrder acceptPlottOrder(PlottOrder order, ProjectParticipant signer, CDESCertificate cert, String password, ReviewCyclePlottTask task, boolean generateTask) throws WrongPasswordException {
        OrderStepImpl acc = order.getAcceptance();
        acc = this.signOrderStep(acc, signer, cert, password);
        this.orderDAO.updateOrderStep(acc);
        order.setAcceptance(acc);
        if (generateTask) {
            this.taskOperations.doReviewCyclePlottTask(task, acc);
            OrderStepImpl com = this.generateOrderStep(signer.getParticipation());
            order.setCompleted(com);
            if (acc.getAcceptedMode() == 1) {
                this.taskOperations.generateReviewCyclePlottTask(task.getDocumentVersion(), order, com, signer.getParticipation(), false);
            }
        }
        this.orderDAO.updatePlottOrder(order);
        return order;
    }

    @Override
    public PlottOrderItem getPlottOrderItemByStep(OrderStep step) {
        Integer orderItemId = step.getOrderItemId();
        if (orderItemId == null) {
            return null;
        }
        return this.orderDAO.getPlottOrderItem(orderItemId);
    }

    @Override
    public PlottOrderItem getPlottOrderItem(Integer itemId) {
        if (itemId == null) {
            return null;
        }
        return this.orderDAO.getPlottOrderItem(itemId);
    }

    @Override
    public PlottOrder completePlottOrder(Integer orderId, String comment, int acceptedMode, ProjectParticipant signer, CDESCertificate cert, String password, ReviewCyclePlottTask task) throws WrongPasswordException {
        OrderStepImpl com;
        ArrayList<ProjectParticipation> ppList = new ArrayList<ProjectParticipation>();
        PlottOrder order = this.getPlottOrder(orderId);
        if (order.getCompleted() != null) {
            com = order.getCompleted();
            com.setAcceptedMode(acceptedMode);
            com.setComment(comment);
            com = this.signOrderStep(com, signer, cert, password);
        } else {
            com = order.getAcceptance();
        }
        this.taskOperations.doReviewCyclePlottTask(task, com);
        order.setCompleted(com);
        if (order.getCompleted().getAcceptedMode() != 2) {
            if (order.getReceived() == null) {
                order.setReceived(new HashMap());
            }
            Collection items = order.getOrderItems().values();
            for (PlottOrderItem item : items) {
                if (item.getReceiverId() == null || item.getDocumentVersion().isInvalidatedOrDeleted()) continue;
                ProjectParticipation pp = this.projectParticipationDAO.get(item.getReceiverId());
                if (!ppList.contains(pp)) {
                    ppList.add(pp);
                }
                OrderStepImpl recOrderStep = this.generateOrderStep(this.resolveReceiverOfItem(item));
                recOrderStep.setOrderItemId(item.getId());
                this.orderDAO.updateOrderStep(recOrderStep);
                order.getReceived().put(recOrderStep.getId(), recOrderStep);
            }
        }
        this.orderDAO.updatePlottOrder(order);
        if (order.getCompleted() != null && order.getCompleted().getFinished() != null && order.getCompleted().getAcceptedMode() == 1) {
            this.taskOperations.generatePlotOrderAcceptanceTasks(task, ppList);
        }
        return order;
    }

    @Override
    public PlottOrder receivePlottOrder(PlottOrder order, Collection<Integer> selectedStepIds, boolean deleteTask, String password, Integer activeOrganisationPersonId, String comment, int acceptedMode) throws WrongPasswordException {
        ProjectParticipant signer = null;
        ArrayList<Integer> ppIdList = new ArrayList<Integer>();
        for (Integer selectedStepId : selectedStepIds) {
            OrderStepImpl step = this.orderDAO.getOrderStep(selectedStepId);
            step.setComment(comment);
            step.setAcceptedMode(acceptedMode);
            TemplatePropertyResolver resolver = this.plotOrderTemplateResolverRegistry.lookupResolver(order.getTemplate().getTemplateResolver());
            PlottOrderItem item = resolver.resolvePlottOrderItem(step.getOrderItemId());
            if (!ppIdList.contains(item.getReceiverId())) {
                ppIdList.add(item.getReceiverId());
            }
            signer = this.reviewOperations.getSignerByParticipation(activeOrganisationPersonId, item.getReceiverId());
            CDESCertificate cert = this.certificateOperations.getSignerCertificate(activeOrganisationPersonId, false);
            if (cert == null) {
                throw new NoCertificateException();
            }
            step = this.signOrderStep(step, signer, cert, password);
            this.orderDAO.updateOrderStep(step);
        }
        List<PlotOrderAcceptanceTask> allPlotOrderAcceptanceTasks = this.taskDAO.getPlotOrderAcceptanceTasksByPlotOrder(order.getId());
        for (PlotOrderAcceptanceTask plotOrderAcceptanceTask : allPlotOrderAcceptanceTasks) {
            Integer tasksPPId = plotOrderAcceptanceTask.getProjectParticipationId();
            if (!ppIdList.contains(tasksPPId)) continue;
            boolean allStepsSigned = true;
            List ppItems = this.orderDAO.getAllOrderItemsOfReceiverAndPlottOrder(tasksPPId, order.getId());
            for (PlottOrderItem ppItem : ppItems) {
                OrderStepImpl ppOrderStep = this.orderDAO.getOrderStepByOrderItemId(ppItem.getId());
                if (ppOrderStep == null || ppOrderStep.getSignature() != null) continue;
                allStepsSigned = false;
                break;
            }
            if (!allStepsSigned || !deleteTask) continue;
            this.taskOperations.doPlotOrderAcceptanceTask(plotOrderAcceptanceTask);
        }
        return order;
    }

    private OrderStepImpl generateOrderStep(Object owner) {
        if (owner instanceof ProjectParticipation) {
            ProjectParticipationOrderStep step = new ProjectParticipationOrderStep();
            step.setCreated(new Date(System.currentTimeMillis()));
            step.setProjectParticipation((ProjectParticipation)owner);
            return this.orderDAO.saveOrderStep(step);
        }
        if (owner instanceof Organisation) {
            OrganisationOrderStep step = new OrganisationOrderStep();
            step.setCreated(new Date(System.currentTimeMillis()));
            step.setOrganisation((Organisation)owner);
            return this.orderDAO.saveOrderStep(step);
        }
        if (owner instanceof OrganisationPerson) {
            OrganisationPersonOrderStep step = new OrganisationPersonOrderStep();
            step.setCreated(new Date(System.currentTimeMillis()));
            step.setOrganisationPerson((OrganisationPerson)owner);
            return this.orderDAO.saveOrderStep(step);
        }
        return null;
    }

    private OrderStepImpl signOrderStep(OrderStepImpl step, ProjectParticipant signer, CDESCertificate cert, String password) throws WrongPasswordException {
        step.setFinished(new Date(System.currentTimeMillis()));
        step.setSignerFromObject(signer);
        Network network = signer.getParticipation().getProject().getNetwork();
        try {
            DigestCalculator dig = this.digestCalculatorFactory.getDigestCalculator(network, step);
            DigestCalculatorType t = this.digestCalculatorDAO.get(dig.getClass().getName());
            step.setDigestCalculatorType(t);
            step.setDigest(dig.getDigest(step));
            SignatureCalculator sig = this.signatureCalculatorFactory.getSignatureCalculator(network, step);
            CDESSignature sign = sig.createSignature(signer, dig.getSignableContent(step), cert, password);
            sign = this.signatureDAO.save(sign);
            step.setSignature(sign);
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("A digest error occured", e);
        }
        catch (SignatureCalculatorException e) {
            throw new ActionException("A signature error occured", e);
        }
        return this.orderDAO.updateOrderStep(step);
    }

    private void finishOrderStep(OrderStepImpl step, Object finisher, Network network) {
        step.setFinished(new Date(System.currentTimeMillis()));
        step.setSignerFromObject(finisher);
        try {
            DigestCalculator dig = this.digestCalculatorFactory.getDigestCalculator(network, step);
            DigestCalculatorType t = this.digestCalculatorDAO.get(dig.getClass().getName());
            step.setDigestCalculatorType(t);
            step.setDigest(dig.getDigest(step));
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("A digest error occured", e);
        }
        this.orderDAO.updateOrderStep(step);
    }

    @Override
    public OrderAddress saveOrUpdateOrderAddress(OrderAddress oa) {
        if (oa == null) {
            return null;
        }
        if (oa.getId() == null) {
            return this.orderDAO.saveOrderAddress(oa);
        }
        return this.orderDAO.updateOrderAddress(oa);
    }

    @Override
    public PlottProperties saveOrUpdatePlottProperties(PlottProperties oa) {
        if (oa == null) {
            return null;
        }
        if (oa.getId() == null) {
            return this.orderDAO.savePlottProperties(oa);
        }
        return this.orderDAO.updatePlottProperties(oa);
    }

    @Override
    public OriginalDocumentOrder requestOriginalDocumentOrderWithOthers(DocumentVersion version, OrganisationPerson organisationPerson, Collection<Organisation> otherOrganisations, String comment) {
        OrganisationPerson op = this.organisationPersonDAO.get(organisationPerson.getId());
        OriginalDocumentOrder order = this.requestOriginalDocumentOrder(version, organisationPerson, organisationPerson.getOrganisation(), comment);
        if (otherOrganisations == null) {
            otherOrganisations = new ArrayList<Organisation>();
        }
        otherOrganisations.add(organisationPerson.getOrganisation());
        for (Organisation organisation : otherOrganisations) {
            OriginalDocumentOrderItem item = new OriginalDocumentOrderItem();
            item.setDeliveryAddress(null);
            item.setDocumentVersion(version);
            item.setOrderContract(order);
            item.setReceiverId(organisation.getId());
            item.setReceiverType(1);
            this.orderDAO.saveOriginalDocumentOrderItem(item);
        }
        return order;
    }

    @Override
    public OriginalDocumentOrder requestOriginalDocumentOrder(Integer documentVersionid, Integer organisationPersonId, String comment) {
        OrganisationPerson op = this.organisationPersonDAO.get(organisationPersonId);
        DocumentVersion dv = this.reviewOperations.getDocumentVersion(documentVersionid);
        OriginalDocumentOrder order = this.requestOriginalDocumentOrder(dv, op, op, comment);
        OriginalDocumentOrderItem item = new OriginalDocumentOrderItem();
        item.setDeliveryAddress(null);
        item.setDocumentVersion(dv);
        item.setOrderContract(order);
        item.setReceiverId(organisationPersonId);
        item.setReceiverType(2);
        this.orderDAO.saveOriginalDocumentOrderItem(item);
        return order;
    }

    private OriginalDocumentOrder requestOriginalDocumentOrder(DocumentVersion version, OrganisationPerson organisationPerson, Object stepOwner, String comment) {
        OriginalDocumentOrder order = new OriginalDocumentOrder();
        SubProject sp = version.getDocument().getDocumentList().getSubProject();
        ReleasedObjectList objectList = sp.getActiveObjectList();
        ObjectPlannerImpl objectPlanner = (ObjectPlannerImpl)version.getDocument().getObjectPlanner();
        ReleasedObjectPlanner releasedObjectPlanner = this.objectPlannerDAO.getReleasedObjectPlanner(objectList.getId(), objectPlanner.getId());
        ProjectParticipation planner = releasedObjectPlanner.getPlanner();
        order.setDocumentOwner(planner);
        order.setSubProject(sp);
        order = this.saveOriginalDocumentOrder(order);
        Network network = planner.getProject().getNetwork();
        OrderStepImpl req = this.generateOrderStep(stepOwner);
        this.finishOrderStep(req, organisationPerson, network);
        req.setComment(comment);
        OrderStepImpl acc = this.generateOrderStep(planner);
        order.setRequest(req);
        order.setAcceptance(acc);
        this.taskOperations.generateOriginalDocumentTask(version, order, acc, planner, true);
        return order;
    }

    private OriginalDocumentOrder saveOriginalDocumentOrder(OriginalDocumentOrder order) {
        Collection items = null;
        if (order.getOrderItems() != null) {
            items = order.getOrderItems().values();
        }
        order.setJobNumber(this.jobNumberGenerator.getJobNumber());
        order = this.orderDAO.saveOriginalDocumentOrder(order);
        if (items == null) {
            return order;
        }
        HashMap<Integer, OriginalDocumentOrderItem> newItems = new HashMap<Integer, OriginalDocumentOrderItem>();
        for (OriginalDocumentOrderItem item : items) {
            OrderAddress deliveryAddress = item.getDeliveryAddress();
            item.setDeliveryAddress(this.saveOrUpdateOrderAddress(deliveryAddress));
            item.setOrderContract(order);
            OriginalDocumentOrderItem newItem = this.orderDAO.saveOriginalDocumentOrderItem(item);
            newItems.put(newItem.getId(), newItem);
        }
        order.setOrderItems(newItems);
        this.orderDAO.updateOriginalDocumentOrder(order);
        return order;
    }

    @Override
    public OriginalDocumentOrder acceptOriginalDocumentOrder(OriginalDocumentOrder order, ProjectParticipant signer, OriginalDocumentTask task, CDESCertificate cert, String password, int acceptedMode) throws WrongPasswordException {
        OrderStepImpl acc = order.getAcceptance();
        acc.setFinished(new Date());
        acc.setAcceptedMode(acceptedMode);
        this.signOrderStep(acc, signer, cert, password);
        this.orderDAO.updateOrderStep(acc);
        order.setAcceptance(acc);
        this.taskOperations.doOriginalDocumentTask(task, acc);
        if (acceptedMode == 2) {
            return order;
        }
        OrderStepImpl com = this.generateOrderStep(signer.getParticipation());
        order.setCompleted(com);
        this.taskOperations.generateOriginalDocumentTask(task.getDocumentVersion(), order, com, signer.getParticipation(), false);
        return order;
    }

    @Override
    public OriginalDocumentOrder receiveOriginalDocumentOrder(OriginalDocumentOrder order, Collection<Integer> steps, String password, Integer activeOrganisationPersonId) throws WrongPasswordException {
        for (Integer id : steps) {
            OrderStepImpl step = this.orderDAO.getOrderStep(id);
            OriginalDocumentOrderItem item = this.resolveOriginalDocumentOrderItem(step.getOrderItemId());
            ProjectParticipant signer = this.reviewOperations.getSignerByParticipation(activeOrganisationPersonId, item.getReceiverId());
            CDESCertificate cert = this.certificateOperations.getSignerCertificate(activeOrganisationPersonId, false);
            if (cert == null) {
                throw new NoCertificateException();
            }
            step = this.signOrderStep(step, signer, cert, password);
            this.orderDAO.updateOrderStep(step);
        }
        return order;
    }

    @Override
    public OriginalDocumentOrder completeOriginalDocumentOrder(OriginalDocumentOrder order, ProjectParticipant signer, CDESCertificate cert, String password, OriginalDocumentTask task, IMimeInputStream uploadFile) throws WrongPasswordException {
        try {
            OrderStepImpl com = order.getCompleted();
            com = this.signOrderStep(com, signer, cert, password);
            this.taskOperations.doOriginalDocumentTask(task, com);
            order.setCompleted(com);
            OriginalDocumentOrderItem orderItem = (OriginalDocumentOrderItem)order.getOrderItems().values().iterator().next();
            DataSource ds = DataSourceHelper.toDataSource(uploadFile);
            String fileName = this.uploadHandler.saveOriginalDocument(orderItem.getDocumentVersion(), ds.getName(), ds.getInputStream());
            order.setFileName(fileName);
        }
        catch (FileHandleException e) {
            throw new ActionException("Saving original document", e);
        }
        catch (IOException e) {
            throw new ActionException("Error getting InputStream of original document", e);
        }
        catch (IOError e) {
            throw new ActionException("Error getting InputStream of original document", e);
        }
        finally {
            try {
                uploadFile.close();
            }
            catch (Throwable e) {
                logger.warn((Object)"IOError closing InputStream of original document", e);
            }
        }
        if (order.getReceived() == null) {
            order.setReceived(new HashMap());
        }
        ArrayList items = new ArrayList(order.getOrderItems().values());
        for (OriginalDocumentOrderItem item : items) {
            if (item.getReceiverId() == null) continue;
            OrderStepImpl rec = this.generateOrderStep(this.resolveReceiverOfItem(item));
            rec.setOrderItemId(item.getId());
            this.orderDAO.updateOrderStep(rec);
            order.getReceived().put(rec.getId(), rec);
            this.orderDAO.updateOriginalDocumentOrder(order);
            this.taskOperations.generateStatusEMailSnippetForOriginalDocumentOrderItem(item, 9);
        }
        return order;
    }

    public Object resolveReceiverOfItem(OrderItem item) {
        Integer recId = item.getReceiverId();
        if (item.getReceiverType() == 2) {
            return this.organisationPersonDAO.get(recId);
        }
        if (item.getReceiverType() == 0) {
            return this.projectParticipationDAO.get(recId);
        }
        if (item.getReceiverType() == 1) {
            return this.organisationDAO.get(recId);
        }
        return null;
    }

    public void setOrderDAO(OrderDAO orderDAO) {
        this.orderDAO = orderDAO;
    }

    public void setTaskDAO(TaskDAO taskDAO) {
        this.taskDAO = taskDAO;
    }

    public void setMailDAO(EMailDAO mailDAO) {
        this.mailDAO = mailDAO;
    }

    public void setTaskOperations(TaskOperations taskOperations) {
        this.taskOperations = taskOperations;
    }

    public void setDigestCalculatorFactory(DigestCalculatorFactory digestCalculatorFactory) {
        this.digestCalculatorFactory = digestCalculatorFactory;
    }

    public void setSignatureCalculatorFactory(SignatureCalculatorFactory signatureCalculatorFactory) {
        this.signatureCalculatorFactory = signatureCalculatorFactory;
    }

    public void setSignatureDAO(SignatureDAO signatureDAO) {
        this.signatureDAO = signatureDAO;
    }

    public void setDigestCalculatorDAO(DigestCalculatorDAO digestCalculatorDAO) {
        this.digestCalculatorDAO = digestCalculatorDAO;
    }

    public void setPlotOrderTemplateResolverRegistry(PlotOrderTemplateResolverRegistry plotOrderTemplateResolverRegistry) {
        this.plotOrderTemplateResolverRegistry = plotOrderTemplateResolverRegistry;
    }

    public void setJobNumberGenerator(JobNumberGenerator jobNumberGenerator) {
        this.jobNumberGenerator = jobNumberGenerator;
    }

    @Override
    public Collection getTemplatesOfProject(Integer projectId) {
        return this.orderDAO.getTemplatesOfProject(projectId);
    }

    @Override
    public Collection getValidTemplatesOfProject(Integer projectId) {
        return this.orderDAO.getValidTemplatesOfProject(projectId);
    }

    @Override
    public PlottOrderItemTemplate getTemplateItem(Integer id) {
        return this.orderDAO.getPlottOrderItemTemplate(id);
    }

    @Override
    public PlottOrderItemTemplate saveOrUpdateTemplateItem(PlottOrderItemTemplate oa) {
        if (oa == null) {
            return null;
        }
        if (oa.getId() == null) {
            return this.orderDAO.savePlottOrderItemTemplate(oa);
        }
        return this.orderDAO.updatePlottOrderItemTemplate(oa);
    }

    @Override
    public void deleteTemplateItem(PlottOrderItemTemplate template) {
        if (template == null) {
            return;
        }
        if (template.getPlottProperties() != null) {
            this.orderDAO.deletePlottProperties(template.getPlottProperties());
        }
        this.orderDAO.delete(template);
    }

    @Override
    public void updateInvalidateTemplateItem(PlottOrderItemTemplate template) {
        if (template == null) {
            return;
        }
        template.setInvalidated(true);
        this.orderDAO.updatePlottOrderItemTemplate(template);
    }

    @Override
    public OrderAddress getOrderAddress(Integer id) {
        return this.orderDAO.getOrderAddress(id);
    }

    @Override
    public List<OrderAddress> getOrderAddresses(Integer project_id, Integer type) {
        return this.orderDAO.getOrderAddresses(project_id, type);
    }

    @Override
    public Collection getPlottOrders(Integer projectId) {
        return this.orderDAO.getPlottOrders(projectId);
    }

    @Override
    public Collection getPlottOrdersByPlotter(Integer projectId, Integer plotterOrgId, boolean unaccepted) {
        return this.orderDAO.getPlottOrdersByPlotter(projectId, plotterOrgId, unaccepted);
    }

    @Override
    public PlottOrder getPlottOrder(Integer orderId) {
        return this.orderDAO.getPlottOrder(orderId);
    }

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }

    @Override
    public OrderStep getPlottOrderStepByOrderItemId(Integer id) {
        return this.orderDAO.getOrderStepByOrderItemId(id);
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public OriginalDocumentOrderItem resolveOriginalDocumentOrderItem(Integer orderItemId) {
        if (orderItemId == null) {
            return null;
        }
        return this.orderDAO.getOriginalDocumentOrderItem(orderItemId);
    }

    public void setOrganisationDAO(OrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    @Override
    public Collection<OriginalDocumentOrder> getOriginalDocumentOrders(Integer activeSubProjectId) {
        return this.orderDAO.getOriginalDocumentOrders(activeSubProjectId);
    }

    public void setUploadHandler(UploadFileHandler uploadHandler) {
        this.uploadHandler = uploadHandler;
    }

    @Override
    public void deleteOriginalDocumentTask(OriginalDocumentTask task) {
        Collection items;
        OriginalDocumentOrder order = task.getOrder();
        if (order.getOrderItems() != null) {
            items = order.getOrderItems().values();
            for (CdesDataObject item : items) {
                this.orderDAO.delete((OriginalDocumentOrderItem)item);
            }
        }
        order.setOrderItems(null);
        this.orderDAO.delete(order.getAcceptance());
        this.orderDAO.delete(order.getCompleted());
        if (order.getReceived() != null) {
            items = order.getReceived().values();
            for (CdesDataObject item : items) {
                this.orderDAO.delete((OrderStep)item);
            }
        }
        order.setReceived(null);
        this.orderDAO.delete(order.getRequest());
        this.orderDAO.delete(order);
        this.taskOperations.removeTask(task.getId());
    }

    @Override
    public PlottOrder generateManualPlottOrder(String comment, DocumentVersion docVersion, PlottOrderTemplate template, List<PlottOrderItemTemplate> items, ProjectParticipation plotter, Project project, ProjectParticipant signer, CDESCertificate cert, String password) throws WrongPasswordException {
        PlottProperties sourcePP;
        PlottProperties destinationPP;
        Object address;
        ProjectParticipation receiverParticipation;
        List<ProjectParticipation> deliveryParts;
        OrganisationPerson receiverOrgPerson;
        PlottOrderItem newItem;
        if (!this.personOperations.checkPersonPassword(signer.getOrganisationPerson().getPerson(), password)) {
            throw new WrongPasswordException();
        }
        Collection openPOs = this.getPlottOrdersByPlotter(project.getId(), plotter.getOrganisation().getId(), true);
        PlottOrder order = new PlottOrder();
        OrderAddressExtractorVisitorImpl visitor = new OrderAddressExtractorVisitorImpl();
        boolean orderFound = false;
        for (PlottOrder o : openPOs) {
            if (!o.getBillingAddress().getId().equals(template.getBillingAddressId())) continue;
            orderFound = true;
            order = o;
            break;
        }
        if (openPOs.size() == 0 || !orderFound) {
            order.setOrderItems(new HashMap());
            order.setBillingAddress(this.orderDAO.getOrderAddress(template.getBillingAddressId()));
            order.setPlotter(this.projectParticipationDAO.get(template.getPlotterId()).getOrganisation());
            order.setTemplate(this.getTemplate(template.getId()));
            order.setProject(template.getProject());
            order.setKindOfDelivery(template.getKindOfDelivery());
            order.setComment(comment);
            order = this.saveOrUpdatePlottOrder(order);
            for (PlottOrderItemTemplate itemTempl : items) {
                newItem = new PlottOrderItem();
                newItem.setDocumentVersion(docVersion);
                newItem.setOrderContract(order);
                receiverOrgPerson = this.organisationPersonDAO.get(itemTempl.getDeliveryAddressId());
                newItem.setReceiverOrganisationPerson(receiverOrgPerson);
                deliveryParts = this.projectParticipationDAO.getAllOfOrganisationPerson(project.getId(), receiverOrgPerson.getId());
                receiverParticipation = null;
                for (ProjectParticipation deliveryPart : deliveryParts) {
                    if (!deliveryPart.getMainParticipant().getOrganisationPerson().getId().equals(receiverOrgPerson.getId())) continue;
                    receiverParticipation = deliveryPart;
                    break;
                }
                if (receiverParticipation == null) {
                    receiverParticipation = deliveryParts.get(0);
                }
                newItem.setReceiverId(receiverParticipation.getId());
                newItem.setReceiverType(0);
                newItem.setInitiator(signer);
                address = receiverOrgPerson.accept(visitor);
                address = this.orderDAO.saveOrderAddress((OrderAddress)address);
                newItem.setDeliveryAddress((OrderAddress)address);
                destinationPP = new PlottProperties();
                sourcePP = itemTempl.getPlottProperties();
                destinationPP.setCount(sourcePP.getCount());
                destinationPP.setColor(sourcePP.getColor());
                destinationPP.setMargin(sourcePP.getMargin());
                destinationPP.setMirroring(sourcePP.isMirroring());
                destinationPP.setPaperQuality(sourcePP.getPaperQuality());
                destinationPP.setScale(sourcePP.getScale());
                destinationPP.setLlx(docVersion.getLlx());
                destinationPP.setLly(docVersion.getLly());
                destinationPP.setUrx(docVersion.getUrx());
                destinationPP.setUry(docVersion.getUry());
                destinationPP.setUserUnit(docVersion.getUserUnit());
                destinationPP = this.orderDAO.savePlottProperties(destinationPP);
                newItem.setPlottProperties(destinationPP);
                newItem = this.orderDAO.savePlottOrderItem(newItem);
                order.getOrderItems().put(newItem.getId(), newItem);
            }
            order = this.saveOrUpdatePlottOrder(order);
            OrderStepImpl req = this.generateOrderStep(signer.getParticipation());
            Network network = project.getNetwork();
            this.finishOrderStep(req, signer.getParticipation(), network);
            OrderStepImpl acc = this.generateOrderStep(plotter);
            order.setRequest(req);
            order.setAcceptance(acc);
            this.taskOperations.generateReviewCyclePlottTask(docVersion, order, acc, plotter, true);
        } else {
            for (PlottOrderItemTemplate itemTempl : items) {
                newItem = new PlottOrderItem();
                newItem.setDocumentVersion(docVersion);
                newItem.setOrderContract(order);
                newItem.setInitiator(signer);
                receiverOrgPerson = this.organisationPersonDAO.get(itemTempl.getDeliveryAddressId());
                newItem.setReceiverOrganisationPerson(receiverOrgPerson);
                deliveryParts = this.projectParticipationDAO.getAllOfOrganisationPerson(project.getId(), receiverOrgPerson.getId());
                receiverParticipation = null;
                for (ProjectParticipation deliveryPart : deliveryParts) {
                    if (!deliveryPart.getMainParticipant().getOrganisationPerson().getId().equals(receiverOrgPerson.getId())) continue;
                    receiverParticipation = deliveryPart;
                    break;
                }
                if (receiverParticipation == null) {
                    receiverParticipation = deliveryParts.get(0);
                }
                newItem.setReceiverId(receiverParticipation.getId());
                newItem.setReceiverType(0);
                address = this.organisationPersonDAO.get(itemTempl.getDeliveryAddressId()).accept(visitor);
                address = this.orderDAO.saveOrderAddress((OrderAddress)address);
                newItem.setDeliveryAddress((OrderAddress)address);
                destinationPP = new PlottProperties();
                sourcePP = itemTempl.getPlottProperties();
                destinationPP.setCount(sourcePP.getCount());
                destinationPP.setColor(sourcePP.getColor());
                destinationPP.setMargin(sourcePP.getMargin());
                destinationPP.setMirroring(sourcePP.isMirroring());
                destinationPP.setPaperQuality(sourcePP.getPaperQuality());
                destinationPP.setScale(sourcePP.getScale());
                destinationPP.setLlx(docVersion.getLlx());
                destinationPP.setLly(docVersion.getLly());
                destinationPP.setUrx(docVersion.getUrx());
                destinationPP.setUry(docVersion.getUry());
                destinationPP.setUserUnit(docVersion.getUserUnit());
                destinationPP = this.orderDAO.savePlottProperties(destinationPP);
                newItem.setPlottProperties(destinationPP);
                newItem = this.orderDAO.savePlottOrderItem(newItem);
                order.getOrderItems().put(newItem.getId(), newItem);
            }
            if (comment != null && comment.length() > 0) {
                order.setComment(comment);
            }
            order = this.saveOrUpdatePlottOrder(order);
        }
        for (PlottOrderItemTemplate item : items) {
            item.setDeliveryAddressId(null);
            if (item.getId() == null || item.getId() <= 0) continue;
            this.saveOrUpdateTemplateItem(item);
        }
        return order;
    }

    @Override
    public List<PlottOrder> getOpenPlottOrdersForInitiator(OrderAddress billingAddress, Organisation plotter, Project activeProject) {
        ArrayList<PlottOrder> openOrders = new ArrayList<PlottOrder>();
        Collection orders = this.getPlottOrdersByPlotter(activeProject.getId(), plotter.getId(), true);
        for (PlottOrder order : orders) {
            if (!order.getBillingAddress().getId().equals(billingAddress.getId())) continue;
            openOrders.add(order);
        }
        return openOrders;
    }

    @Override
    public boolean existingOpenPlotOrdersForParticipant(ProjectParticipation participation, ProjectParticipant participant, Project project) {
        Collection orders = this.getPlottOrders(project.getId());
        OrganisationPerson orgPerson = participant.getOrganisationPerson();
        for (PlottOrder order : orders) {
            if (order.getAcceptance() != null && order.getAcceptance().getAcceptedMode() == 2 || order.getCompleted() != null && order.getCompleted().getAcceptedMode() == 2 || order.getReceived() != null && order.getReceived().values().size() > 0 && this.getReceivedSigned(order) == order.getReceived().values().size()) continue;
            Collection items = order.getOrderItems().values();
            for (PlottOrderItem item : items) {
                if (item.getTemplate() != null && !item.getTemplate().getOrderContract().getTemplateResolver().equals("ManualPlotTemplate") || item.getReceiverOrganisationPerson() == null || !item.getReceiverOrganisationPerson().getId().equals(orgPerson.getId()) || !item.getReceiverId().equals(participation.getId())) continue;
                if (order.getReceived() == null || order.getReceived().size() == 0) {
                    return true;
                }
                OrderStepImpl itemsStep = this.orderDAO.getOrderStepByOrderItemId(item.getId());
                if (itemsStep.getFinished() != null) continue;
                return true;
            }
        }
        return false;
    }

    private int getReceivedSigned(PlottOrder order) {
        if (order.getReceived() == null) {
            return 0;
        }
        Collection steps = order.getReceived().values();
        int count = 0;
        for (OrderStepImpl step : steps) {
            if (step.getFinished() == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean deleteInvalidOrdersAndCheckForExistingOpenPlotOrdersForSubProject(SubProject subProject) {
        Collection orders = this.getPlottOrders(subProject.getProject().getId());
        ArrayList<PlottOrder> plotOrdersToDelete = new ArrayList<PlottOrder>();
        for (PlottOrder order : orders) {
            HashMap<Integer, SubProject> affectedSubProjects = new HashMap<Integer, SubProject>();
            boolean foundOpenOrderForSubProject = false;
            if (order.getAcceptance() != null && order.getAcceptance().getAcceptedMode() == 2 || order.getCompleted() != null && order.getCompleted().getAcceptedMode() == 2) continue;
            Collection steps = order.getReceived().values();
            Collection items = order.getOrderItems().values();
            for (PlottOrderItem item : items) {
                SubProject sp = item.getDocumentVersion().getDocument().getDocumentList().getSubProject();
                affectedSubProjects.put(sp.getId(), sp);
                if (foundOpenOrderForSubProject || !sp.getId().equals(subProject.getId())) continue;
                if ((order.getCompleted() == null || order.getCompleted().getFinished() == null) && order.getAcceptance() != null && order.getAcceptance().getFinished() != null) {
                    return true;
                }
                if (order.getAcceptance() != null && order.getAcceptance().getFinished() != null && order.getCompleted() != null && order.getCompleted().getFinished() != null) continue;
                foundOpenOrderForSubProject = true;
            }
            if (!foundOpenOrderForSubProject) continue;
            if (affectedSubProjects.size() > 1) {
                return true;
            }
            plotOrdersToDelete.add(order);
        }
        if (!plotOrdersToDelete.isEmpty()) {
            for (PlottOrder order : plotOrdersToDelete) {
                this.deletePlottOrder(order);
            }
        }
        return false;
    }

    public void setCertificateOperations(CertificateOperations certificateOperations) {
        this.certificateOperations = certificateOperations;
    }

    public void setPersonOperations(PersonOperations personOperations) {
        this.personOperations = personOperations;
    }

    @Override
    public boolean checkHasOrderValidParticipantsInSubProject(Integer subProjectId, Integer plotOrderTemplateId) {
        PlottOrderTemplate template = this.getTemplate(plotOrderTemplateId);
        Collection items = template.getOrderItems().values();
        for (PlottOrderItemTemplate item : items) {
            ProjectParticipation pp;
            if (item.getDeliveryAddressId() == null || (pp = this.projectParticipationDAO.get(item.getDeliveryAddressId())) == null || !pp.getExcludedSubProjects().containsKey(subProjectId)) continue;
            return false;
        }
        return true;
    }

    public void setReviewCycleNodeListenerDAO(ReviewCycleNodeListenerDAO reviewCycleNodeListenerDAO) {
        this.reviewCycleNodeListenerDAO = reviewCycleNodeListenerDAO;
    }

    @Override
    public String getPlottOrderStatistics(List<Project> projects, Date from, Date until) {
        HashMap<String, Object[]> inColor = new HashMap<String, Object[]>();
        HashMap<String, Object[]> monochrome = new HashMap<String, Object[]>();
        HashMap<String, Object[]> likeTemplate = new HashMap<String, Object[]>();
        for (Project p : projects) {
            List orders = this.orderDAO.getPlottOrdersByCompletionDate(p.getId(), from, until);
            for (PlottOrder order : orders) {
                Collection orderItems = order.getOrderItems().values();
                block10: for (PlottOrderItem item : orderItems) {
                    Object[] stats;
                    if (item.getDocumentVersion().isInvalidated() || item.getDocumentVersion().isInvalidatedAll() || item.getDocumentVersion().isDeleted()) continue;
                    int count = item.getPlottProperties().getCount();
                    PlottProperties bb = item.getPlottProperties();
                    if (LengthCalculator.getBBoxArea(bb, LengthUnit.METER) == null) continue;
                    double meters = LengthCalculator.getBBoxArea(bb, LengthUnit.METER) * (double)count;
                    if (LengthCalculator.getPaperFormatSquareSize(item.getPlottProperties().getScale(), LengthUnit.METER) != null) {
                        meters = LengthCalculator.getPaperFormatSquareSize(item.getPlottProperties().getScale(), LengthUnit.METER) * (double)item.getPlottProperties().getCount();
                    }
                    switch (item.getPlottProperties().getColor()) {
                        case 1: {
                            stats = (Object[])inColor.get(item.getPlottProperties().getPaperQuality());
                            break;
                        }
                        case 0: {
                            stats = (Object[])monochrome.get(item.getPlottProperties().getPaperQuality());
                            break;
                        }
                        default: {
                            stats = (Object[])likeTemplate.get(item.getPlottProperties().getPaperQuality());
                        }
                    }
                    if (stats == null) {
                        stats = new Object[]{new Integer(0), new Double(0.0)};
                    }
                    stats[0] = (Integer)stats[0] + item.getPlottProperties().getCount();
                    stats[1] = (Double)stats[1] + meters;
                    switch (item.getPlottProperties().getColor()) {
                        case 1: {
                            inColor.put(item.getPlottProperties().getPaperQuality(), stats);
                            continue block10;
                        }
                        case 0: {
                            monochrome.put(item.getPlottProperties().getPaperQuality(), stats);
                            continue block10;
                        }
                    }
                    likeTemplate.put(item.getPlottProperties().getPaperQuality(), stats);
                }
            }
        }
        if (inColor.isEmpty() && monochrome.isEmpty() && likeTemplate.isEmpty()) {
            return "Keine Plotauftr\u00e4ge gefunden.";
        }
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(2);
        String ret = "";
        int totalItemCount = 0;
        double totalMetersCount = 0.0;
        if (!inColor.isEmpty()) {
            int itemCount = 0;
            double metersCount = 0.0;
            ret = ret + "<b>Plots in Farbe:</b><br/>";
            for (String paperQuality : inColor.keySet()) {
                Object[] stats = (Object[])inColor.get(paperQuality);
                ret = ret + paperQuality + " - St\u00fcckzahl: " + (Integer)stats[0] + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fl\u00e4che: " + formatter.format((Double)stats[1]) + " " + LengthCalculator.getSquareUnitLabel(LengthUnit.METER) + "<br/>";
                itemCount += ((Integer)stats[0]).intValue();
                metersCount += ((Double)stats[1]).doubleValue();
            }
            ret = ret + "In Farbe gesamt - St\u00fcckzahl: " + itemCount + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fl\u00e4che: " + formatter.format(metersCount) + " " + LengthCalculator.getSquareUnitLabel(LengthUnit.METER) + "<br/><br/>";
            totalItemCount += itemCount;
            totalMetersCount += metersCount;
        }
        if (!monochrome.isEmpty()) {
            int itemCount = 0;
            double metersCount = 0.0;
            ret = ret + "<b>Plots SW:</b><br/>";
            for (String paperQuality : monochrome.keySet()) {
                Object[] stats = (Object[])monochrome.get(paperQuality);
                ret = ret + paperQuality + " - St\u00fcckzahl: " + (Integer)stats[0] + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fl\u00e4che: " + formatter.format((Double)stats[1]) + " " + LengthCalculator.getSquareUnitLabel(LengthUnit.METER) + "<br/>";
                itemCount += ((Integer)stats[0]).intValue();
                metersCount += ((Double)stats[1]).doubleValue();
            }
            ret = ret + "SW gesamt - St\u00fcckzahl: " + itemCount + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fl\u00e4che: " + formatter.format(metersCount) + " " + LengthCalculator.getSquareUnitLabel(LengthUnit.METER) + "<br/><br/>";
            totalItemCount += itemCount;
            totalMetersCount += metersCount;
        }
        if (!likeTemplate.isEmpty()) {
            int itemCount = 0;
            double metersCount = 0.0;
            ret = ret + "<b>Plots wie Vorlage:</b><br/>";
            for (String paperQuality : likeTemplate.keySet()) {
                Object[] stats = (Object[])likeTemplate.get(paperQuality);
                ret = ret + paperQuality + " - St\u00fcckzahl: " + (Integer)stats[0] + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fl\u00e4che: " + formatter.format((Double)stats[1]) + " " + LengthCalculator.getSquareUnitLabel(LengthUnit.METER) + "<br/>";
                itemCount += ((Integer)stats[0]).intValue();
                metersCount += ((Double)stats[1]).doubleValue();
            }
            ret = ret + "Wie Vorlage gesamt - St\u00fcckzahl: " + itemCount + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fl\u00e4che: " + formatter.format(metersCount) + " " + LengthCalculator.getSquareUnitLabel(LengthUnit.METER) + "<br/><br/>";
            totalItemCount += itemCount;
            totalMetersCount += metersCount;
        }
        ret = ret + "<b>Plots gesamt:</b><br/>St\u00fcckzahl: " + totalItemCount + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fl\u00e4che: " + formatter.format(totalMetersCount) + " " + LengthCalculator.getSquareUnitLabel(LengthUnit.METER);
        return ret;
    }

    @Override
    public void invalidateOriginalDocumentOrdersCompletedBeforeDate(Date completionDate) throws FileHandleException, IOException {
        List ordersCompletedBeforeDate = this.orderDAO.getOriginalDocumentOrdersCompletedBeforeDate(completionDate);
        for (OriginalDocumentOrder order : ordersCompletedBeforeDate) {
            logger.info((Object)("Outdating OriginalDocumentOrder with id=[" + order.getId() + "]"));
            order.setOutdated(true);
            this.uploadHandler.deleteOriginalDocumentOrderFile(order.getFileName());
            this.orderDAO.updateOriginalDocumentOrder(order);
        }
    }

    @Override
    public SubProjectCopyContainer insertCopiesOfOrdersForSubProject(SubProject sourceSubProject, SubProject destinationSubProject, SubProjectCopyContainer subProjectCopyContainer) {
        Collection<OriginalDocumentOrder> sourceOriginalDocumentOrders = this.getOriginalDocumentOrders(sourceSubProject.getId());
        for (OriginalDocumentOrder sourceOrder : sourceOriginalDocumentOrders) {
            OriginalDocumentOrder destOrder = new OriginalDocumentOrder();
            destOrder.setDocumentOwner(sourceOrder.getDocumentOwner());
            destOrder.setFileName(sourceOrder.getFileName());
            destOrder.setJobNumber(sourceOrder.getJobNumber());
            destOrder.setOutdated(sourceOrder.isOutdated());
            destOrder.setSubProject(destinationSubProject);
            destOrder = this.orderDAO.saveOriginalDocumentOrder(destOrder);
            subProjectCopyContainer.getOriginalDocumentOrderIds().put(sourceOrder.getId(), destOrder.getId());
            destOrder.setOrderItems(new HashMap());
            ArrayList sourceItems = new ArrayList(sourceOrder.getOrderItems().values());
            for (OriginalDocumentOrderItem sourceItem : sourceItems) {
                OriginalDocumentOrderItem destItem = new OriginalDocumentOrderItem();
                destItem.setDeliveryAddress(sourceItem.getDeliveryAddress());
                if (sourceItem.getDocumentVersion() != null) {
                    destItem.setDocumentVersion(this.reviewOperations.getDocumentVersion(subProjectCopyContainer.getDocumentVersionIds().get(sourceItem.getDocumentVersion().getId())));
                }
                destItem.setFileName(sourceItem.getFileName());
                destItem.setOrderContract(destOrder);
                destItem.setReceiverId(sourceItem.getReceiverId());
                destItem.setReceiverType(sourceItem.getReceiverType());
                destItem = this.orderDAO.saveOriginalDocumentOrderItem(destItem);
                destOrder.getOrderItems().put(destItem.getId(), destItem);
            }
            HashMap<Integer, OrderStepImpl> destReceivedSteps = new HashMap<Integer, OrderStepImpl>();
            Iterator receivedIt = null;
            if (sourceOrder.getReceived() != null && !sourceOrder.getReceived().isEmpty()) {
                receivedIt = sourceOrder.getReceived().values().iterator();
            }
            int i = -1;
            while (true) {
                OrderStepImpl sourceStep = null;
                if (++i == 0) {
                    sourceStep = sourceOrder.getRequest();
                } else if (i == 1) {
                    sourceStep = sourceOrder.getAcceptance();
                } else if (i == 2) {
                    sourceStep = sourceOrder.getCompleted();
                } else {
                    if (receivedIt == null || !receivedIt.hasNext()) break;
                    sourceStep = (OrderStepImpl)receivedIt.next();
                }
                if (sourceStep == null) continue;
                logger.info((Object)("classname = " + sourceStep.getClass()));
                OrderStepCopier orderStepCopier = new OrderStepCopier();
                OrderStepImpl destStep = (OrderStepImpl)sourceStep.accept(orderStepCopier);
                if (sourceStep.getOrderItemId() != null) {
                    destStep.setOrderItemId(subProjectCopyContainer.getOrderItemIds().get(sourceStep.getOrderItemId()));
                }
                destStep = this.orderDAO.saveOrderStep(destStep);
                if (i == 0) {
                    destOrder.setRequest(destStep);
                } else if (i == 1) {
                    destOrder.setAcceptance(destStep);
                } else if (i == 2) {
                    destOrder.setCompleted(destStep);
                } else {
                    destReceivedSteps.put(destStep.getId(), destStep);
                }
                subProjectCopyContainer.getOriginalDocumentOrderOrderStepIds().put(sourceStep.getId(), destStep.getId());
            }
            destOrder.setReceived(destReceivedSteps);
            destOrder = this.orderDAO.updateOriginalDocumentOrder(destOrder);
        }
        List sourceItems = this.orderDAO.getOpenPlotOrderItemsBySubProject(sourceSubProject.getProject().getId(), sourceSubProject.getId());
        for (PlottOrderItem sourceItem : sourceItems) {
            PlottOrderItem destItem = new PlottOrderItem();
            destItem.setDeliveryAddress(sourceItem.getDeliveryAddress());
            destItem.setDocumentVersion(this.reviewOperations.getDocumentVersion(subProjectCopyContainer.getDocumentVersionIds().get(sourceItem.getDocumentVersion().getId())));
            destItem.setInitiator(sourceItem.getInitiator());
            if (sourceItem.getNodeInstanceRelease() != null) {
                Integer rCycleInstanceRelId = subProjectCopyContainer.getReviewCycleInstanceReleaseIds().get(sourceItem.getNodeInstanceRelease().getReviewCycleCellInstance().getReviewCycleInstance().getId());
                Integer rCycleNodeInstanceId = subProjectCopyContainer.getReviewCycleNodeInstanceImplIds().get(sourceItem.getNodeInstanceRelease().getReviewCycleNodeInstance().getId());
                ReviewCycleNodeInstanceImpl rCycleNodeInstance = this.reviewOperations.getReviewCycleNodeInstance(rCycleNodeInstanceId);
                ReviewCycleNodeInstanceRelease rCycleNodeInstanceRel = this.reviewOperations.getReleasedReviewCycleNodeInstance3(rCycleNodeInstance.getReviewCycleNode().getId(), rCycleInstanceRelId);
                destItem.setNodeInstanceRelease(rCycleNodeInstanceRel);
            }
            destItem.setOrderContract(sourceItem.getOrderContract());
            destItem.setPlottProperties(sourceItem.getPlottProperties());
            destItem.setReceiverId(sourceItem.getReceiverId());
            destItem.setReceiverOrganisationPerson(sourceItem.getReceiverOrganisationPerson());
            destItem.setReceiverType(sourceItem.getReceiverType());
            destItem.setTemplate(sourceItem.getTemplate());
            destItem = this.orderDAO.savePlottOrderItem(destItem);
        }
        return subProjectCopyContainer;
    }

    public void setReviewCycleNodeInstanceDAO(ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO) {
        this.reviewCycleNodeInstanceDAO = reviewCycleNodeInstanceDAO;
    }

    @Override
    public void deleteOriginalDocumentOrder(Integer orderId) {
        OriginalDocumentOrder order = this.orderDAO.getOriginalDocumentOrder(orderId);
        if (order.getAcceptance() != null) {
            OriginalDocumentTask originalDocumentTask = this.taskDAO.getOriginalDocumentTask(order.getAcceptance().getId());
            if (originalDocumentTask != null) {
                this.taskOperations.removeTask(originalDocumentTask.getId());
            } else {
                OriginalDocumentTaskDone completedDone;
                OriginalDocumentTaskDone acceptedDone = this.taskDAO.getOriginalDocumentTaskDone(order.getAcceptance().getId());
                if (acceptedDone != null) {
                    this.taskOperations.removeTask(acceptedDone.getId());
                }
                if (order.getCompleted() != null && (completedDone = this.taskDAO.getOriginalDocumentTaskDone(order.getCompleted().getId())) != null) {
                    this.taskOperations.removeTask(completedDone.getId());
                }
            }
        }
        if (order.getRequest() != null) {
            this.orderDAO.delete(order.getRequest());
        }
        if (order.getAcceptance() != null) {
            this.orderDAO.delete(order.getAcceptance());
        }
        if (order.getCompleted() != null) {
            this.orderDAO.delete(order.getCompleted());
        }
        if (order.getOrderItems() != null) {
            Map orderItems = order.getOrderItems();
            for (OriginalDocumentOrderItem item : orderItems.values()) {
                this.orderDAO.delete(item);
            }
        }
        if (order.getFileName() != null) {
            try {
                this.uploadHandler.deleteOriginalDocumentOrderFile(order.getFileName());
            }
            catch (Exception e) {
                logger.error((Object)("could not delete physical file of original document order, filename=[" + order.getFileName() + "]"));
            }
        }
        this.orderDAO.delete(order);
    }
}

