/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchHelper {
    public static boolean isStringFilled(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static String convertForSearch(String s) {
        if (s == null) {
            return "%";
        }
        if (!(s = s.toLowerCase().replaceAll("\\*", "%")).startsWith("%")) {
            s = "%" + s;
        }
        if (!s.endsWith("%")) {
            s = s + "%";
        }
        return s;
    }

    public static List<String> extractAndConvertSearchTokens(String s) {
        List<String> tokens = SearchHelper.extractSearchTokens(s);
        for (int n = 0; n < tokens.size(); ++n) {
            tokens.set(n, SearchHelper.convertForSearch(tokens.get(n)));
        }
        return tokens;
    }

    public static List<String> extractSearchTokens(String s) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (s == null) {
            return tokens;
        }
        Pattern spacePattern = Pattern.compile("\\s+");
        Matcher spaceMatcher = spacePattern.matcher(s);
        Pattern quotePattern = Pattern.compile("\"");
        Matcher quoteMatcher = quotePattern.matcher(s);
        boolean spaceFound = spaceMatcher.find();
        boolean quoteFound = quoteMatcher.find();
        Integer currQuoteStart = null;
        Integer prevTokenStart = 0;
        while (spaceFound || quoteFound) {
            Integer spaceStart;
            Integer quoteStart = quoteFound ? Integer.valueOf(quoteMatcher.start()) : null;
            Integer n = spaceStart = spaceFound ? Integer.valueOf(spaceMatcher.start()) : null;
            if (quoteStart != null && (spaceStart == null || quoteStart < spaceStart)) {
                prevTokenStart = quoteMatcher.end();
                if (currQuoteStart == null) {
                    currQuoteStart = quoteMatcher.end();
                    quoteFound = quoteMatcher.find();
                    continue;
                }
                int currQuoteEnd = quoteStart;
                String token = s.substring(currQuoteStart, currQuoteEnd);
                tokens.add(token);
                currQuoteStart = null;
                quoteFound = quoteMatcher.find();
                continue;
            }
            if (spaceStart == null || quoteStart != null && spaceStart >= quoteStart) continue;
            if (currQuoteStart != null) {
                spaceFound = spaceMatcher.find();
                continue;
            }
            String token = s.substring(prevTokenStart, spaceStart).trim();
            if (token.length() > 0) {
                tokens.add(token);
            }
            prevTokenStart = spaceMatcher.end();
            spaceFound = spaceMatcher.find();
        }
        String lastToken = s.substring(prevTokenStart).trim();
        if (lastToken.length() > 0) {
            tokens.add(lastToken);
        }
        return tokens;
    }
}

