/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.digest;

import at.cdes.bo.data.HashedObject;
import at.cdes.bo.data.cycle.ReviewCycleEntryResult;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnectionResult;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentList;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.object.CDESObject;
import at.cdes.bo.data.object.ObjectList;
import at.cdes.bo.data.object.ObjectPlanner;
import at.cdes.bo.data.order.OrderStep;
import at.cdes.bo.data.project.ProjectStatusChange;
import at.cdes.bo.data.sec.DigestCalculatorType;
import at.cdes.bo.data.workflow.WorkflowActivityPositionResult;
import at.cdes.bo.sec.digest.DigestCalculator;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DocumentDigesterV1;
import at.cdes.bo.sec.digest.FileDigestCalculator;
import at.cdes.bo.sec.digest.ObjectDigesterV1;
import at.cdes.bo.sec.digest.OrderStepDigesterV1;
import at.cdes.bo.sec.digest.ProjectStatusChangeDigesterV1;
import at.cdes.bo.sec.digest.ReviewCycleCellConnectionResultDigesterV1;
import at.cdes.bo.sec.digest.ReviewCycleEntryResultDigesterV1;
import at.cdes.bo.sec.digest.ReviewResultDigesterV1;
import at.cdes.bo.sec.digest.WorkflowActivityPositionResultDigesterV1;
import java.io.File;
import java.io.Serializable;

public class DigestCalculatorFactory
implements Serializable {
    static final long serialVersionUID = 1L;

    public DigestCalculator getDigestCalculator(Network network, Object o) throws DigestCalculatorException {
        HashedObject hashable;
        if (o instanceof HashedObject && (hashable = (HashedObject)o).getDigestCalculatorType() != null) {
            return this.getDigestCalculator(hashable.getDigestCalculatorType());
        }
        if (o instanceof ObjectList || o instanceof CDESObject || o instanceof ObjectPlanner) {
            return new ObjectDigesterV1();
        }
        if (o instanceof DocumentList || o instanceof Document) {
            return new DocumentDigesterV1();
        }
        if (o instanceof ReviewCycleEntryResult) {
            return new ReviewCycleEntryResultDigesterV1();
        }
        if (o instanceof File) {
            return new FileDigestCalculator();
        }
        if (o instanceof ReviewCyclePositionResult) {
            return new ReviewResultDigesterV1();
        }
        if (o instanceof ReviewCycleCellConnectionResult) {
            return new ReviewCycleCellConnectionResultDigesterV1();
        }
        if (o instanceof OrderStep) {
            return new OrderStepDigesterV1();
        }
        if (o instanceof ProjectStatusChange) {
            return new ProjectStatusChangeDigesterV1();
        }
        if (o instanceof WorkflowActivityPositionResult) {
            return new WorkflowActivityPositionResultDigesterV1();
        }
        throw new DigestCalculatorException("No DigestCalculator found for Class " + o.getClass().getName() + " in Network " + network != null ? network.getName() : null);
    }

    public DigestCalculator getDigestCalculator(Network network, Class c) throws DigestCalculatorException {
        if (c.getName().equals(ObjectList.class.getName()) || c.getName().equals(CDESObject.class.getName()) || c.getName().equals(ObjectPlanner.class.getName())) {
            return new ObjectDigesterV1();
        }
        if (c.getName().equals(DocumentList.class.getName()) || c.getName().equals(Document.class.getName())) {
            return new DocumentDigesterV1();
        }
        if (c.getName().equals(ReviewCycleEntryResult.class.getName())) {
            return new ReviewCycleEntryResultDigesterV1();
        }
        if (c.getName().equals(File.class.getName())) {
            return new FileDigestCalculator();
        }
        if (c.getName().equals(ReviewCyclePositionResult.class.getName())) {
            return new ReviewResultDigesterV1();
        }
        if (c.getName().equals(ProjectStatusChange.class.getName())) {
            return new ProjectStatusChangeDigesterV1();
        }
        if (c.getName().equals(WorkflowActivityPositionResult.class.getName())) {
            return new WorkflowActivityPositionResultDigesterV1();
        }
        throw new DigestCalculatorException("No DigestCalculator found for Class " + c.getName() + " in Network " + network != null ? network.getName() : null);
    }

    private DigestCalculator getDigestCalculator(DigestCalculatorType type) throws DigestCalculatorException {
        DigestCalculator calc;
        try {
            calc = (DigestCalculator)Class.forName(type.getName()).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new DigestCalculatorException("Instantiation failed", e);
        }
        catch (InstantiationException e) {
            throw new DigestCalculatorException("Instantiation failed", e);
        }
        catch (IllegalAccessException e) {
            throw new DigestCalculatorException("Instantiation failed", e);
        }
        return calc;
    }
}

