/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler.archive;

import at.cdes.bo.data.project.Project;
import at.cdes.service.exception.ActionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.TimeZone;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.clazzes.jdbc2xml.sax.InsertContentHandler;
import org.clazzes.jdbc2xml.sax.JDBC2XMLSchemaHelper;
import org.clazzes.jdbc2xml.sax.JDBCToSAXWriter;
import org.clazzes.jdbc2xml.schema.Dialect;
import org.clazzes.jdbc2xml.schema.DialectFactory;
import org.clazzes.jdbc2xml.schema.IDialectFactory;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.SchemaEngine;
import org.clazzes.jdbc2xml.tools.DBDataExtractor;
import org.clazzes.jdbc2xml.tools.ProcessRestrictionFilter;
import org.clazzes.util.xml.XMLSerializerHelper;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ProjectArchiveWriter {
    private static final Logger log = Logger.getLogger(ProjectArchiveWriter.class);
    private String dbUrl;
    private String tempExtractDb;
    private String dbDriver;
    private String dbUser;
    private String dbPwd;

    public void readArchiveXml(File xmlFile) {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPwd);
            FileInputStream fis = new FileInputStream(xmlFile);
            InsertContentHandler insertHandler = new InsertContentHandler(connection, TimeZone.getDefault());
            insertHandler.setProcessRestrictionFilter(null);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            Schema schema = JDBC2XMLSchemaHelper.createSchema();
            ValidatorHandler validatorHandler = schema.newValidatorHandler();
            validatorHandler.setContentHandler((ContentHandler)insertHandler);
            reader.setContentHandler(validatorHandler);
            InputSource input = new InputSource(fis);
            reader.parse(input);
        }
        catch (SQLException e) {
            throw new ActionException("Caught SQLException when restoring project.", e);
        }
        catch (FileNotFoundException e) {
            throw new ActionException("Caught FileNotFoundException when restoring project.", e);
        }
        catch (SAXException e) {
            throw new ActionException("Caught SAXException when restoring project.", e);
        }
        catch (IOException e) {
            throw new ActionException("Caught IOException when restoring project.", e);
        }
    }

    public String writeArchiveXml(Project project, File xmlFile) throws SQLException {
        log.info((Object)"setting up db connection ...");
        try (Connection connection = null;){
            try {
                Class.forName(this.dbDriver);
            }
            catch (ClassNotFoundException e) {
                log.fatal((Object)("Could not load driver " + this.dbDriver));
                throw new ActionException("Could not load driver ", e);
            }
            ProcessRestrictionFilter processRestrictionFilter = new ProcessRestrictionFilter();
            processRestrictionFilter.setBatchSize(Integer.MIN_VALUE);
            processRestrictionFilter.addPrimaryRestriction("project", String.valueOf(project.getId()));
            processRestrictionFilter.addPrimaryRestriction("network", String.valueOf(project.getNetwork().getId()));
            processRestrictionFilter.addPrimaryRestriction("ca", null);
            connection = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPwd);
            IDialectFactory df = DialectFactory.newInstance();
            Dialect dialect = df.newDialect(connection.getMetaData());
            DBDataExtractor extractor = new DBDataExtractor();
            ISchemaEngine se = SchemaEngine.newInstance();
            se.setConnection(connection);
            se.setDialect(dialect);
            extractor.setSchemaEngine(se);
            extractor.setProcessRestrictionFilter(processRestrictionFilter);
            extractor.setExportDbName(this.tempExtractDb);
            log.info((Object)("start extraction of project id=[" + String.valueOf(project.getId()) + "] to temporary database [" + this.tempExtractDb + "] ..."));
            extractor.extract();
            se.commit();
            log.info((Object)"finished extraction.");
            String sha1_b64 = this.writeProjectXmlFile(connection, processRestrictionFilter, xmlFile);
            this.dropTemporaryTables(se);
            String string = sha1_b64;
            return string;
        }
    }

    private void dropTemporaryTables(ISchemaEngine se) {
        log.info((Object)("start dropping temporary tables from [" + this.tempExtractDb + "] ..."));
        se.setSchema(this.tempExtractDb);
        try {
            List tables = se.fetchTableInfos(null);
            se.dropTables(tables, true);
            se.commit();
            log.info((Object)("All tables from [" + this.tempExtractDb + "] dropped."));
        }
        catch (SQLException e) {
            throw new ActionException("Caught SQLException dropping tables from [" + this.tempExtractDb + "].", e);
        }
    }

    private String writeProjectXmlFile(Connection connection, ProcessRestrictionFilter processRestrictionFilter, File xmlFile) throws SQLException, IOException {
        log.info((Object)("start writing XML-File [" + xmlFile.getAbsolutePath() + "] ..."));
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(xmlFile);
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            DigestOutputStream os = new DigestOutputStream(fos, sha1);
            ContentHandler handler = XMLSerializerHelper.newSerializer((OutputStream)os);
            connection.setCatalog(this.tempExtractDb);
            JDBCToSAXWriter writer = new JDBCToSAXWriter(connection, TimeZone.getDefault(), handler);
            writer.setProcessRestrictionFilter(processRestrictionFilter);
            writer.processData();
            fos.flush();
            String sha1_b64 = new String(Base64.encode((byte[])os.getMessageDigest().digest()), "US-ASCII");
            log.info((Object)("XML-File [" + xmlFile.getAbsolutePath() + "] saved."));
            String string = sha1_b64;
            return string;
        }
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setTempExtractDb(String tempExtractDb) {
        this.tempExtractDb = tempExtractDb;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setDbPwd(String dbPwd) {
        this.dbPwd = dbPwd;
    }
}

