/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.mail;

import at.cdes.service.MailOperations;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.clazzes.util.aop.ThreadLocalManager;

public class MailSnippetCollector
extends Thread {
    MailOperations mailOperations;
    static Logger logger = Logger.getLogger(MailSnippetCollector.class);
    private String applicationUrl;
    private String applicationUrlThreadLocalKey;

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    public void setApplicationUrlThreadLocalKey(String applicationUrlThreadLocalKey) {
        this.applicationUrlThreadLocalKey = applicationUrlThreadLocalKey;
    }

    public void setMailOperations(MailOperations mailOperations) {
        this.mailOperations = mailOperations;
    }

    public void requestStop() {
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block15: {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"snippet collector has been started.");
                }
                while (!this.isInterrupted()) {
                    GregorianCalendar now = new GregorianCalendar();
                    try {
                        ThreadLocalManager.bindResource((String)this.applicationUrlThreadLocalKey, (Object)this.applicationUrl);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"snippet collector running...");
                        }
                        this.mailOperations.createSnippetsFromFutureEMails(now);
                        this.mailOperations.collectSnippets(now);
                        this.mailOperations.createWorkflowActivityNotificationSnippets();
                    }
                    catch (RuntimeException e) {
                        logger.error((Object)"snippet collector caught a runtime exception:", (Throwable)e);
                    }
                    finally {
                        ThreadLocalManager.unbindResource((String)this.applicationUrlThreadLocalKey);
                    }
                    MailSnippetCollector mailSnippetCollector = this;
                    synchronized (mailSnippetCollector) {
                        this.wait(60000L);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"snippet collector has been finished normally.");
                }
            }
            catch (InterruptedException e) {
                if (!logger.isDebugEnabled()) break block15;
                logger.debug((Object)"snippet collector has been interrupted.");
            }
        }
    }
}

