/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.network.NetworkPerson;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.data.role.ActionRule;
import at.cdes.bo.data.role.ActionRuleDefault;
import at.cdes.bo.data.role.CDESAction;
import at.cdes.bo.data.role.Role;
import at.cdes.controller.ActionValidator;
import at.cdes.db.dao.ActionDAO;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.PersonDAO;
import at.cdes.oldGwtDto.ActionCheckDTO;
import at.cdes.oldGwtDto.RoleMapGWT;
import at.cdes.service.ActionOperations;
import at.cdes.util.OgnlComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ActionOperationsImpl
implements ActionOperations {
    private PersonDAO personDAO;
    private ActionDAO actionDAO;
    private NetworkDAO networkDAO;
    private ActionValidator actionValidator;
    static Logger logger = Logger.getLogger(ActionOperationsImpl.class);

    @Override
    public List getActionRules(Integer networkId, Locale locale) {
        ArrayList<ActionRule> ret = new ArrayList<ActionRule>();
        ret.addAll(this.actionDAO.getActionRules(networkId != null ? this.networkDAO.get(networkId) : null, false));
        Collections.sort(ret, new OgnlComparator("action.name", true, locale));
        return ret;
    }

    @Override
    public List getActionRulesWithNetworkReference(Locale locale) {
        ArrayList<ActionRule> ret = new ArrayList<ActionRule>();
        ret.addAll(this.actionDAO.getActionRules(null, true));
        Collections.sort(ret, new OgnlComparator("action.name", true, locale));
        return ret;
    }

    @Override
    public List getAllActions() {
        return this.actionDAO.getAll();
    }

    @Override
    public void insertActionRules(List rules) {
        for (int i = 0; i < rules.size(); ++i) {
            this.insertActionRule((ActionRule)rules.get(i));
        }
    }

    public ActionRule insertActionRule(ActionRule rule) {
        return this.actionDAO.save(rule);
    }

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    @Override
    public CDESAction insertAction(CDESAction action, List rules, ActionRuleDefault ruleDefault) {
        action = this.actionDAO.save(action);
        action.setActionRules(new HashMap<Integer, ActionRule>());
        for (int i = 0; i < rules.size(); ++i) {
            ActionRule rule = (ActionRule)rules.get(i);
            if (action.getActionRules().containsKey(rule.getId()) || !rule.isSelected()) continue;
            rule.setAction(action);
            rule = this.actionDAO.save(rule);
            action.getActionRules().put(rule.getId(), rule);
        }
        action = this.actionDAO.merge(action);
        if (ruleDefault.isSelected()) {
            ruleDefault.setAction(action);
            if (ruleDefault.getId() != null && ruleDefault.getId() > 1) {
                this.actionDAO.merge(ruleDefault);
            } else {
                this.actionDAO.save(ruleDefault);
            }
        }
        return action;
    }

    @Override
    public CDESAction updateAction(CDESAction action, List rules, ActionRuleDefault ruleDefault, Integer isReadOnly) {
        for (int i = 0; i < rules.size(); ++i) {
            ActionRule rule = (ActionRule)rules.get(i);
            if (action.getActionRules().containsKey(rule.getId()) && !rule.isSelected()) {
                action.getActionRules().remove(rule.getId());
                this.actionDAO.delete(rule);
                continue;
            }
            if (!action.getActionRules().containsKey(rule.getId()) && rule.isSelected()) {
                rule.setAction(action);
                rule = this.actionDAO.save(rule);
                action.getActionRules().put(rule.getId(), rule);
                continue;
            }
            if (!action.getActionRules().containsKey(rule.getId()) || !rule.isSelected()) continue;
            rule.setAction(action);
            rule = this.actionDAO.merge(rule);
        }
        action.setReadOnly(isReadOnly);
        action = this.actionDAO.merge(action);
        if (ruleDefault.isSelected() && ruleDefault.getDestinationContext() != null) {
            ruleDefault.setAction(action);
            this.actionDAO.merge(ruleDefault);
        } else if (!ruleDefault.isSelected()) {
            action.getActionRules().remove(ruleDefault.getId());
            this.actionDAO.delete(ruleDefault);
        }
        return action;
    }

    @Override
    public CDESAction getAction(Integer id) {
        return this.actionDAO.get(id);
    }

    @Override
    public ActionRule getActionRule(Integer actionId, Integer networkId) {
        List<ActionRule> l = this.actionDAO.getActionRules(actionId, networkId);
        return l != null && !l.isEmpty() ? l.get(0) : null;
    }

    @Override
    public void deleteAction(Integer actionId) {
        CDESAction action = this.actionDAO.get(actionId);
        if (action.getActionRules() != null && !action.getActionRules().isEmpty()) {
            Collection<ActionRule> as = action.getActionRules().values();
            for (ActionRule rule : as) {
                action.getActionRules().remove(rule.getId());
                this.actionDAO.delete(rule);
            }
        }
        this.actionDAO.delete(action);
    }

    @Override
    public List<OrganisationPerson> getNetworkDeputies(String actionName, Integer networkId) {
        Map roles;
        CDESAction action = this.actionDAO.get(actionName);
        Network network = null;
        if (networkId != null) {
            network = this.networkDAO.get(networkId);
        }
        HashMap<Integer, OrganisationPerson> orgPersons = new HashMap<Integer, OrganisationPerson>();
        List<ActionRule> rules = this.actionDAO.getActionRules(action.getId(), null);
        for (ActionRule rule : rules) {
            if (rule.getDestinationContext().getId() != 1) continue;
            roles = rule.getRoles();
            for (Role role : roles.values()) {
                List<Person> persons = this.personDAO.getByGlobalRole(role.getId());
                for (Person person : persons) {
                    boolean haveMaintainerOrgPerson = false;
                    for (OrganisationPerson orgPerson : person.getOrganisationPersons().values()) {
                        if (network == null || !orgPerson.getOrganisation().getId().equals(network.getMaintainer().getId())) continue;
                        orgPersons.put(orgPerson.getId(), orgPerson);
                        haveMaintainerOrgPerson = true;
                        break;
                    }
                    if (haveMaintainerOrgPerson) continue;
                    orgPersons.putAll(person.getOrganisationPersons());
                }
            }
        }
        if (network != null) {
            rules = this.actionDAO.getActionRules(action.getId(), network.getId());
            for (ActionRule rule : rules) {
                if (rule.getDestinationContext().getId() != 2) continue;
                roles = rule.getRoles();
                for (Role role : roles.values()) {
                    Map networkPersons = role.getNetworkPersons();
                    for (NetworkPerson networkPerson : networkPersons.values()) {
                        OrganisationPerson orgPerson = networkPerson.getOrganisationPerson();
                        orgPersons.put(orgPerson.getId(), orgPerson);
                    }
                }
            }
        }
        ArrayList<OrganisationPerson> ret = new ArrayList<OrganisationPerson>(orgPersons.size());
        ret.addAll(orgPersons.values());
        return ret;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    @Override
    public List getAllActionRuleDefaults(Locale locale) {
        ArrayList ret = new ArrayList();
        ret.addAll(this.actionDAO.getAllActionRuleDefaults());
        Collections.sort(ret, new OgnlComparator("action.name", true, locale));
        return ret;
    }

    @Override
    public ActionRuleDefault getActionRuleDefaultByAction(Integer actionId) {
        return this.actionDAO.getActionRuleDefaultByAction(actionId);
    }

    public void setActionValidator(ActionValidator actionValidator) {
        this.actionValidator = actionValidator;
    }

    @Override
    public List<ActionCheckDTO> validateActionChecks(RoleMapGWT roleMapGWT, List<ActionCheckDTO> actionChecks) {
        return this.actionValidator.validateActionChecks(roleMapGWT, actionChecks);
    }
}

