/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.apiHelper;

import at.cdes.bo.data.attachment.Attachment;
import at.cdes.bo.data.document.DocumentRef;
import at.cdes.bo.data.document.DocumentVersion;
import java.io.File;
import org.xnap.commons.i18n.I18n;

public class ArchiveHelper {
    public static final String CSS_PATH = "archive.css";
    public static final String SCRIPT_PATH = "table.js";
    public static final String IMG_REVIEW_PROTOCOL = "pruefprotokoll.gif";
    public static final String IMG_PDF_PREVIEW = "planvorschau_pdf.gif";
    public static final String IMG_DOCUMENT_VERSION = "speichern.gif";
    public static final int ARCHIVE_TYPE_ORIGINAL = 0;
    public static final int ARCHIVE_TYPE_PDF = 1;
    public static final int ARCHIVE_TYPE_BOTH = 2;
    public static final int PATH_RELATIVE_TO_REVIEW_PROTOCOLL = 0;
    public static final int PATH_RELATIVE_TO_INDEX_WITH_HISTORY = 1;
    public static final int PATH_RELATIVE_TO_INDEX_NO_HISTORY = 2;

    private static String getBasePath(I18n i18n) {
        return i18n.tr("Dateien") + File.separator;
    }

    public static String getHTMLRessourcePath(I18n i18n, String fileName) {
        return ArchiveHelper.getBasePath(i18n) + "ressources" + File.separator + fileName;
    }

    private static String getDocumentVersionBasePath(DocumentVersion dv, I18n i18n) {
        return ArchiveHelper.getBasePath(i18n) + dv.getDocument().getObjectPlanner().getObject().getCode() + File.separator + dv.getDocument().getName() + File.separator;
    }

    private static String getPathPrefix(int initialPoint, DocumentVersion dv, I18n i18n) {
        switch (initialPoint) {
            case 2: {
                return "";
            }
            case 1: {
                return ArchiveHelper.getDocumentVersionBasePath(dv, i18n);
            }
            case 0: {
                return "../";
            }
        }
        return null;
    }

    public static String getAttachmentFilename(Attachment att, DocumentVersion dv, I18n i18n, int initialPoint) {
        String path = ArchiveHelper.getPathPrefix(initialPoint, dv, i18n) + i18n.tr("Dateianhaenge") + File.separator + att.getId() + (att.getFileType() != null ? "." + att.getFileType() : "");
        return path;
    }

    public static String getDocumentReferenceFilename(DocumentRef ref, DocumentVersion dv, I18n i18n, int initialPoint) {
        String path = ArchiveHelper.getPathPrefix(initialPoint, dv, i18n) + i18n.tr("Unterlagen") + File.separator + ref.getId() + (ref.getAttachmentFiletype() != null ? "." + ref.getAttachmentFiletype() : "");
        return path;
    }

    public static String getRedliningFilename(DocumentVersion dv, I18n i18n, int initialPoint) {
        String path = ArchiveHelper.getPathPrefix(initialPoint, dv, i18n) + i18n.tr("Redlining") + File.separator + dv.getName() + (dv.isDeleted() ? "_" + dv.getId() : "") + ".pdf";
        return path;
    }

    public static String getReviewProtocollFilename(DocumentVersion dv, I18n i18n, int initialPoint) {
        String path = ArchiveHelper.getPathPrefix(initialPoint, dv, i18n) + i18n.tr("Pruefprotokoll") + "_" + dv.getDocument().getName() + ".pdf";
        return path;
    }

    public static String getDocumentVersionFilename(DocumentVersion dv, I18n i18n, int initialPoint, boolean pdfPreview) {
        String postfix = "";
        if (dv.isDeleted()) {
            postfix = "_" + i18n.tr("geloescht") + "_" + dv.getId();
        }
        String path = ArchiveHelper.getPathPrefix(initialPoint, dv, i18n) + i18n.tr("Dokumente") + File.separator + dv.getName() + postfix + (pdfPreview ? ".pdf" : "." + dv.getFileType());
        return path;
    }

    public static String getDocumentVersionDirectoryPath(DocumentVersion dv, I18n i18n, int initialPoint) {
        String path = ArchiveHelper.getPathPrefix(initialPoint, dv, i18n) + i18n.tr("Dokumente") + File.separator;
        return path;
    }
}

