/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview.seed;

import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.ext.preview.seed.DocumentVersionSeeder;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;

public class DocumentVersionSeedInterceptor
implements MethodInterceptor {
    private static final Logger log = Logger.getLogger(DocumentVersionSeedInterceptor.class);
    private DocumentVersionSeeder seeder;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object ret = invocation.proceed();
        String methodName = invocation.getMethod().getName();
        if (this.seeder != null && this.seeder.isActive() && (methodName.equals("signReviewCycleEntryResult") || methodName.equals("signReviewCycleCellChange"))) {
            if (ret instanceof DocumentVersion) {
                DocumentVersion dv = (DocumentVersion)ret;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Seeding DocumentVersion ID [" + dv.getId() + "] as result of [" + invocation.getMethod() + "]."));
                }
                this.seeder.queueDocumentVersion(dv);
            } else {
                log.warn((Object)("Return value of [" + invocation.getMethod() + "] is not a DocumentVersion."));
            }
        }
        return ret;
    }

    public void setSeeder(DocumentVersionSeeder seeder) {
        this.seeder = seeder;
    }
}

