/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.date;

public enum TimeUnit {
    Year,
    Month,
    Week,
    Day,
    Hour,
    Minute,
    Second;


    public static TimeUnit fromISO8601Duration(char c, boolean timePart) {
        switch (c) {
            case 'Y': {
                return Year;
            }
            case 'M': {
                return timePart ? Minute : Month;
            }
            case 'W': {
                return Week;
            }
            case 'D': {
                return Day;
            }
            case 'H': {
                return Hour;
            }
            case 'S': {
                return Second;
            }
        }
        return null;
    }

    public char toISO8601Duration() {
        switch (this) {
            case Year: {
                return 'Y';
            }
            case Month: {
                return 'M';
            }
            case Day: {
                return 'D';
            }
            case Week: {
                return 'W';
            }
            case Hour: {
                return 'H';
            }
            case Minute: {
                return 'M';
            }
            case Second: {
                return 'S';
            }
        }
        throw new AssertionError((Object)("Invalid TimeUnit value [" + (Object)((Object)this) + "]"));
    }

    public boolean isTimePart() {
        switch (this) {
            case Year: 
            case Month: 
            case Day: 
            case Week: {
                return false;
            }
            case Hour: 
            case Minute: 
            case Second: {
                return true;
            }
        }
        throw new AssertionError((Object)("Invalid TimeUnit value [" + (Object)((Object)this) + "]"));
    }

    public int toCalendarField() {
        switch (this) {
            case Year: {
                return 1;
            }
            case Month: {
                return 2;
            }
            case Day: {
                return 5;
            }
            case Week: {
                return 3;
            }
            case Hour: {
                return 11;
            }
            case Minute: {
                return 12;
            }
            case Second: {
                return 13;
            }
        }
        throw new AssertionError((Object)("Invalid TimeUnit value [" + (Object)((Object)this) + "]"));
    }
}

