/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.signature;

import at.cdes.bo.data.SignedObject;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.sec.SignatureCalculatorType;
import at.cdes.bo.sec.signature.SignatureCalculator;
import at.cdes.bo.sec.signature.SignatureCalculatorException;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class SignatureCalculatorFactory
implements Serializable {
    static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(SignatureCalculatorFactory.class);

    public SignatureCalculator getSignatureCalculator(Network network, Object o) throws SignatureCalculatorException {
        if (o instanceof SignedObject) {
            SignedObject signable = (SignedObject)o;
            if (signable.getSignature() != null) {
                return this.getSignatureCalculator(signable.getSignature().getType());
            }
            return this.getSignatureCalculator(network.getSignatureCalculatorType());
        }
        throw new SignatureCalculatorException("No SignatureCalculator found for Class " + o.getClass().getName() + " in Network " + network.getName());
    }

    private SignatureCalculator getSignatureCalculator(SignatureCalculatorType type) throws SignatureCalculatorException {
        SignatureCalculator calc = null;
        try {
            calc = (SignatureCalculator)Class.forName(type.getName()).newInstance();
            calc.setSignatureType(type);
        }
        catch (ClassNotFoundException e) {
            throw new SignatureCalculatorException("Instantiation failed", e);
        }
        catch (InstantiationException e) {
            throw new SignatureCalculatorException("Instantiation failed", e);
        }
        catch (IllegalAccessException e) {
            throw new SignatureCalculatorException("Instantiation failed", e);
        }
        return calc;
    }
}

