/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.DocumentVersionStatusChange;
import at.cdes.db.dao.DocumentVersionDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class DocumentVersionDAOHibernate
extends HibernateDaoSupport
implements DocumentVersionDAO {
    @Override
    public DocumentVersion get(Integer id) {
        return (DocumentVersion)this.getSession().get(DocumentVersion.class, (Serializable)id);
    }

    @Override
    public List getAll() {
        return this.loadAllHibernate(DocumentVersion.class);
    }

    @Override
    public DocumentVersion save(DocumentVersion cons) {
        return this.get((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public DocumentVersion update(DocumentVersion cons) {
        this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public void delete(DocumentVersion cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public void evict(DocumentVersion version) {
        this.getSession().evict((Object)version);
    }

    @Override
    public List getDocumentVersions(Integer id, int filter) {
        Criteria crit = this.getSession().createCriteria(DocumentVersion.class);
        switch (filter) {
            case 2: {
                return crit.createCriteria("document").createCriteria("objectPlanner").add(Restrictions.idEq((Object)id)).list();
            }
            case 1: {
                return crit.createCriteria("document").createCriteria("objectPlanner").createCriteria("object").add(Restrictions.idEq((Object)id)).list();
            }
            case 0: {
                return crit.createCriteria("document").addOrder(Order.asc((String)"id")).createCriteria("documentList").createCriteria("subProject").add(Restrictions.idEq((Object)id)).list();
            }
        }
        return null;
    }

    public List getDocumentHighestVersions(Integer activeSubProjectId, int filter) {
        return null;
    }

    @Override
    public DocumentVersionStatusChange getStatusChange(Integer id) {
        return (DocumentVersionStatusChange)this.getSession().get(DocumentVersionStatusChange.class, (Serializable)id);
    }

    @Override
    public DocumentVersionStatusChange saveStatusChange(DocumentVersionStatusChange change) {
        return this.getStatusChange((Integer)this.getSession().save((Object)change));
    }

    @Override
    public DocumentVersionStatusChange getLastStatusChangeByVersionId(Integer versionId) {
        Criteria crit = this.getSession().createCriteria(DocumentVersionStatusChange.class);
        crit.add((Criterion)Restrictions.eq((String)"documentVersionId", (Object)versionId));
        List listOfChanges = crit.list();
        return (DocumentVersionStatusChange)listOfChanges.get(listOfChanges.size() - 1);
    }

    @Override
    public List getAllDetached(Integer oldReviewCycleInstanceId, Integer newReviewCycleInstanceId) {
        Criteria crit = this.getSession().createCriteria(DocumentVersion.class);
        crit.createCriteria("actualReviewCycleNodeInstance").createCriteria("reviewCycleCellInstance").createCriteria("reviewCycleInstance").add(Restrictions.idEq((Object)oldReviewCycleInstanceId));
        crit.createCriteria("document").createCriteria("objectPlanner").createCriteria("reviewCycleInstance").add(Restrictions.idEq((Object)newReviewCycleInstanceId));
        return crit.list();
    }

    @Override
    public List getAllOfProjectWithinTime(Integer projectId, Calendar activeMonth) {
        GregorianCalendar intervalStartDate = new GregorianCalendar(activeMonth.get(1), activeMonth.get(2), 1, 0, 0, 0);
        GregorianCalendar intervalEndDate = (GregorianCalendar)intervalStartDate.clone();
        intervalEndDate.add(2, 1);
        Date debugStart = intervalStartDate.getTime();
        Date debugEnd = intervalEndDate.getTime();
        Criteria crit = this.getSession().createCriteria(DocumentVersion.class);
        crit.createCriteria("document").createCriteria("documentList").createCriteria("subProject").createCriteria("project").add(Restrictions.idEq((Object)projectId));
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)7));
        crit.add((Criterion)Restrictions.ge((String)"uploaded", (Object)intervalStartDate.getTime()));
        crit.add((Criterion)Restrictions.lt((String)"uploaded", (Object)intervalEndDate.getTime()));
        return crit.list();
    }

    @Override
    public boolean isDocumentNumberAlreadyInUse(String documentNumber, Integer documentImplId) {
        Criteria crit = this.getSession().createCriteria(DocumentVersion.class);
        crit.createCriteria("document").add(Restrictions.idEq((Object)documentImplId));
        crit.add((Criterion)Restrictions.like((String)"name", (Object)documentNumber));
        List results = crit.list();
        if (results.size() == 0) {
            return false;
        }
        for (DocumentVersion version : results) {
            if (version.getStatus() == 7 || this.isDocumentVersionPartOfInvalidatedRevisionBranch(version)) continue;
            return true;
        }
        return false;
    }

    private boolean isDocumentVersionPartOfInvalidatedRevisionBranch(DocumentVersion version) {
        if (version.getRevisedDocumentVersion() == null) {
            return false;
        }
        List<DocumentVersion> allVersions = version.getDocument().getDocumentVersionsSortedByVersion();
        boolean positionFound = false;
        for (DocumentVersion dv : allVersions) {
            if (dv.getId().equals(version.getId())) {
                positionFound = true;
            } else if (!positionFound) continue;
            if (dv.getStatus() != 5 || !dv.getRevisedDocumentVersion().getId().equals(version.getRevisedDocumentVersion().getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public DocumentVersion getDocumentVersionByName(String documentVersionName, Integer projectId) {
        Criteria crit = this.getSession().createCriteria(DocumentVersion.class);
        crit.add((Criterion)Restrictions.like((String)"name", (Object)documentVersionName));
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)4));
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)5));
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)7));
        crit.createCriteria("document").createCriteria("documentList").createCriteria("subProject").createCriteria("project").add(Restrictions.idEq((Object)projectId));
        return (DocumentVersion)crit.uniqueResult();
    }

    @Override
    public List<DocumentVersion> getReleasedVersionsOfRevisions(Integer subProjectId) {
        Criteria crit = this.getSession().createCriteria(DocumentVersion.class);
        crit.add(Restrictions.isNotNull((String)"revisedDocumentVersion"));
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)2));
        crit.createCriteria("document").createCriteria("documentList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        List revisions = crit.list();
        ArrayList<DocumentVersion> releasedVersions = new ArrayList<DocumentVersion>();
        for (DocumentVersion revision : revisions) {
            if (releasedVersions.contains(revision.getRevisedDocumentVersion())) continue;
            releasedVersions.add(revision.getRevisedDocumentVersion());
        }
        return releasedVersions;
    }

    @Override
    public List<DocumentVersion> getReleasedVersionsOfReactivatedVersions(Integer subProjectId) {
        Criteria crit = this.getSession().createCriteria(DocumentVersion.class);
        crit.add(Restrictions.isNotNull((String)"reactivatedDocumentVersion"));
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)2));
        crit.createCriteria("document").createCriteria("documentList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        List revisions = crit.list();
        ArrayList<DocumentVersion> releasedVersions = new ArrayList<DocumentVersion>();
        for (DocumentVersion revision : revisions) {
            if (revision.isInvalidatedAll() || releasedVersions.contains(revision.getReactivatedDocumentVersion())) continue;
            releasedVersions.add(revision.getReactivatedDocumentVersion());
        }
        return releasedVersions;
    }

    @Override
    public List<DocumentVersion> getDocumentVersionsForReviewCycleInstance(Integer reviewCycleInstanceImplId) {
        Criteria crit = this.getSession().createCriteria(DocumentVersion.class);
        crit.createCriteria("document").createCriteria("objectPlanner").createCriteria("reviewCycleInstance").add(Restrictions.idEq((Object)reviewCycleInstanceImplId));
        return crit.list();
    }

    @Override
    public int getDocumentVersionCount(Integer projectId) {
        Criteria crit = this.getSession().createCriteria(DocumentVersion.class);
        if (projectId != null) {
            crit.createCriteria("document").createCriteria("documentList").createCriteria("subProject").createCriteria("project").add(Restrictions.idEq((Object)projectId));
        }
        crit.setProjection((Projection)Projections.count((String)"id"));
        List list = crit.list();
        if (list == null || list.isEmpty()) {
            return 0;
        }
        return (Integer)list.get(0);
    }

    @Override
    public int getDocumentVersionCountGroupedByDoc(Integer projectId) {
        Criteria crit = this.getSession().createCriteria(DocumentVersion.class);
        if (projectId != null) {
            crit.createCriteria("document").createCriteria("documentList").createCriteria("subProject").createCriteria("project").add(Restrictions.idEq((Object)projectId));
        }
        crit.setProjection((Projection)Projections.count((String)"id"));
        crit.setProjection((Projection)Projections.groupProperty((String)"document"));
        List list = crit.list();
        if (list == null || list.isEmpty()) {
            return 0;
        }
        return list.size();
    }

    @Override
    public boolean isAsBuiltReferenced(Integer documentVersionId) {
        Criteria crit = this.getSession().createCriteria(DocumentVersion.class);
        crit.createCriteria("asBuiltReference").add(Restrictions.idEq((Object)documentVersionId));
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)7));
        List results = crit.list();
        return results.size() != 0;
    }
}

