/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.cycle.AttachedReviewCyclePositionImpl;
import at.cdes.bo.data.cycle.ReviewCycleInstance;
import at.cdes.bo.data.cycle.ReviewCyclePosition;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstance;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.label.DocumentVersionTextFieldRenderer;
import at.cdes.db.dao.ReviewCycleNodeInstanceDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;

public class ReviewCycleNodeInstanceDAOHibernate
extends HibernateDaoSupport
implements ReviewCycleNodeInstanceDAO {
    static Logger logger = Logger.getLogger(DocumentVersionTextFieldRenderer.class);

    @Override
    public ReviewCycleNodeInstanceImpl get(Integer id) {
        return (ReviewCycleNodeInstanceImpl)this.getSession().load(ReviewCycleNodeInstanceImpl.class, (Serializable)id);
    }

    @Override
    public List getAll(Integer reviewCycleCellInstanceId) {
        if (reviewCycleCellInstanceId != null) {
            return this.findHibernate("from ReviewCycleNodeInstance where reviewCycleCellInstance.id = ?", reviewCycleCellInstanceId);
        }
        return this.loadAllHibernate(ReviewCycleNodeInstanceImpl.class);
    }

    @Override
    public ReviewCycleNodeInstanceImpl save(ReviewCycleNodeInstanceImpl cons) {
        return this.get((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public ReviewCycleNodeInstanceImpl merge(ReviewCycleNodeInstanceImpl cons) {
        cons = (ReviewCycleNodeInstanceImpl)this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public void delete(ReviewCycleNodeInstanceImpl cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public ReviewCycleNodeInstanceRelease getReleased(Integer id) {
        return (ReviewCycleNodeInstanceRelease)this.getSession().load(ReviewCycleNodeInstanceRelease.class, (Serializable)id);
    }

    @Override
    public ReviewCycleNodeInstanceRelease save(ReviewCycleNodeInstanceRelease cons) {
        return this.getReleased((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public ReviewCycleNodeInstanceRelease update(ReviewCycleNodeInstanceRelease cons) {
        this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public void delete(ReviewCycleNodeInstanceRelease cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public ReviewCycleNodeInstanceRelease getReleased(Integer cycleInstance, Integer reviewCycleNodeId) {
        Criteria crit = this.getSession().createCriteria(ReviewCycleNodeInstanceRelease.class);
        crit.createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)reviewCycleNodeId));
        crit.createCriteria("reviewCycleCellInstance").createCriteria("reviewCycleInstance").add(Restrictions.idEq((Object)cycleInstance));
        return (ReviewCycleNodeInstanceRelease)crit.uniqueResult();
    }

    @Override
    public ReviewCycleNodeInstanceImpl getUnreleased(ReviewCycleInstance instance, ReviewCycleNode node) {
        Criteria crit = this.getSession().createCriteria(ReviewCycleNodeInstanceImpl.class);
        crit.createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)node.getId()));
        crit.createCriteria("reviewCycleCellInstance").createCriteria("reviewCycleInstance").add(Restrictions.idEq((Object)instance.getId()));
        return (ReviewCycleNodeInstanceImpl)crit.uniqueResult();
    }

    @Override
    public List<AttachedReviewCyclePositionImpl> getAttachedReviewCyclePositions(ReviewCycleNodeInstance nodeInstance, DocumentVersion docVersion) {
        Criteria crit = this.getSession().createCriteria(AttachedReviewCyclePositionImpl.class);
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)docVersion.getId()));
        Integer instanceId = nodeInstance instanceof ReviewCycleNodeInstanceRelease ? ((ReviewCycleNodeInstanceRelease)nodeInstance).getReviewCycleNodeInstance().getId() : nodeInstance.getId();
        crit.createCriteria("reviewCycleNodeInstance").add(Restrictions.idEq((Object)instanceId));
        return crit.list();
    }

    @Override
    public List<AttachedReviewCyclePositionImpl> getAttachedReviewCyclePositionsByPP(ReviewCycleNodeInstance nodeInstance, ProjectParticipation pp) {
        Criteria crit = this.getSession().createCriteria(AttachedReviewCyclePositionImpl.class);
        crit.createCriteria("projectParticipation").add(Restrictions.idEq((Object)pp.getId()));
        Integer instanceId = nodeInstance instanceof ReviewCycleNodeInstanceRelease ? ((ReviewCycleNodeInstanceRelease)nodeInstance).getReviewCycleNodeInstance().getId() : nodeInstance.getId();
        crit.createCriteria("reviewCycleNodeInstance").add(Restrictions.idEq((Object)instanceId));
        return crit.list();
    }

    @Override
    public List<ReviewCyclePosition> getRelevantReviewCyclePositions(ReviewCycleNodeInstance nodeInstance, DocumentVersion docVersion) {
        ArrayList<ReviewCyclePosition> ret = new ArrayList<ReviewCyclePosition>();
        logger.info((Object)("trying to get getAttachedReviewCyclePositions for rcniRel = " + nodeInstance));
        ret.addAll(this.getAttachedReviewCyclePositions(nodeInstance, docVersion));
        if (nodeInstance.getReviewCyclePositions() != null) {
            ret.addAll(nodeInstance.getReviewCyclePositions().values());
        }
        return ret;
    }

    @Override
    public ReviewCycleNodeInstanceImpl update(ReviewCycleNodeInstanceImpl cons) {
        this.getSession().update((Object)cons);
        return (ReviewCycleNodeInstanceImpl)this.getSession().get(ReviewCycleNodeInstanceImpl.class, (Serializable)cons.getId());
    }

    @Override
    public ReviewCycleNodeInstanceRelease getLatestReleased(Integer reviewCycleNodeInstanceImplId) {
        Criteria crit = this.getSession().createCriteria(ReviewCycleNodeInstanceRelease.class);
        crit.createCriteria("reviewCycleNodeInstance").add(Restrictions.idEq((Object)reviewCycleNodeInstanceImplId));
        List res = crit.list();
        if (res.size() == 0) {
            return null;
        }
        return (ReviewCycleNodeInstanceRelease)res.get(res.size() - 1);
    }
}

