/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.util;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class BinaryBlobType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return byte[].class;
    }

    public boolean equals(Object x, Object y) {
        return x == y || x != null && y != null && Arrays.equals((byte[])x, (byte[])y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Blob blob = rs.getBlob(names[0]);
        if (blob == null) {
            return new byte[0];
        }
        return blob.getBytes(1L, (int)blob.length());
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        byte[] val = (byte[])value;
        if (val == null || val.length == 0 || value == null) {
            st.setNull(index, 2004);
            return;
        }
        st.setBytes(index, (byte[])value);
    }

    public Object deepCopy(Object value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = (byte[])value;
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    public boolean isMutable() {
        return true;
    }

    public int hashCode(Object arg0) throws HibernateException {
        throw new HibernateException("HashCode in BinaryBlob is called");
    }

    public Serializable disassemble(Object arg) throws HibernateException {
        byte[] bytes = (byte[])arg;
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    public Object assemble(Serializable arg0, Object arg1) throws HibernateException {
        byte[] bytes = (byte[])arg0;
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    public Object replace(Object arg0, Object arg1, Object arg2) throws HibernateException {
        byte[] bytes = (byte[])arg0;
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }
}

