/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.ext.preview.AbstractDocumentVersionMimeSource;
import at.cdes.preview.api.Annotation;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.ByteArrayMimeInputStream;
import at.cdes.preview.streams.FileMimeInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class DocumentVersionCustomLabelMimeSource
extends AbstractDocumentVersionMimeSource {
    @Override
    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        Integer id = (Integer)parameters[0];
        DocumentVersion dv = this.getDocumentVersionDAO().get(id);
        List customTextFields = (List)parameters[1];
        List customTextFieldValues = (List)parameters[2];
        try (FileMimeInputStream stream = null;){
            IMimeInputStream ret;
            File file = this.getFileFinder().findFile(dv.getFileName(), CDESFileRepository.PLANREPOSITORY);
            String unique = this.getFileFinder().makeUniqueName(dv.getFileName(), CDESFileRepository.PLANREPOSITORY);
            stream = new FileMimeInputStream(file, unique, dv.getName() + "." + dv.getFileType(), DefaultHttpContext.getInstance().getMimeType(dv.getFileName()));
            if (dv.getLabelContentId() == null) {
                FileMimeInputStream ret2 = stream;
                stream = null;
                FileMimeInputStream fileMimeInputStream = ret2;
                return fileMimeInputStream;
            }
            IHPGLRenderer renderer = this.getHpglRenderer();
            LabelContent label = this.getLabelOperations().getLabelContent(dv.getLabelContentId());
            int angle = dv.getPreviewRotation();
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            Date creationDate = new Date();
            creationDate.setTime(file.lastModified());
            byte[] fdf_data = this.getLabelOperations().formatFDFCustomLabel(dv, customTextFieldValues, customTextFields, "pdf".equalsIgnoreCase(dv.getFileType()));
            ByteArrayMimeInputStream fdf_is = new ByteArrayMimeInputStream(fdf_data, 0.001 * (double)file.lastModified(), label.getName(), "application/vnd.fdf");
            annotations.add(new Annotation((IMimeInputStream)fdf_is, "", "", "", 2));
            IMimeInputStream iMimeInputStream = ret = renderer.insertAnnotations((IMimeInputStream)stream, angle, "", annotations);
            return iMimeInputStream;
        }
    }
}

