/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.msp.auth;

import at.cdes.msp.auth.JcifsNtlmScheme;
import java.net.InetAddress;
import java.net.UnknownHostException;
import jcifs.Config;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.DefaultHttpParamsFactory;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.httpclient.params.HttpParamsFactory;

public class NtlmJcifsCredentials {
    public static void register(String username, String password, String userDomain) {
        String computername = "";
        try {
            computername = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        NtlmJcifsCredentials.register(username, password, computername, userDomain);
    }

    public static void register(String username, String password, String computername, String domain) {
        final NTCredentials ntCred = new NTCredentials(username, password, computername, domain);
        final CredentialsProvider ntlmCredProvider = new CredentialsProvider(){

            public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
                return ntCred;
            }
        };
        DefaultHttpParamsFactory paramFact = new DefaultHttpParamsFactory(){

            protected HttpParams createParams() {
                HttpParams htp = super.createParams();
                htp.setParameter("http.authentication.credential-provider", (Object)ntlmCredProvider);
                return htp;
            }
        };
        DefaultHttpParams.setHttpParamsFactory((HttpParamsFactory)paramFact);
        Config.setProperty((String)"jcifs.encoding", (String)"ASCII");
        AuthPolicy.registerAuthScheme((String)"NTLM", JcifsNtlmScheme.class);
    }
}

