/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.spring;

import java.security.Provider;
import java.security.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDESInit {
    private static final Logger log = LoggerFactory.getLogger(CDESInit.class);
    private static final String BC_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";

    public static void init() {
        if (Security.getProvider("BC") == null) {
            try {
                Class<?> bcClass = Class.forName(BC_PROVIDER_CLASS);
                Security.addProvider((Provider)bcClass.newInstance());
                log.info("Added bouncycastle security provider.");
            }
            catch (ClassNotFoundException e) {
                log.warn("Cannot find bouncycastle provider [org.bouncycastle.jce.provider.BouncyCastleProvider] on classpath.", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error("Cannot instantiate bouncycastle provider [org.bouncycastle.jce.provider.BouncyCastleProvider].", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("Access to bouncycastle provider [org.bouncycastle.jce.provider.BouncyCastleProvider] has been denied.", (Throwable)e);
            }
        }
    }
}

