/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.plot;

import at.cdes.bo.plot.BoundingBox;
import at.cdes.preview.api.BoundingBoxWithAngle;

public class TiledImage {
    private int xtiles;
    private int ytiles;
    private double resolution;
    private int width;
    private int height;
    private int tileWidth;
    private int tileHeight;
    private BoundingBox boundingBox;
    private int angle;

    public TiledImage(BoundingBox boundingBox, int baseSize, double resolution, int angle) {
        this.boundingBox = boundingBox;
        this.resolution = resolution;
        this.angle = angle;
        switch (this.angle / 90 % 4) {
            case 0: 
            case 2: {
                this.width = (int)Math.ceil((boundingBox.getUrx() - boundingBox.getLlx()) * this.resolution / 72.0);
                this.height = (int)Math.ceil((boundingBox.getUry() - boundingBox.getLly()) * this.resolution / 72.0);
                break;
            }
            default: {
                this.height = (int)Math.ceil((boundingBox.getUrx() - boundingBox.getLlx()) * this.resolution / 72.0);
                this.width = (int)Math.ceil((boundingBox.getUry() - boundingBox.getLly()) * this.resolution / 72.0);
            }
        }
        this.xtiles = (int)Math.floor((this.width + baseSize - 1) / baseSize);
        this.ytiles = (int)Math.floor((this.height + baseSize - 1) / baseSize);
        this.tileWidth = (int)Math.ceil(this.width / this.xtiles);
        this.tileHeight = (int)Math.ceil(this.height / this.ytiles);
    }

    public int getTileWidth(int itile) {
        if (itile < this.xtiles - 1) {
            return this.tileWidth;
        }
        return this.width - (this.xtiles - 1) * this.tileWidth;
    }

    public int getTileHeight(int jtile) {
        if (jtile < this.ytiles - 1) {
            return this.tileHeight;
        }
        return this.height - (this.ytiles - 1) * this.tileHeight;
    }

    public BoundingBoxWithAngle getTileBox(int itile, int jtile) {
        double lly;
        double ury;
        double urx;
        double llx;
        BoundingBoxWithAngle ret = new BoundingBoxWithAngle();
        ret.setAngle(this.angle);
        ret.setUserUnit(this.boundingBox.getUserUnit());
        switch ((this.angle + 360) / 90 % 4) {
            case 0: {
                llx = this.boundingBox.getLlx() + (double)(itile * this.tileWidth) * 72.0 / this.resolution;
                urx = itile < this.xtiles - 1 ? this.boundingBox.getLlx() + (double)((itile + 1) * this.tileWidth) * 72.0 / this.resolution : this.boundingBox.getLlx() + (double)this.width * 72.0 / this.resolution;
                ury = this.boundingBox.getUry() - (double)(jtile * this.tileHeight) * 72.0 / this.resolution;
                if (jtile < this.ytiles - 1) {
                    lly = this.boundingBox.getUry() - (double)((jtile + 1) * this.tileHeight) * 72.0 / this.resolution;
                    break;
                }
                lly = this.boundingBox.getUry() - (double)this.height * 72.0 / this.resolution;
                break;
            }
            case 1: {
                urx = this.boundingBox.getUrx() - (double)(jtile * this.tileHeight) * 72.0 / this.resolution;
                llx = jtile < this.ytiles - 1 ? this.boundingBox.getUrx() - (double)((jtile + 1) * this.tileHeight) * 72.0 / this.resolution : this.boundingBox.getUrx() - (double)this.height * 72.0 / this.resolution;
                ury = this.boundingBox.getUry() - (double)(itile * this.tileWidth) * 72.0 / this.resolution;
                if (itile < this.xtiles - 1) {
                    lly = this.boundingBox.getUry() - (double)((itile + 1) * this.tileWidth) * 72.0 / this.resolution;
                    break;
                }
                lly = this.boundingBox.getUry() - (double)this.width * 72.0 / this.resolution;
                break;
            }
            case 2: {
                urx = this.boundingBox.getUrx() - (double)(itile * this.tileWidth) * 72.0 / this.resolution;
                llx = itile < this.xtiles - 1 ? this.boundingBox.getUrx() - (double)((itile + 1) * this.tileWidth) * 72.0 / this.resolution : this.boundingBox.getUrx() - (double)this.width * 72.0 / this.resolution;
                lly = this.boundingBox.getLly() + (double)(jtile * this.tileHeight) * 72.0 / this.resolution;
                if (jtile < this.ytiles - 1) {
                    ury = this.boundingBox.getLly() + (double)((jtile + 1) * this.tileHeight) * 72.0 / this.resolution;
                    break;
                }
                ury = this.boundingBox.getLly() + (double)this.height * 72.0 / this.resolution;
                break;
            }
            default: {
                llx = this.boundingBox.getLlx() + (double)(jtile * this.tileHeight) * 72.0 / this.resolution;
                urx = jtile < this.ytiles - 1 ? this.boundingBox.getLlx() + (double)((jtile + 1) * this.tileHeight) * 72.0 / this.resolution : this.boundingBox.getLlx() + (double)this.height * 72.0 / this.resolution;
                lly = this.boundingBox.getLly() + (double)(itile * this.tileWidth) * 72.0 / this.resolution;
                ury = itile < this.xtiles - 1 ? this.boundingBox.getLly() + (double)((itile + 1) * this.tileWidth) * 72.0 / this.resolution : this.boundingBox.getLly() + (double)this.width * 72.0 / this.resolution;
            }
        }
        ret.setLlx(llx);
        ret.setLly(lly);
        ret.setUrx(urx);
        ret.setUry(ury);
        return ret;
    }

    public BoundingBoxWithAngle getTileBox(int itile, int jtile, BoundingBox r_bbox) {
        BoundingBoxWithAngle ret = this.getTileBox(itile, jtile);
        if (r_bbox.getLlx() != null && ret.getLlx() < r_bbox.getLlx()) {
            ret.setLlx(r_bbox.getLlx().doubleValue());
        }
        if (r_bbox.getLly() != null && ret.getLly() < r_bbox.getLly()) {
            ret.setLly(r_bbox.getLly().doubleValue());
        }
        if (r_bbox.getUrx() != null && ret.getUrx() > r_bbox.getUrx()) {
            ret.setUrx(r_bbox.getUrx().doubleValue());
        }
        if (r_bbox.getUry() != null && ret.getUry() > r_bbox.getUry()) {
            ret.setUry(r_bbox.getUry().doubleValue());
        }
        return ret;
    }

    public int getXtiles() {
        return this.xtiles;
    }

    public int getYtiles() {
        return this.ytiles;
    }

    public double getResolution() {
        return this.resolution;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public int getAngle() {
        return this.angle;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

