/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.api.document.PreviewRenderer;
import at.cdes.api.document.compositeDto.SeekLabelResult;
import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.TemporaryDocumentVersion;
import at.cdes.bo.data.sec.TabSession;
import at.cdes.bo.number.NumberCalculator;
import at.cdes.db.dao.DocumentDAO;
import at.cdes.db.dao.ReviewCycleCellDAO;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PreviewException;
import at.cdes.util.ImplContextHelper;
import at.cdes.util.TemporaryDocumentVersionMapper;

public class PreviewRendererImpl
implements PreviewRenderer {
    private VisitlessMimeSource temporaryDocumentMimeSource;
    private NumberCalculator numberCalculator;
    private DocumentDAO documentDAO;
    private ReviewCycleCellDAO reviewCycleCellDAO;
    private VisitlessMimeSource temporaryDocumentPngTileMimeSource;

    public void setTemporaryDocumentMimeSource(VisitlessMimeSource temporaryDocumentMimeSource) {
        this.temporaryDocumentMimeSource = temporaryDocumentMimeSource;
    }

    public void setNumberCalculator(NumberCalculator numberCalculator) {
        this.numberCalculator = numberCalculator;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setReviewCycleCellDAO(ReviewCycleCellDAO reviewCycleCellDAO) {
        this.reviewCycleCellDAO = reviewCycleCellDAO;
    }

    public void setTemporaryDocumentPngTileMimeSource(VisitlessMimeSource temporaryDocumentPngTileMimeSource) {
        this.temporaryDocumentPngTileMimeSource = temporaryDocumentPngTileMimeSource;
    }

    public IMimeInputStream renderPngPreview(at.cdes.api.document.compositeDto.TemporaryDocumentVersion documentVersion, Long personId, String userName, SeekLabelResult seekResult, Long reviewCycleCellId, Integer pixelSize, Integer angle) {
        DocumentImpl document = this.documentDAO.get(documentVersion.getUnreleasedDocumentId().intValue());
        TemporaryDocumentVersion tdv = TemporaryDocumentVersionMapper.mapVersion(documentVersion, reviewCycleCellId);
        tdv.setVersionPartA(documentVersion.getVersionPartA());
        tdv.setVersionPartB(documentVersion.getVersionPartB());
        ImplContextHelper.bindTabSession(new TabSession(personId.intValue(), userName));
        ImplContextHelper.setTemporaryDocumentVersion(tdv);
        try {
            return this.temporaryDocumentMimeSource.getMimeStream(new Object[]{pixelSize, true, angle});
        }
        catch (PreviewException e) {
            throw new RuntimeException(e);
        }
    }
}

