/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.file;

import at.cdes.gwtdto.GWTSessionFile;
import at.cdes.impl.file.SessionFileUploadRegistry;
import at.cdes.preview.api.IOError;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.GWTFileHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.server.UID;
import java.util.Calendar;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;

public class CdesGWTFileHandler
implements GWTFileHandler {
    private SessionFileUploadRegistry sessionFileUploadRegistry;
    private String tempUploadRepository;
    private int fileExpirationMinutes;

    @Override
    public GWTSessionFile saveFileTemporary(FileItem fileItem) {
        String filetype = FilenameUtils.getExtension((String)fileItem.getName());
        String filename = FilenameUtils.getBaseName((String)fileItem.getName());
        InputStream fis = null;
        try {
            fis = fileItem.getInputStream();
            return this.saveFileTemporary(filename, filetype, fis);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public GWTSessionFile saveFileTemporary(String filename, String filetype, InputStream fis) {
        String tmpFileName = this.getRandomFileName();
        try {
            int n;
            File tmpFile = new File(tmpFileName);
            FileOutputStream os = new FileOutputStream(tmpFile);
            byte[] buf = new byte[16384];
            while ((n = fis.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, n);
            }
            ((OutputStream)os).close();
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.getSessionFile(filename, filetype, tmpFileName);
    }

    @Override
    public GWTSessionFile getSessionFile(String filename, String filetype, String filepath) {
        Calendar expirationDate = Calendar.getInstance();
        expirationDate.add(12, this.fileExpirationMinutes);
        GWTSessionFile sessionFile = new GWTSessionFile(new UID().toString(), filename, filetype, filepath, expirationDate);
        this.sessionFileUploadRegistry.registerSessionFile(sessionFile);
        return sessionFile;
    }

    @Override
    public String getOriginalFileName(String sessionFileId) {
        GWTSessionFile sessionFile = this.sessionFileUploadRegistry.getSessionFile(sessionFileId);
        if (sessionFile == null || sessionFile.getFilename() == null) {
            return null;
        }
        String ret = sessionFile.getFilename();
        if (sessionFile.getFiletype() != null && !sessionFile.getFiletype().isEmpty()) {
            ret = ret + "." + sessionFile.getFiletype();
        }
        return ret;
    }

    @Override
    public FileMimeInputStream getFileMimeInputStream(String sessionFileId) throws IOError {
        GWTSessionFile sessionFile = this.sessionFileUploadRegistry.getSessionFile(sessionFileId);
        FileMimeInputStream is = new FileMimeInputStream(sessionFile.getPath(), sessionFile.getFilename(), sessionFile.getFiletype());
        return is;
    }

    @Override
    public String getRandomFileName() {
        UID uid = new UID();
        return this.tempUploadRepository + File.separator + uid.toString().replace(":", "").replace("-", "") + ".tmp";
    }

    public void setSessionFileUploadRegistry(SessionFileUploadRegistry sessionFileUploadRegistry) {
        this.sessionFileUploadRegistry = sessionFileUploadRegistry;
    }

    public void setTempUploadRepository(String tempUploadRepository) {
        this.tempUploadRepository = tempUploadRepository;
    }

    public void setFileExpirationMinutes(int fileExpirationMinutes) {
        this.fileExpirationMinutes = fileExpirationMinutes;
    }
}

