/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.helper;

import at.cdes.api.sec.PersonVariablesDTO;
import at.cdes.bo.data.attachment.Attachment;
import at.cdes.bo.data.cycle.AttachedReviewCyclePositionImpl;
import at.cdes.bo.data.cycle.Realm;
import at.cdes.bo.data.cycle.ReviewCycleCommentOption;
import at.cdes.bo.data.cycle.ReviewCycleEntryResult;
import at.cdes.bo.data.cycle.ReviewCycleEntryStatementResultImpl;
import at.cdes.bo.data.cycle.ReviewCyclePositionRelease;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.ReviewCycleResultOption;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnectionResult;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnectionStatementResultImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentRef;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.ReleasedDocument;
import at.cdes.bo.data.message.InfoMessage;
import at.cdes.bo.data.meta.MetaInformation;
import at.cdes.bo.data.meta.MetaTag;
import at.cdes.bo.data.meta.PlanningNotificationDateMetaInformation;
import at.cdes.bo.data.meta.PlanningNotificationMetaInformation;
import at.cdes.bo.data.meta.PlanningNotificationTextMetaInformation;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.object.CDESObjectImpl;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.organisation.Organisation;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.person.PersonVariables;
import at.cdes.bo.data.planningNotification.PlanningNotification;
import at.cdes.bo.data.planningNotification.PlanningNotificationAttachment;
import at.cdes.bo.data.planningNotification.PlanningNotificationOrder;
import at.cdes.bo.data.planningNotification.PlanningNotificationTemplate;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.task.ReviewableTask;
import at.cdes.bo.data.workflow.Workflow;
import at.cdes.bo.data.workflow.WorkflowAction;
import at.cdes.bo.data.workflow.WorkflowActionEntityStatusChange;
import at.cdes.bo.data.workflow.WorkflowActionListener;
import at.cdes.bo.data.workflow.WorkflowActionNodeEmailNotification;
import at.cdes.bo.data.workflow.WorkflowActionNodeTransition;
import at.cdes.bo.data.workflow.WorkflowActionPrecondition;
import at.cdes.bo.data.workflow.WorkflowActionTokenEmailNotification;
import at.cdes.bo.data.workflow.WorkflowActionTokenTransition;
import at.cdes.bo.data.workflow.WorkflowActivity;
import at.cdes.bo.data.workflow.WorkflowActivityHistoryEntry;
import at.cdes.bo.data.workflow.WorkflowActivityPositionResult;
import at.cdes.bo.data.workflow.WorkflowEntityStatus;
import at.cdes.bo.data.workflow.WorkflowNode;
import at.cdes.bo.data.workflow.WorkflowNodePosition;
import at.cdes.bo.data.workflow.WorkflowNodePositionResultOption;
import at.cdes.bo.data.workflow.WorkflowNodeTemplate;
import at.cdes.bo.data.workflow.WorkflowTemplate;
import at.cdes.bo.data.workflow.WorkflowToken;
import at.cdes.oldGwtDto.AttachmentDTO;
import at.cdes.oldGwtDto.CDESContext;
import at.cdes.oldGwtDto.DocumentDTO;
import at.cdes.oldGwtDto.DocumentReferenceDTO;
import at.cdes.oldGwtDto.DocumentVersionDTO;
import at.cdes.oldGwtDto.MessageDTO;
import at.cdes.oldGwtDto.MetaTagDTO;
import at.cdes.oldGwtDto.NetworkDTO;
import at.cdes.oldGwtDto.ObjectDTO;
import at.cdes.oldGwtDto.ObjectPlannerDTO;
import at.cdes.oldGwtDto.OrganisationDTO;
import at.cdes.oldGwtDto.OrganisationPersonDTO;
import at.cdes.oldGwtDto.PersonDTO;
import at.cdes.oldGwtDto.PlanningNotificationAttachmentDTO;
import at.cdes.oldGwtDto.PlanningNotificationDTO;
import at.cdes.oldGwtDto.PlanningNotificationDateMetaInformationDTO;
import at.cdes.oldGwtDto.PlanningNotificationMetaInformationDTO;
import at.cdes.oldGwtDto.PlanningNotificationOrderDTO;
import at.cdes.oldGwtDto.PlanningNotificationTaskDTO;
import at.cdes.oldGwtDto.PlanningNotificationTemplateDTO;
import at.cdes.oldGwtDto.PlanningNotificationTextMetaInformationDTO;
import at.cdes.oldGwtDto.ProjectDTO;
import at.cdes.oldGwtDto.ProjectParticipantDTO;
import at.cdes.oldGwtDto.ProjectParticipationDTO;
import at.cdes.oldGwtDto.RealmDTO;
import at.cdes.oldGwtDto.ReviewContextDTO;
import at.cdes.oldGwtDto.ReviewCycleCommentOptionDTO;
import at.cdes.oldGwtDto.ReviewCycleNodeInstanceDTO;
import at.cdes.oldGwtDto.ReviewCycleNodePositionDTO;
import at.cdes.oldGwtDto.ReviewCycleNodeResultDTO;
import at.cdes.oldGwtDto.ReviewCyclePositionResultDTO;
import at.cdes.oldGwtDto.ReviewCycleResultOptionDTO;
import at.cdes.oldGwtDto.ReviewHistoryDTO;
import at.cdes.oldGwtDto.SignerDTO;
import at.cdes.oldGwtDto.UploadResultDTO;
import at.cdes.oldGwtDto.VersionStatementDTO;
import at.cdes.oldGwtDto.WorkflowActionDTO;
import at.cdes.oldGwtDto.WorkflowActionEntityStatusChangeDTO;
import at.cdes.oldGwtDto.WorkflowActionListenerDTO;
import at.cdes.oldGwtDto.WorkflowActionNodeEmailNotificationDTO;
import at.cdes.oldGwtDto.WorkflowActionNodeTransitionDTO;
import at.cdes.oldGwtDto.WorkflowActionPreconditionDTO;
import at.cdes.oldGwtDto.WorkflowActionTokenEmailNotificationDTO;
import at.cdes.oldGwtDto.WorkflowActionTokenTransitionDTO;
import at.cdes.oldGwtDto.WorkflowActivityDTO;
import at.cdes.oldGwtDto.WorkflowActivityHistoryEntryDTO;
import at.cdes.oldGwtDto.WorkflowActivityPositionResultDTO;
import at.cdes.oldGwtDto.WorkflowDTO;
import at.cdes.oldGwtDto.WorkflowEntityStatusDTO;
import at.cdes.oldGwtDto.WorkflowNodeDTO;
import at.cdes.oldGwtDto.WorkflowNodePositionDTO;
import at.cdes.oldGwtDto.WorkflowNodePositionResultOptionDTO;
import at.cdes.oldGwtDto.WorkflowNodeTemplateDTO;
import at.cdes.oldGwtDto.WorkflowTemplateDTO;
import at.cdes.oldGwtDto.WorkflowTokenDTO;
import at.cdes.util.ConfigurationHelper;
import at.cdes.util.DateHelper;
import at.cdes.util.TapestryI18nHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CdesDTOHelper {
    private static final Logger logger = Logger.getLogger(CdesDTOHelper.class);

    public static WorkflowTokenDTO getWorkflowTokenDTO(WorkflowToken token) {
        WorkflowTokenDTO tokenDTO = new WorkflowTokenDTO(token.getId(), token.getInitiator().getId(), token.getOwner().getId());
        return tokenDTO;
    }

    public static OrganisationPersonDTO getOrganisationPersonDTO(OrganisationPerson orgPerson, PersonDTO personDTO) {
        OrganisationPersonDTO orgPersonDTO = new OrganisationPersonDTO(orgPerson.getId(), orgPerson.getOrganisationalUnitName(), orgPerson.getFacsimileNumber(), orgPerson.getEmailSendTime(), orgPerson.getEmailSendMode(), orgPerson.getEmailAddress(), orgPerson.isInActive(), orgPerson.getRetiredComment(), orgPerson.getFrom(), orgPerson.getTo(), orgPerson.getPostalAddress(), orgPerson.getPostalCode(), orgPerson.getLocalityName(), orgPerson.getStateOrProvinceName(), orgPerson.getMobileTelephoneNumber(), orgPerson.getTelephoneNumber(), personDTO, CdesDTOHelper.getOrganisationDTO(orgPerson.getOrganisation()), orgPerson.isCertificateHasExpired());
        return orgPersonDTO;
    }

    public static OrganisationDTO getOrganisationDTO(Organisation organisation) {
        OrganisationDTO orgDTO = new OrganisationDTO(organisation.getId(), organisation.getMobileTelephoneNumber(), organisation.getFacsimileNumber(), organisation.getEmailAddress(), organisation.getName(), organisation.getPostalAddress(), organisation.getPostalCode(), organisation.getLocalityName(), organisation.getStateOrProvinceName(), organisation.getTelephoneNumber());
        return orgDTO;
    }

    public static UploadResultDTO getUploadResult(ReviewCycleCellConnectionResult cellConnectionresult) {
        UploadResultDTO resultDTO = new UploadResultDTO(cellConnectionresult.getId(), cellConnectionresult.getResultDate(), cellConnectionresult.getComment(), CdesDTOHelper.getProjectParticipantDTO(cellConnectionresult.getProjectParticipant(), false));
        return resultDTO;
    }

    public static UploadResultDTO getUploadResult(ReviewCycleEntryResult entryResult) {
        UploadResultDTO resultDTO = new UploadResultDTO(entryResult.getId(), entryResult.getResultDate(), entryResult.getComment(), CdesDTOHelper.getProjectParticipantDTO(entryResult.getProjectParticipant(), false));
        return resultDTO;
    }

    public static ProjectParticipationDTO getProjectParticipationDTO(ProjectParticipation pp) {
        HashMap<Integer, ProjectParticipantDTO> participants = new HashMap<Integer, ProjectParticipantDTO>();
        if (pp.getProjectParticipants() != null) {
            for (ProjectParticipant part : pp.getProjectParticipants().values()) {
                participants.put(part.getId(), CdesDTOHelper.getProjectParticipantDTO(part, false));
            }
        }
        ProjectParticipationDTO ppDTO = new ProjectParticipationDTO(pp.getId(), participants, CdesDTOHelper.getProjectDTO(pp.getProject()), pp.getComment());
        return ppDTO;
    }

    public static ProjectDTO getProjectDTO(Project project) {
        return CdesDTOHelper.getProjectDTO(project, CdesDTOHelper.getNetworkDTO(project.getNetwork()));
    }

    public static ProjectDTO getProjectDTO(Project project, NetworkDTO networkDTO) {
        return new ProjectDTO(project.getId(), project.getCode(), project.getName(), project.getStretchName(), project.getComment(), project.getRouteName(), project.getStretchKmFrom(), project.getStretchKmTo(), project.getStatus(), networkDTO);
    }

    public static NetworkDTO getNetworkDTO(Network network) {
        return new NetworkDTO(network.getId(), network.getDescription(), network.getName());
    }

    public static NetworkDTO getNetworkDTO(Network network, List<Project> projects) {
        NetworkDTO networkDTO = CdesDTOHelper.getNetworkDTO(network);
        ArrayList<ProjectDTO> projectDTOs = new ArrayList<ProjectDTO>();
        for (Project project : projects) {
            projectDTOs.add(CdesDTOHelper.getProjectDTO(project, networkDTO));
        }
        networkDTO.setProjects(projectDTOs);
        return networkDTO;
    }

    public static PlanningNotificationDTO getPlanningNotificationDTO(PlanningNotification planningNotification, boolean noOrdersMap) {
        HashMap<Integer, ProjectDTO> projectDTOs = new HashMap<Integer, ProjectDTO>();
        if (planningNotification.getAssociatedProjects() != null) {
            for (Project project : planningNotification.getAssociatedProjects().values()) {
                projectDTOs.put(project.getId(), CdesDTOHelper.getProjectDTO(project));
            }
        }
        PlanningNotificationDTO planningNotificationDTO = new PlanningNotificationDTO(planningNotification.getId(), planningNotification.getTitle(), planningNotification.getComment(), planningNotification.getType(), planningNotification.getSharepointLink(), planningNotification.getPath(), planningNotification.getFilename(), CdesDTOHelper.getNetworkDTO(planningNotification.getNetwork()), projectDTOs, null, null, CdesDTOHelper.getPlanningNotificationTemplateDTO(planningNotification.getPlanningNotificationTemplate()));
        if (!noOrdersMap) {
            HashMap<Integer, PlanningNotificationOrderDTO> notificationOrderDTOs = new HashMap<Integer, PlanningNotificationOrderDTO>();
            if (planningNotification.getPlanningNotificationOrders() != null) {
                for (PlanningNotificationOrder planningNotificationOrder : planningNotification.getPlanningNotificationOrders().values()) {
                    notificationOrderDTOs.put(planningNotificationOrder.getId(), CdesDTOHelper.getPlanningNotificationOrderDTO(planningNotificationOrder, planningNotificationDTO, CdesDTOHelper.getWorkflowDTO(planningNotificationOrder.getWorkflow())));
                }
            }
            planningNotificationDTO.setPlanningNotificationOrders(notificationOrderDTOs);
        }
        HashMap<Integer, PlanningNotificationMetaInformationDTO> metaInfoDTOs = new HashMap<Integer, PlanningNotificationMetaInformationDTO>();
        if (planningNotification.getPlanningNotificationMetaInformations() != null) {
            for (MetaInformation metaInformation : planningNotification.getPlanningNotificationMetaInformations().values()) {
                metaInfoDTOs.put(metaInformation.getId(), CdesDTOHelper.getPlanningNotificationMetaInformationDTO(metaInformation, planningNotificationDTO));
            }
        }
        planningNotificationDTO.setPlanningNotificationMetaInformations(metaInfoDTOs);
        return planningNotificationDTO;
    }

    public static WorkflowDTO getWorkflowDTO(Workflow workflow) {
        if (workflow == null) {
            return null;
        }
        WorkflowDTO workflowDTO = new WorkflowDTO(workflow.getId(), workflow.getWorkflowTemplate().getName(), workflow.getWorkflowTemplate().getComment(), new HashMap<Integer, WorkflowNodeDTO>(), workflow.isInitialized());
        for (WorkflowNode workflowNode : workflow.getWorkflowNodes().values()) {
            workflowDTO.getWorkflowNodes().put(workflowNode.getId(), CdesDTOHelper.getWorkflowNodeDTO(workflowNode, workflowDTO));
        }
        return workflowDTO;
    }

    public static WorkflowNodeDTO getWorkflowNodeDTO(WorkflowNode workflowNode, WorkflowDTO workflowDTO) {
        WorkflowNodeDTO nodeDTO = new WorkflowNodeDTO(workflowNode.getId(), workflowNode.getWorkflowNodeTemplate().getName(), workflowNode.getWorkflowNodeTemplate().isStartNode(), workflowNode.getWorkflowNodeTemplate().getPosition(), workflowNode.getWorkflowNodeTemplate().isWithMultiplePositions(), workflowDTO, new HashMap<Integer, WorkflowNodePositionDTO>());
        if (workflowNode.getWorkflowNodePositions() != null && !workflowNode.getWorkflowNodePositions().isEmpty()) {
            for (WorkflowNodePosition pos : workflowNode.getWorkflowNodePositions().values()) {
                nodeDTO.getWorkflowNodePositions().put(pos.getId(), CdesDTOHelper.getWorkflowNodePositionDTO(pos, nodeDTO));
            }
        }
        nodeDTO.setRoleTypeId(workflowNode.getWorkflowNodeTemplate().getRoleType().getId());
        return nodeDTO;
    }

    public static WorkflowDTO getWorkflowDTO(Workflow workflow, Map<Integer, WorkflowNodeTemplate> workflowNodeIdToTemplate, Map<Integer, List<WorkflowNode>> workflowIdToWorkflowNodes, Map<Integer, List<WorkflowNodePosition>> workflowNodeIdToWorkflowNodePositions) {
        if (workflow == null) {
            return null;
        }
        WorkflowDTO workflowDTO = new WorkflowDTO(workflow.getId(), workflow.getWorkflowTemplate().getName(), workflow.getWorkflowTemplate().getComment(), new HashMap<Integer, WorkflowNodeDTO>(), workflow.isInitialized());
        if (workflowIdToWorkflowNodes.containsKey(workflow.getId())) {
            for (WorkflowNode workflowNode : workflowIdToWorkflowNodes.get(workflow.getId())) {
                workflowDTO.getWorkflowNodes().put(workflowNode.getId(), CdesDTOHelper.getWorkflowNodeDTO(workflowNode, workflowDTO, workflowNodeIdToTemplate, workflowNodeIdToWorkflowNodePositions));
            }
        }
        return workflowDTO;
    }

    public static WorkflowNodeDTO getWorkflowNodeDTO(WorkflowNode workflowNode, WorkflowDTO workflowDTO, Map<Integer, WorkflowNodeTemplate> workflowNodeToTemplate, Map<Integer, List<WorkflowNodePosition>> workflowNodeIdToWorkflowNodePositions) {
        WorkflowNodeTemplate workflowNodeTemplate = workflowNodeToTemplate.get(workflowNode.getId());
        WorkflowNodeDTO nodeDTO = new WorkflowNodeDTO(workflowNode.getId(), workflowNodeTemplate.getName(), workflowNodeTemplate.isStartNode(), workflowNodeTemplate.getPosition(), workflowNodeTemplate.isWithMultiplePositions(), workflowDTO, new HashMap<Integer, WorkflowNodePositionDTO>());
        if (workflowNodeIdToWorkflowNodePositions.containsKey(workflowNode.getId())) {
            for (WorkflowNodePosition workflowNodePosition : workflowNodeIdToWorkflowNodePositions.get(workflowNode.getId())) {
                nodeDTO.getWorkflowNodePositions().put(workflowNodePosition.getId(), CdesDTOHelper.getWorkflowNodePositionDTO(workflowNodePosition, nodeDTO));
            }
        }
        nodeDTO.setRoleTypeId(workflowNode.getWorkflowNodeTemplate().getRoleType().getId());
        return nodeDTO;
    }

    public static WorkflowNodePositionDTO getWorkflowNodePositionDTO(WorkflowNodePosition pos, WorkflowNodeDTO workflowNodeDTO) {
        ProjectParticipationDTO projectParticipation = CdesDTOHelper.getProjectParticipationDTO(pos.getProjectParticipation());
        HashMap<Integer, PlanningNotificationMetaInformationDTO> metaInfoDTOs = new HashMap<Integer, PlanningNotificationMetaInformationDTO>();
        if (pos.getMetaInformations() != null) {
            for (MetaInformation metaInfo : pos.getMetaInformations().values()) {
                if (!(metaInfo instanceof PlanningNotificationMetaInformation)) continue;
                metaInfoDTOs.put(metaInfo.getId(), CdesDTOHelper.getPlanningNotificationMetaInformationDTO(metaInfo, null));
            }
        }
        return new WorkflowNodePositionDTO(pos.getId(), workflowNodeDTO, projectParticipation, metaInfoDTOs, pos.getDueDate() != null ? pos.getDueDate() : null, pos.getOptionalDueDate() != null ? pos.getOptionalDueDate() : null, pos.getDueDateRemark(), pos.isHasOwnerToken());
    }

    public static PlanningNotificationTemplateDTO getPlanningNotificationTemplateDTO(PlanningNotificationTemplate template) {
        HashMap<Integer, MetaTagDTO> tagDTOs = new HashMap<Integer, MetaTagDTO>();
        if (template.getMetaTags() != null) {
            for (MetaTag tag : template.getMetaTags().values()) {
                MetaTagDTO tagDTO = CdesDTOHelper.getPlanningNotificationMetaTagDTO(tag);
                tagDTOs.put(tagDTO.getId(), tagDTO);
            }
        }
        PlanningNotificationTemplateDTO templateDTO = new PlanningNotificationTemplateDTO(template.getId(), template.getName(), tagDTOs, template.getComment(), template.isGlobalTemplate());
        return templateDTO;
    }

    public static PlanningNotificationOrderDTO getPlanningNotificationOrderDTO(PlanningNotificationOrder order, PlanningNotificationDTO planningNotificationDTO, WorkflowDTO workflowDTO) {
        PlanningNotificationOrderDTO orderDTO = new PlanningNotificationOrderDTO(order.getId(), planningNotificationDTO, order.getText(), order.getDocumentPosition(), order.getAuthorizedInspector(), order.isStatutoryDuty(), order.getComment(), order.getCreated() != null ? order.getCreated() : null, order.getChanged() != null ? order.getChanged() : null, order.getDocumentOccurances(), workflowDTO, order.getStatus() != null ? order.getStatus().getName() : null);
        orderDTO.setSubjectAreaId(order.getSubjectAreaId() != null ? new Long(order.getSubjectAreaId().intValue()) : null);
        orderDTO.setStatutoryDutyId(order.getStatutoryDutyId() != null ? new Long(order.getStatutoryDutyId().intValue()) : null);
        orderDTO.setPersonInChargeId(order.getPersonInChargeId() != null ? new Long(order.getPersonInChargeId().intValue()) : null);
        orderDTO.setStatutoryDutyFrom(order.getStatutoryDutyFrom());
        orderDTO.setStatutoryDutyTo(order.getStatutoryDutyTo());
        orderDTO.setStatutoryDutyInterval(order.getStatutoryDutyInterval());
        orderDTO.setStatutoryDutyLeadTime(order.getStatutoryDutyLeadTime());
        orderDTO.setStatutoryDutyExpired(order.getStatutoryDutyExpired());
        orderDTO.setSerialNumber(order.getSerialNumber());
        orderDTO.setDocumentPage(order.getDocumentPage());
        orderDTO.setSource(order.getSource());
        orderDTO.setSubmitAuthority(order.getSubmitAuthority());
        orderDTO.setInvalidated(order.isInvalidated());
        return orderDTO;
    }

    public static PlanningNotificationMetaInformationDTO getPlanningNotificationMetaInformationDTO(MetaInformation metaInfo, PlanningNotificationDTO planningNotificationDTO) {
        PlanningNotificationMetaInformationDTO metaInfoDTO = null;
        if (metaInfo instanceof PlanningNotificationTextMetaInformation) {
            metaInfoDTO = new PlanningNotificationTextMetaInformationDTO(metaInfo.getId(), planningNotificationDTO, CdesDTOHelper.getPlanningNotificationMetaTagDTO(metaInfo.getMetaTag()), ((PlanningNotificationTextMetaInformation)metaInfo).getValue());
        } else if (metaInfo instanceof PlanningNotificationDateMetaInformation) {
            metaInfoDTO = new PlanningNotificationDateMetaInformationDTO(metaInfo.getId(), planningNotificationDTO, CdesDTOHelper.getPlanningNotificationMetaTagDTO(metaInfo.getMetaTag()), ((PlanningNotificationDateMetaInformation)metaInfo).getValue().getTime());
        }
        return metaInfoDTO;
    }

    public static MetaTagDTO getPlanningNotificationMetaTagDTO(MetaTag tag) {
        return new MetaTagDTO(tag.getId(), tag.getName(), tag.getTagFormat(), tag.getSharepointReferenceName(), tag.isMultiple(), tag.getPosition(), tag.getType());
    }

    public static List<ReviewCycleCommentOptionDTO> getReviewCycleCommentOptionDTOs(List<ReviewCycleCommentOption> commentOptions) {
        ArrayList<ReviewCycleCommentOptionDTO> options = new ArrayList<ReviewCycleCommentOptionDTO>();
        for (ReviewCycleCommentOption opt : commentOptions) {
            options.add(CdesDTOHelper.getReviewCycleCommentOptionDTO(opt));
        }
        return options;
    }

    public static ReviewCycleCommentOptionDTO getReviewCycleCommentOptionDTO(ReviewCycleCommentOption commentOption) {
        ReviewCycleCommentOptionDTO reviewCycleCommentOptionDTO = new ReviewCycleCommentOptionDTO(commentOption.getId(), TapestryI18nHelper.getLocalizedString(commentOption.getName()), commentOption.getValue(), commentOption.isFinishCell());
        return reviewCycleCommentOptionDTO;
    }

    public static PersonVariablesDTO getPersonVariablesDTO(PersonVariables pv, boolean isMemberInMultipleOrganisations) {
        PersonVariablesDTO pvDTO = new PersonVariablesDTO(pv.getId(), pv.getActiveOrganisationPersonId(), pv.getPerson().getId(), pv.getLastlogin(), pv.getActiveNetworkId(), pv.getActiveProjectId(), pv.getActiveSubProjectId(), pv.getSendMode(), pv.getScreenSize(), pv.getTabViewMode(), pv.getPreselectedTab(), pv.getUserLocale(), pv.getDisplayedDaysUntilDue(), pv.getDisplayedDaysOfDoneTasks(), isMemberInMultipleOrganisations, pv.getActivePNNetworkId(), pv.getActivePNProjectId());
        return pvDTO;
    }

    public static DocumentReferenceDTO getDocumentReferenceDTO(DocumentRef docRef) {
        DocumentReferenceDTO docRefDTO = new DocumentReferenceDTO(docRef.getId(), docRef.getReference(), docRef.getReferencedVersion() != null ? CdesDTOHelper.getDocumentVersionDTO(docRef.getReferencedVersion(), null, null, false) : null, docRef.getRealm(), docRef.getGz(), docRef.getComment(), docRef.getCreated(), docRef.getSinceDocumentVersion() != null ? docRef.getSinceDocumentVersion().getVersionPart() : null, docRef.getUntilDocumentVersion() != null ? docRef.getUntilDocumentVersion().getVersionPart() : null, docRef.getSinceDocumentVersion() != null ? docRef.getSinceDocumentVersion().getId() : null, docRef.getUntilDocumentVersion() != null ? docRef.getUntilDocumentVersion().getId() : null, docRef.getAttachmentFilename() != null ? docRef.getAttachmentFilename() : null);
        return docRefDTO;
    }

    public static ReviewCycleNodeResultDTO getReviewCycleNodeResultDTO(ReviewCycleNodeResult nodeResult, ReviewCycleNodeInstanceDTO nodeInstance, List<ReviewCyclePositionResultDTO> positionResults, List<ReviewCyclePositionResultDTO> commentsOnPreviousReviews, List<ReviewCycleNodePositionDTO> emptyPositions, DocumentVersionDTO documentVersionDTO, ReviewCycleResultOptionDTO reviewCycleResultOption) {
        ReviewCycleNodeResultDTO nodeResultDTO = new ReviewCycleNodeResultDTO(nodeResult.getId(), nodeResult.isFinished(), nodeResult.getDocumentArrivalDate(), nodeResult.getDocumentDepartureDate(), nodeInstance, positionResults, commentsOnPreviousReviews, emptyPositions, documentVersionDTO, reviewCycleResultOption);
        return nodeResultDTO;
    }

    public static DocumentDTO getDocumentDTO(Document doc, List<DocumentVersionDTO> documentVersionDTOs) {
        DocumentImpl docImpl = null;
        docImpl = doc instanceof ReleasedDocument ? ((ReleasedDocument)doc).getDocument() : (DocumentImpl)doc;
        String rawContent = doc.getContent();
        String content = TapestryI18nHelper.getLocalizedString(rawContent);
        DocumentDTO docDTO = new DocumentDTO(doc.getId(), doc.getNumber(), doc.getName(), content, doc.getScale(), doc.getComment(), doc.getStartDate(), doc.getEndDate(), doc.getDuration(), docImpl.getModified(), docImpl.isInvalidated(), docImpl.getAsBuiltReference() != null ? docImpl.getAsBuiltReference().getId() : null, CdesDTOHelper.getObjectPlannerDTO((ObjectPlannerImpl)doc.getObjectPlanner()), documentVersionDTOs);
        return docDTO;
    }

    public static DocumentVersionDTO getDocumentVersionDTO(DocumentVersion dv, List<ReviewCycleNodePositionDTO> positionDTOs, List<VersionStatementDTO> versionStatementDTOs, boolean asBuiltReference) {
        List<DocumentVersion> versions = dv.getDocument().getDocumentVersionsSortedByVersion();
        boolean comparable = false;
        if (!versions.isEmpty()) {
            int count = 0;
            int renderable = 0;
            DocumentVersion firstVersion = versions.get(0);
            if (firstVersion.getAsBuiltReference() != null && ConfigurationHelper.isFileTypeSupportedForPreview(firstVersion.getAsBuiltReference().getFileType())) {
                ++count;
                ++renderable;
            }
            for (DocumentVersion version : versions) {
                if (count == 0 && version.getId().equals(dv.getId())) break;
                if (ConfigurationHelper.isFileTypeSupportedForPreview(version.getFileType())) {
                    ++renderable;
                }
                if (renderable < 1) continue;
                comparable = true;
                break;
            }
        }
        boolean unchangedAsBuiltVersion = false;
        if (dv.getAsBuiltReference() != null && dv.getFileName().equals(dv.getAsBuiltReference().getFileName())) {
            unchangedAsBuiltVersion = true;
        }
        DocumentVersionDTO dvDTO = new DocumentVersionDTO(dv.getId(), dv.getVersionPartA(), dv.getVersionPartB(), dv.getVersionPartSeperator(), dv.getName(), dv.getAlternativeName(), dv.getComment(), dv.getUploaded(), dv.getRevisedDocumentVersion() != null ? dv.getRevisedDocumentVersion().getId() : null, dv.getReactivatedDocumentVersion() != null ? dv.getReactivatedDocumentVersion().getId() : null, dv.getAsBuiltReference() != null ? dv.getAsBuiltReference().getId() : null, dv.getDocument().getId(), dv.getStatus(), dv.getDocument().getDocumentList().getSubProject().isInvalidated(), ConfigurationHelper.isFileTypeSupportedForPreview(dv.getFileType()), CdesDTOHelper.getReviewCycleNodeInstanceDTO(dv.getActualReviewCycleNodeInstance(), positionDTOs), versionStatementDTOs, asBuiltReference, comparable, unchangedAsBuiltVersion);
        return dvDTO;
    }

    public static DocumentVersionDTO getDocumentVersionDTO(DocumentVersion dv, List<ReviewCycleNodePositionDTO> positionDTOs, List<VersionStatementDTO> versionStatementDTOs, List<ReviewCycleNodeResultDTO> nodeResultDTOs, boolean asBuiltReference) {
        DocumentVersionDTO dvDTO = CdesDTOHelper.getDocumentVersionDTO(dv, positionDTOs, versionStatementDTOs, asBuiltReference);
        dvDTO.setNodeResults(nodeResultDTOs);
        for (ReviewCycleNodeResultDTO reviewCycleNodeResultDTO : nodeResultDTOs) {
            reviewCycleNodeResultDTO.setDocumentVersion(dvDTO);
        }
        return dvDTO;
    }

    public static VersionStatementDTO getVersionStatementDTO(ReviewCycleEntryStatementResultImpl entryStatement) {
        ReviewCycleResultOptionDTO resultOptionDTO = null;
        if (entryStatement.getReviewCycleResultOption() != null) {
            resultOptionDTO = CdesDTOHelper.getReviewCycleResultOptionDTO(entryStatement.getReviewCycleResultOption(), false, false);
        }
        ProjectParticipant projectParticipant = entryStatement.getReviewCycleEntryResult().getProjectParticipant();
        SignerDTO signerDTO = CdesDTOHelper.getSignerDTO(projectParticipant);
        Date issued = entryStatement.getReviewCycleEntryResult().getResultDate();
        RealmDTO realmDTO = null;
        if (entryStatement.getRealm() != null) {
            realmDTO = CdesDTOHelper.getRealmDTO(entryStatement.getRealm());
        }
        VersionStatementDTO dto = new VersionStatementDTO(1, entryStatement.getId(), entryStatement.getComment(), null, issued, signerDTO, resultOptionDTO, realmDTO);
        return dto;
    }

    public static VersionStatementDTO getVersionStatementDTO(ReviewCycleCellConnectionStatementResultImpl cellConnectionStatement) {
        ReviewCycleResultOptionDTO resultOptionDTO = null;
        if (cellConnectionStatement.getReviewCycleResultOption() != null) {
            resultOptionDTO = CdesDTOHelper.getReviewCycleResultOptionDTO(cellConnectionStatement.getReviewCycleResultOption(), false, false);
        }
        RealmDTO realmDTO = null;
        if (cellConnectionStatement.getRealm() != null) {
            realmDTO = CdesDTOHelper.getRealmDTO(cellConnectionStatement.getRealm());
        }
        SignerDTO signerDTO = CdesDTOHelper.getSignerDTO(cellConnectionStatement.getReviewCycleCellConnectionResult().getProjectParticipant());
        Date issued = cellConnectionStatement.getReviewCycleCellConnectionResult().getResultDate();
        VersionStatementDTO dto = new VersionStatementDTO(0, cellConnectionStatement.getId(), cellConnectionStatement.getComment(), null, issued, signerDTO, resultOptionDTO, realmDTO);
        return dto;
    }

    public static ReviewCycleNodeInstanceDTO getReviewCycleNodeInstanceDTO(ReviewCycleNodeInstanceImpl nodeInstance, List<ReviewCycleNodePositionDTO> positionDTOs) {
        String reviewCycleNodeNameRaw = nodeInstance.getReviewCycleNode().getName();
        String reviewCycleNodeName = TapestryI18nHelper.getLocalizedString(reviewCycleNodeNameRaw);
        String reviewCycleCellNameRaw = nodeInstance.getReviewCycleNode().getReviewCycleCell().getName();
        String reviewCycleCellName = TapestryI18nHelper.getLocalizedString(reviewCycleCellNameRaw);
        ReviewCycleNodeInstanceDTO nodeInstanceDTO = new ReviewCycleNodeInstanceDTO(nodeInstance.getId(), nodeInstance.getReviewCycleNode().getId(), reviewCycleCellName, reviewCycleNodeName, nodeInstance.isFree(), nodeInstance.getDuration(), nodeInstance.getDurationMin(), nodeInstance.getReviewCycleNode().getPosition(), nodeInstance.getReviewCycleNode().getReviewType(), positionDTOs);
        return nodeInstanceDTO;
    }

    public static ReviewCycleNodeInstanceDTO getReviewCycleNodeInstanceDTO(ReviewCycleNodeInstanceRelease nodeInstance, List<ReviewCycleNodePositionDTO> positionDTOs) {
        String reviewCycleNodeNameRaw = nodeInstance.getReviewCycleNode().getName();
        String reviewCycleNodeName = TapestryI18nHelper.getLocalizedString(reviewCycleNodeNameRaw);
        String reviewCycleCellNameRaw = nodeInstance.getReviewCycleNode().getReviewCycleCell().getName();
        String reviewCycleCellName = TapestryI18nHelper.getLocalizedString(reviewCycleCellNameRaw);
        ReviewCycleNodeInstanceDTO nodeInstanceDTO = new ReviewCycleNodeInstanceDTO(nodeInstance.getId(), nodeInstance.getReviewCycleNode().getId(), reviewCycleCellName, reviewCycleNodeName, nodeInstance.isFree(), nodeInstance.getDuration(), nodeInstance.getDurationMin(), nodeInstance.getReviewCycleNode().getPosition(), nodeInstance.getReviewCycleNode().getReviewType(), positionDTOs);
        return nodeInstanceDTO;
    }

    public static ObjectPlannerDTO getObjectPlannerDTO(ObjectPlannerImpl op) {
        ProjectParticipantDTO planner = op.getPlanner() != null ? CdesDTOHelper.getProjectParticipantDTO(op.getPlanner().getMainParticipant(), true) : null;
        ObjectPlannerDTO opDTO = new ObjectPlannerDTO(op.getId(), op.getCode(), op.getArea(), op.getReviewCycleInstance() != null ? op.getReviewCycleInstance().getId() : null, op.getReviewCycleInstance() != null ? op.getReviewCycleInstance().getName() : null, planner, op.isInactive(), op.getChanged(), op.getAsBuiltReference() != null ? op.getAsBuiltReference().getId() : null, CdesDTOHelper.getObjectDTO((CDESObjectImpl)op.getObject()));
        return opDTO;
    }

    public static ObjectDTO getObjectDTO(CDESObjectImpl o) {
        ObjectDTO oDTO = new ObjectDTO(o.getId(), o.getCode(), o.getName(), "" + o.getStretchKmFrom(), "" + o.getStretchKmTo());
        return oDTO;
    }

    public static CDESContext getContext(OrganisationPerson op) {
        CDESContext context = new CDESContext(op.getId(), null, null, null, op.getPerson().getCommonName(), op.getOrganisation().getName(), null, null, null, null, null);
        return context;
    }

    public static CDESContext getContext(Network nw, OrganisationPerson op) {
        CDESContext context = new CDESContext(op.getId(), nw.getId(), null, null, op.getPerson().getCommonName(), op.getOrganisation().getName(), nw.getName(), null, null, null, null);
        return context;
    }

    public static CDESContext getContext(Project p, OrganisationPerson op) {
        CDESContext context = new CDESContext(op.getId(), p.getNetwork().getId(), p.getId(), null, op.getPerson().getCommonName(), op.getOrganisation().getName(), p.getNetwork().getName(), p.getCode(), p.getName(), null, null);
        return context;
    }

    public static CDESContext getContext(SubProject sp, OrganisationPerson op) {
        CDESContext context = new CDESContext(op.getId(), sp.getProject().getNetwork().getId(), sp.getProject().getId(), sp.getId(), op.getPerson().getCommonName(), op.getOrganisation().getName(), sp.getProject().getNetwork().getName(), sp.getProject().getCode(), sp.getProject().getName(), sp.getCode(), sp.getName());
        return context;
    }

    public static ReviewContextDTO getReviewContextDTO(ReviewableTask reviewableTask, DocumentVersion dv, SubProject sp, OrganisationPerson op, ReleasedObjectPlanner rop, ReviewHistoryDTO reviewHistory) {
        String reviewCycleNodeNameRaw = TapestryI18nHelper.getLocalizedString(dv.getActualReviewCycleNode().getName());
        String reviewCycleNodeName = TapestryI18nHelper.getLocalizedString(reviewCycleNodeNameRaw);
        ReviewContextDTO context = new ReviewContextDTO(CdesDTOHelper.getContext(sp, op));
        context.setTaskId(reviewableTask.getId());
        context.setSampleControlReview(reviewableTask.isSampleControlReview());
        context.setTaskInSignatureFolder(reviewableTask.isTaskInSignatureFolder());
        context.setDocumentVersionName(dv.getName());
        context.setDocumentContent(dv.getDocument().getContent());
        context.setDocumentNumber(dv.getDocument().getNumber());
        context.setDocumentVersionId(dv.getId());
        context.setDocumentId(dv.getDocument().getId());
        context.setObjectPlannerReleaseId(rop.getId());
        context.setKms(rop.getObject().getKms());
        context.setNodeName(reviewCycleNodeName);
        context.setNodeStatus("--knotenstatus--");
        context.setObjectName(rop.getObject().getCode() + " " + rop.getObject().getName());
        context.setObjectPlannerName(rop.getCode() + " " + rop.getArea());
        context.setPlannerName(rop.getPlanner().getMainParticipant().getOrganisationPerson().getPerson().getCommonName());
        context.setPlannerOrganisationName(rop.getPlanner().getOrganisation().getName());
        context.setReviewCycleInstanceName(rop.getReviewCycleInstance().getName());
        context.setScale(dv.getDocument().getScale());
        context.setReviewHistory(reviewHistory);
        return context;
    }

    public static RealmDTO getRealmDTO(Realm realm) {
        if (realm == null) {
            return null;
        }
        String realmName = TapestryI18nHelper.getLocalizedString(realm.getName());
        String realmDescription = TapestryI18nHelper.getLocalizedString(realm.getDescription());
        RealmDTO realmDTO = new RealmDTO(realm.getId(), realm.getCode(), realmName, realmDescription, realm.getLabelText(), realm.getRedliningColor(), realm.isSignatureOnLabel(), realm.getValidFromDate(), realm.getValidToDate());
        return realmDTO;
    }

    public static ReviewCycleResultOptionDTO getReviewCycleResultOptionDTO(ReviewCycleResultOption option, boolean isAuthorized, boolean isDisabled) {
        if (option == null) {
            return null;
        }
        String optionName = TapestryI18nHelper.getLocalizedString(option.getName());
        ReviewCycleResultOptionDTO optionDTO = new ReviewCycleResultOptionDTO(option.getId(), optionName, option.getDescription(), option.getValue(), option.isFinishCell(), option.isAuthorizationNeeded(), isAuthorized, isDisabled);
        return optionDTO;
    }

    public static ProjectParticipantDTO getProjectParticipantDTO(ProjectParticipant participant, boolean includeParticipationParticipantsOrgPersonIds) {
        if (participant == null) {
            return null;
        }
        ProjectParticipantDTO participantDTO = new ProjectParticipantDTO(participant.getId(), participant.getParticipation().getId(), participant.getOrganisationPerson().getId(), participant.getOrganisationPerson().getPerson().getGivenName(), participant.getOrganisationPerson().getPerson().getSurName(), participant.getOrganisationPerson().getOrganisation().getName(), participant.isMainParticipant());
        if (includeParticipationParticipantsOrgPersonIds && participant.getParticipation().getProjectParticipants().values() != null && !participant.getParticipation().getProjectParticipants().values().isEmpty()) {
            ArrayList<Integer> orgPersonIds = new ArrayList<Integer>();
            for (ProjectParticipant projectParticipant : participant.getParticipation().getProjectParticipants().values()) {
                orgPersonIds.add(projectParticipant.getOrganisationPerson().getId());
            }
            participantDTO.setParticipationParticipantsOrgPersonIds(orgPersonIds);
        }
        return participantDTO;
    }

    public static SignerDTO getSignerDTO(ProjectParticipant part) {
        ProjectParticipantDTO participantDTO = CdesDTOHelper.getProjectParticipantDTO(part, true);
        ProjectParticipantDTO mainParticipantDTO = null;
        if (!part.isMainParticipant() || part.isInactive()) {
            mainParticipantDTO = CdesDTOHelper.getProjectParticipantDTO(part.getParticipation().getMainParticipant(), false);
        }
        SignerDTO signerDTO = new SignerDTO(participantDTO, mainParticipantDTO);
        return signerDTO;
    }

    public static ReviewCyclePositionResultDTO getReviewCyclePositionResultDTO(ReviewCyclePositionResult result, boolean attachedPositionResult) {
        ArrayList attachments;
        ReviewCycleResultOptionDTO resultOptionDTO = null;
        if (result.getReviewCycleResultOption() != null) {
            resultOptionDTO = CdesDTOHelper.getReviewCycleResultOptionDTO(result.getReviewCycleResultOption(), result.isAuthorized(), false);
        }
        ReviewCycleCommentOptionDTO commentOptionDTO = null;
        if (result.getReviewCycleCommentOption() != null) {
            commentOptionDTO = CdesDTOHelper.getReviewCycleCommentOptionDTO(result.getReviewCycleCommentOption());
        }
        SignerDTO signerDTO = null;
        if (result.getProjectParticipant() != null) {
            signerDTO = CdesDTOHelper.getSignerDTO(result.getProjectParticipant());
        }
        SignerDTO overridingParticipantDTO = null;
        if (result.getOverridingProjectParticipant() != null) {
            overridingParticipantDTO = CdesDTOHelper.getSignerDTO(result.getOverridingProjectParticipant());
        }
        ReviewCyclePositionResultDTO commentReferenceDTO = null;
        if (result.getCommentReference() != null) {
            commentReferenceDTO = CdesDTOHelper.getReviewCyclePositionResultDTO(result.getCommentReference(), false);
        }
        ArrayList<AttachmentDTO> attachmentDTOs = new ArrayList<AttachmentDTO>();
        if (result.getAttachments() != null && (attachments = new ArrayList(result.getAttachments().values())) != null && !attachments.isEmpty()) {
            for (Attachment attachment : attachments) {
                attachmentDTOs.add(CdesDTOHelper.getAttachmentDTO(attachment));
            }
        }
        String reviewCycleNodeNameRaw = result.getReviewCycleNode().getName();
        String reviewCycleNodeName = TapestryI18nHelper.getLocalizedString(reviewCycleNodeNameRaw);
        ReviewCyclePositionResultDTO resultDTO = new ReviewCyclePositionResultDTO(result.getId(), result.getComment(), result.getDocumentVersion().getVersionPart(), reviewCycleNodeName, resultOptionDTO, commentOptionDTO, result.getResultDate(), signerDTO, CdesDTOHelper.getRealmDTO(result.getRealm()), commentReferenceDTO, result.isAuthorized(), overridingParticipantDTO, attachedPositionResult, attachmentDTOs);
        return resultDTO;
    }

    public static ReviewCycleNodePositionDTO getReviewCycleNodePositionDTO(ReviewCyclePositionRelease position, ReviewCyclePositionResult unsignedResult, List<ReviewCycleResultOption> resultOptions) {
        if (position == null) {
            return null;
        }
        ArrayList<ReviewCycleResultOptionDTO> resultOptionDTOs = new ArrayList<ReviewCycleResultOptionDTO>();
        if (resultOptions != null) {
            for (ReviewCycleResultOption option : resultOptions) {
                resultOptionDTOs.add(CdesDTOHelper.getReviewCycleResultOptionDTO(option, unsignedResult != null && unsignedResult.isAuthorized(), false));
            }
        }
        ReviewCyclePositionResultDTO unsignedResultDTO = null;
        boolean isAttachedPosition = position instanceof AttachedReviewCyclePositionImpl;
        if (unsignedResult != null) {
            CdesDTOHelper.getReviewCyclePositionResultDTO(unsignedResult, isAttachedPosition);
        }
        String reviewCycleNodeNameRaw = position.getReviewCycleNodeInstance().getReviewCycleNode().getName();
        String reviewCycleNodeName = TapestryI18nHelper.getLocalizedString(reviewCycleNodeNameRaw);
        ReviewCycleNodePositionDTO positionDTO = new ReviewCycleNodePositionDTO(position.getId(), CdesDTOHelper.getRealmDTO(position.getRealm()), CdesDTOHelper.getProjectParticipantDTO(position.getProjectParticipation().getMainParticipant(), false), unsignedResultDTO, resultOptionDTOs, isAttachedPosition, reviewCycleNodeName);
        return positionDTO;
    }

    public static AttachmentDTO getAttachmentDTO(Attachment attachment) {
        if (attachment == null) {
            return null;
        }
        return new AttachmentDTO(attachment.getId(), attachment.getDocumentVersionId(), attachment.getFileName(), attachment.getOriginalName(), attachment.isRedliningDelta(), attachment.getCreated(), null);
    }

    public static PlanningNotificationAttachmentDTO getPlanningNotificationAttachmentDTO(PlanningNotificationAttachment pna) {
        if (pna == null) {
            return null;
        }
        return new PlanningNotificationAttachmentDTO(pna.getId(), pna.getFileName(), pna.getFileType(), pna.getOriginalName());
    }

    public static WorkflowEntityStatusDTO getWorkflowEntitiyStatusDTO(WorkflowEntityStatus status) {
        if (status == null) {
            return null;
        }
        return new WorkflowEntityStatusDTO(status.getId(), status.getName(), status.getDescription(), status.isInitialStatus());
    }

    public static WorkflowNodePositionResultOptionDTO getWorkflowNodePositionResultOptionDTO(WorkflowNodePositionResultOption option, WorkflowNodeTemplateDTO nodeTemplateDTO) {
        if (option == null) {
            return null;
        }
        WorkflowNodePositionResultOptionDTO optionDTO = new WorkflowNodePositionResultOptionDTO(option.getId(), option.getTitle(), option.getDescription(), nodeTemplateDTO, new HashMap<Integer, WorkflowActionDTO>());
        if (option.getWorkflowActions() != null) {
            for (WorkflowAction action : option.getWorkflowActions().values()) {
                optionDTO.getWorkflowActions().put(action.getId(), CdesDTOHelper.getWorkflowActionDTO(action, nodeTemplateDTO));
            }
        }
        return optionDTO;
    }

    public static WorkflowActionDTO getWorkflowActionDTO(WorkflowAction workflowAction, WorkflowNodeTemplateDTO nodeTemplateDTO) {
        if (workflowAction == null) {
            return null;
        }
        WorkflowActionDTO actionDTO = null;
        if (workflowAction instanceof WorkflowActionEntityStatusChange) {
            WorkflowActionEntityStatusChange action = (WorkflowActionEntityStatusChange)workflowAction;
            actionDTO = new WorkflowActionEntityStatusChangeDTO(action.getId(), action.getName(), CdesDTOHelper.getWorkflowEntitiyStatusDTO(action.getTargetStatus()));
        } else if (workflowAction instanceof WorkflowActionNodeEmailNotification) {
            WorkflowActionNodeEmailNotification action = (WorkflowActionNodeEmailNotification)workflowAction;
            actionDTO = new WorkflowActionNodeEmailNotificationDTO(action.getId(), action.getName(), action.getEmailSubject(), action.getEmailBody(), nodeTemplateDTO);
        } else if (workflowAction instanceof WorkflowActionNodeTransition) {
            WorkflowActionNodeTransition action = (WorkflowActionNodeTransition)workflowAction;
            actionDTO = new WorkflowActionNodeTransitionDTO(action.getId(), action.getName(), nodeTemplateDTO);
        } else if (workflowAction instanceof WorkflowActionTokenEmailNotification) {
            WorkflowActionTokenEmailNotification action = (WorkflowActionTokenEmailNotification)workflowAction;
            actionDTO = new WorkflowActionTokenEmailNotificationDTO(action.getId(), action.getName(), action.getEmailSubject(), action.getEmailBody(), CdesDTOHelper.getWorkflowNodePositionResultOptionDTO(action.getWorkflowNodePositionResultOption(), nodeTemplateDTO), action.getRecipientType());
        } else if (workflowAction instanceof WorkflowActionTokenTransition) {
            WorkflowActionTokenTransition action = (WorkflowActionTokenTransition)workflowAction;
            actionDTO = new WorkflowActionTokenTransitionDTO(action.getId(), action.getName(), nodeTemplateDTO);
        }
        return actionDTO;
    }

    public static WorkflowActionPreconditionDTO getWorkflowActionPreconditionDTO(WorkflowActionPrecondition precondition, WorkflowNodeTemplateDTO nodeTemplateDTO) {
        if (precondition == null) {
            return null;
        }
        return new WorkflowActionPreconditionDTO(precondition.getId(), precondition.getType(), nodeTemplateDTO, CdesDTOHelper.getWorkflowEntitiyStatusDTO(precondition.getTargetWorkflowEntityStatus()));
    }

    public static WorkflowActionListenerDTO getWorkflowActionListenerDTO(WorkflowActionListener listener, WorkflowNodeTemplateDTO nodeTemplateDTO) {
        if (listener == null) {
            return null;
        }
        WorkflowActionListenerDTO listenerDTO = new WorkflowActionListenerDTO(listener.getId(), nodeTemplateDTO, new HashMap<Integer, WorkflowActionPreconditionDTO>(), new HashMap<Integer, WorkflowActionDTO>());
        if (listener.getWorkflowActionPreconditions() != null) {
            for (WorkflowActionPrecondition precondition : listener.getWorkflowActionPreconditions().values()) {
                listenerDTO.getWorkflowActionPreconditions().put(precondition.getId(), CdesDTOHelper.getWorkflowActionPreconditionDTO(precondition, nodeTemplateDTO));
            }
        }
        if (listener.getWorkflowActions() != null) {
            for (WorkflowAction action : listener.getWorkflowActions().values()) {
                listenerDTO.getWorkflowActions().put(action.getId(), CdesDTOHelper.getWorkflowActionDTO(action, nodeTemplateDTO));
            }
        }
        return listenerDTO;
    }

    public static WorkflowTemplateDTO getWorkflowTemplateDTO(WorkflowTemplate template) {
        if (template == null) {
            return null;
        }
        WorkflowTemplateDTO templateDTO = new WorkflowTemplateDTO(template.getId(), template.getName(), template.getComment(), new HashMap<Integer, WorkflowNodeTemplateDTO>());
        if (template.getWorkflowNodeTemplates() != null) {
            for (WorkflowNodeTemplate node : template.getWorkflowNodeTemplates().values()) {
                templateDTO.getWorkflowNodeTemplates().put(node.getId(), CdesDTOHelper.getWorkflowNodeTemplateDTO(node, templateDTO));
            }
        }
        return templateDTO;
    }

    public static WorkflowNodeTemplateDTO getWorkflowNodeTemplateDTO(WorkflowNodeTemplate template, WorkflowTemplateDTO workflowTemplateDTO) {
        if (template == null) {
            return null;
        }
        WorkflowNodeTemplateDTO templateDTO = new WorkflowNodeTemplateDTO(template.getId(), workflowTemplateDTO, new HashMap<Integer, WorkflowActionListenerDTO>(), template.getName(), template.isStartNode(), template.getPosition(), template.isWithMultiplePositions());
        return templateDTO;
    }

    public static WorkflowActivityDTO getWorkflowActivityDTO(WorkflowActivity workflowActivity) {
        if (workflowActivity == null) {
            return null;
        }
        if (workflowActivity instanceof WorkflowActivityHistoryEntry) {
            return CdesDTOHelper.getWorkflowActivityHistoryEntry((WorkflowActivityHistoryEntry)workflowActivity);
        }
        if (workflowActivity instanceof WorkflowActivityPositionResult) {
            return CdesDTOHelper.getWorkflowActivityPositionResultDTO((WorkflowActivityPositionResult)workflowActivity);
        }
        return null;
    }

    public static WorkflowActivityHistoryEntryDTO getWorkflowActivityHistoryEntry(WorkflowActivityHistoryEntry workflowActivity) {
        return new WorkflowActivityHistoryEntryDTO(workflowActivity.getId(), workflowActivity.getIssued(), workflowActivity.getDescription(), workflowActivity.getWorkflowNodeName(), workflowActivity.getTokenOwner(), workflowActivity.getTokenInitiator(), workflowActivity.isAdministrative());
    }

    public static WorkflowActivityPositionResultDTO getWorkflowActivityPositionResultDTO(WorkflowActivityPositionResult activityPositionResult) {
        ArrayList<MetaInformation> pnmis;
        ArrayList pnmis2;
        ArrayList pnas;
        ArrayList<PlanningNotificationAttachmentDTO> pnaDTO = new ArrayList<PlanningNotificationAttachmentDTO>();
        if (activityPositionResult.getPlanningNotificationAttachments() != null && (pnas = new ArrayList(activityPositionResult.getPlanningNotificationAttachments().values())) != null && !pnas.isEmpty()) {
            for (Object pna : pnas) {
                pnaDTO.add(CdesDTOHelper.getPlanningNotificationAttachmentDTO((PlanningNotificationAttachment)pna));
            }
        }
        ArrayList<PlanningNotificationMetaInformationDTO> pnmiDTO = new ArrayList<PlanningNotificationMetaInformationDTO>();
        if (activityPositionResult.getMetaInformations() != null && (pnmis2 = new ArrayList(activityPositionResult.getMetaInformations().values())) != null && !pnmis2.isEmpty()) {
            for (PlanningNotificationMetaInformation pnmi : pnmis2) {
                pnmiDTO.add(CdesDTOHelper.getPlanningNotificationMetaInformationDTO(pnmi, CdesDTOHelper.getPlanningNotificationDTO(pnmi.getPlanningNotification(), true)));
            }
        }
        HashMap<Integer, PlanningNotificationMetaInformationDTO> pnmiDTOMap = new HashMap<Integer, PlanningNotificationMetaInformationDTO>();
        if (activityPositionResult.getTokenInitiatorObj().getMetaInformations() != null && (pnmis = new ArrayList<MetaInformation>(activityPositionResult.getTokenInitiatorObj().getMetaInformations().values())) != null && !pnmis.isEmpty()) {
            for (PlanningNotificationMetaInformation planningNotificationMetaInformation : pnmis) {
                pnmiDTOMap.put(planningNotificationMetaInformation.getId(), CdesDTOHelper.getPlanningNotificationMetaInformationDTO(planningNotificationMetaInformation, CdesDTOHelper.getPlanningNotificationDTO(planningNotificationMetaInformation.getPlanningNotification(), true)));
            }
        }
        WorkflowNodePositionDTO nodePositionDTO = new WorkflowNodePositionDTO(activityPositionResult.getTokenInitiatorObj().getId(), CdesDTOHelper.getWorkflowNodeDTO(activityPositionResult.getTokenInitiatorObj().getWorkflowNode(), CdesDTOHelper.getWorkflowDTO(activityPositionResult.getTokenInitiatorObj().getWorkflowNode().getWorkflow())), CdesDTOHelper.getProjectParticipationDTO(activityPositionResult.getTokenInitiatorObj().getProjectParticipation()), pnmiDTOMap, activityPositionResult.getTokenInitiatorObj().getDueDate() != null ? activityPositionResult.getTokenInitiatorObj().getDueDate() : null, activityPositionResult.getTokenInitiatorObj().getOptionalDueDate() != null ? activityPositionResult.getTokenInitiatorObj().getOptionalDueDate() : null, activityPositionResult.getTokenInitiatorObj().getDueDateRemark(), activityPositionResult.getTokenInitiatorObj().isHasOwnerToken());
        return new WorkflowActivityPositionResultDTO(activityPositionResult.getId(), activityPositionResult.getIssued(), activityPositionResult.getDescription(), activityPositionResult.getWorkflowNodeName(), activityPositionResult.getTokenOwner(), activityPositionResult.getTokenInitiator(), nodePositionDTO, null, activityPositionResult.getReviewer(), activityPositionResult.getResult(), activityPositionResult.getEntityStatus(), activityPositionResult.getComment(), activityPositionResult.getAttachmentFilePath(), pnaDTO, pnmiDTO);
    }

    public static PlanningNotificationTaskDTO getPlanningNotificationTaskDTO(PlanningNotificationOrder order, WorkflowToken token) {
        HashMap<Integer, ProjectDTO> projects = new HashMap<Integer, ProjectDTO>();
        for (Project project : order.getPlanningNotification().getAssociatedProjects().values()) {
            projects.put(project.getId(), CdesDTOHelper.getProjectDTO(project, null));
        }
        ArrayList<PlanningNotificationMetaInformation> tagsMetaInformations = new ArrayList<PlanningNotificationMetaInformation>();
        Collection<PlanningNotificationMetaInformation> metaInfos = order.getPlanningNotification().getPlanningNotificationMetaInformations().values();
        for (PlanningNotificationMetaInformation planningNotificationMetaInformation : metaInfos) {
            if (!planningNotificationMetaInformation.getMetaTag().getName().equals("Baulos")) continue;
            tagsMetaInformations.add(planningNotificationMetaInformation);
        }
        String planningNotificationString = "<b>" + order.getPlanningNotification().getTitle() + ":</b>";
        if (!tagsMetaInformations.isEmpty()) {
            for (PlanningNotificationMetaInformation tagsMetaInformation : tagsMetaInformations) {
                if (tagsMetaInformation instanceof PlanningNotificationDateMetaInformation) {
                    planningNotificationString = planningNotificationString + "<br>" + DateHelper.formatDefaultDate(((PlanningNotificationDateMetaInformation)tagsMetaInformation).getValue().getTime());
                    continue;
                }
                if (!(tagsMetaInformation instanceof PlanningNotificationTextMetaInformation)) continue;
                planningNotificationString = planningNotificationString + "<br>" + ((PlanningNotificationTextMetaInformation)tagsMetaInformation).getValue();
            }
        }
        String string = token.getOwner().getWorkflowNode().getWorkflowNodeTemplate().getName();
        String constructionPhase = "";
        Integer constructionPhaseId = null;
        Collection<MetaInformation> initiatorsMetaInfos = token.getInitiator().getMetaInformations().values();
        if (metaInfos.size() > 0) {
            for (MetaInformation initiatorsMeta : initiatorsMetaInfos) {
                if (!initiatorsMeta.getMetaTag().getName().equals("Baulos")) continue;
                if (initiatorsMeta instanceof PlanningNotificationDateMetaInformation) {
                    constructionPhase = DateHelper.formatDefaultDate(((PlanningNotificationDateMetaInformation)initiatorsMeta).getValue().getTime());
                    constructionPhaseId = ((PlanningNotificationDateMetaInformation)initiatorsMeta).getId();
                    continue;
                }
                if (!(initiatorsMeta instanceof PlanningNotificationTextMetaInformation)) continue;
                constructionPhase = ((PlanningNotificationTextMetaInformation)initiatorsMeta).getValue();
                constructionPhaseId = ((PlanningNotificationTextMetaInformation)initiatorsMeta).getId();
            }
        }
        String reviewer = token.getOwner().getProjectParticipation().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + " (" + token.getOwner().getProjectParticipation().getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName() + ")";
        PlanningNotificationTaskDTO taskDTO = new PlanningNotificationTaskDTO(string, reviewer, token.getOwner().getProjectParticipation().getMainParticipant().getId(), token.getOwner().getId(), token.getInitiator().getId(), constructionPhase, constructionPhaseId, order.getText(), planningNotificationString, order.getDocumentPosition(), order.getAuthorizedInspector(), order.isStatutoryDuty(), order.getComment(), order.getStatus() != null ? order.getStatus().getName() : null, token.getInitiator().getDueDate() != null ? token.getInitiator().getDueDate() : null, token.getInitiator().getOptionalDueDate() != null ? token.getInitiator().getOptionalDueDate() : null, token.getInitiator().getDueDateRemark(), order.getPlanningNotification().getNetwork().getName(), "", projects, token.getId(), token.getOwner().getWorkflowNode().getId(), order.getId(), token.getOwner().getWorkflowNode().getWorkflow().getId());
        taskDTO.setStatutoryDutyId(order.getStatutoryDutyId() != null ? new Long(order.getStatutoryDutyId().intValue()) : null);
        taskDTO.setSerialNumber(order.getSerialNumber());
        return taskDTO;
    }

    public static ArrayList<MessageDTO> getMessagesDTO(List<InfoMessage> infoMessages) {
        ArrayList<MessageDTO> list = new ArrayList<MessageDTO>();
        for (InfoMessage i : infoMessages) {
            list.add(new MessageDTO(i.getId(), i.getRecordDate(), i.getStartDate(), i.getEndDate(), TapestryI18nHelper.getLocalizedString(i.getHeadline()), TapestryI18nHelper.getLocalizedString(i.getContent())));
        }
        return list;
    }
}

