/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.date;

import at.cdes.bo.data.localisation.Country;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.date.HolidayCalculator;
import at.cdes.bo.date.HolidayCalculator_at;
import at.cdes.bo.date.HolidayCalculator_de;
import at.cdes.bo.date.HolidayCalculator_it;
import at.cdes.bo.date.TimeSpan;
import java.io.Serializable;
import java.util.Collection;

public class HolidayCalculatorFactory
implements Serializable {
    private static final long serialVersionUID = 1L;

    public HolidayCalculator getInstance(Country c) {
        return this.getInstance(c.getCode2());
    }

    public HolidayCalculator getInstance(String code) {
        if (code != null && code.equalsIgnoreCase("at")) {
            return new HolidayCalculator_at();
        }
        if (code != null && code.equalsIgnoreCase("de")) {
            return new HolidayCalculator_de();
        }
        if (code != null && code.equalsIgnoreCase("it")) {
            return new HolidayCalculator_it();
        }
        return null;
    }

    public HolidayCalculator getInstance(String code, Collection<TimeSpan> holidays) {
        if (code != null && code.equalsIgnoreCase("at")) {
            return new HolidayCalculator_at(holidays);
        }
        if (code != null && code.equalsIgnoreCase("de")) {
            return new HolidayCalculator_de(holidays);
        }
        if (code != null && code.equalsIgnoreCase("it")) {
            return new HolidayCalculator_it(holidays);
        }
        return null;
    }

    public HolidayCalculator getInstance(Project project) {
        if ("at".equalsIgnoreCase(project.getLocalisation().getCountry().getCode2())) {
            return new HolidayCalculator_at(project.getHolidays().values());
        }
        if ("de".equalsIgnoreCase(project.getLocalisation().getCountry().getCode2())) {
            return new HolidayCalculator_de(project.getHolidays().values());
        }
        if ("it".equalsIgnoreCase(project.getLocalisation().getCountry().getCode2())) {
            return new HolidayCalculator_it(project.getHolidays().values());
        }
        return null;
    }
}

