/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.cycle.listener;

import at.cdes.bo.cycle.EvaluationException;
import at.cdes.bo.cycle.ReviewCycleActionListenerEvaluator;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeActionListenerType;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeInstanceListener;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.order.plott.PlottOrderTemplate;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.service.ReviewCycleNodeActionListener;
import at.cdes.bo.service.ReviewCycleNodeActionListenerProperty;
import at.cdes.db.dao.ReviewCycleNodeResultDAO;
import at.cdes.service.OrderOperations;
import at.cdes.service.ProjectOperations;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class NodePlottOrderListener
implements ReviewCycleNodeActionListener,
Serializable {
    static Logger logger = Logger.getLogger(NodePlottOrderListener.class);
    private static final long serialVersionUID = 1L;
    private final String prettyName = "PlottOrderListener";
    private OrderOperations orderOperations;
    private ProjectOperations projectOperations;
    private ReviewCycleActionListenerEvaluator evaluator;
    private ReviewCycleNodeResultDAO reviewCycleNodeResultDAO;

    @Override
    public void listen(ReviewCycleNodeActionListenerProperty property) {
        ReviewCycleNodeInstanceListener listener = property.getListener();
        DocumentVersion version = property.getVersion();
        ReleasedObjectPlanner releasedObjectPlanner = property.getReleasedObjectPlanner();
        PlottOrderTemplate orderTemplate = (PlottOrderTemplate)listener.getReference();
        if (orderTemplate == null || orderTemplate.isInvalidated()) {
            return;
        }
        if (!this.evaluate(version, listener.getReviewCycleNodeListener())) {
            return;
        }
        if (orderTemplate.getPlotterId() == null) {
            logger.error((Object)("inconsistency (missing plotterId) for orderTemplate [" + orderTemplate.getName() + "]"));
            return;
        }
        ProjectParticipation plotter = this.projectOperations.getProjectParticipation(orderTemplate.getPlotterId());
        this.orderOperations.generatePlottOrderFromTemplate(orderTemplate, releasedObjectPlanner.getPlanner().getMainParticipant(), plotter, version);
    }

    private boolean evaluate(DocumentVersion version, ReviewCycleNodeActionListenerType type) {
        if (type.getRule() == null) {
            return true;
        }
        ReviewCycleNodeResult res = this.reviewCycleNodeResultDAO.get(version.getActualReviewCycleNode(), version);
        try {
            return this.evaluator.evaluateCondition(res, type.getRule());
        }
        catch (EvaluationException e) {
            return false;
        }
    }

    @Override
    public String getName() {
        return "PlottOrderListener";
    }

    public void setRuleEvaluator(ReviewCycleActionListenerEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void setReviewCycleNodeResultDAO(ReviewCycleNodeResultDAO reviewCycleNodeResultDAO) {
        this.reviewCycleNodeResultDAO = reviewCycleNodeResultDAO;
    }

    public void setOrderOperations(OrderOperations orderOperations) {
        this.orderOperations = orderOperations;
    }

    public void setProjectOperations(ProjectOperations projectOperations) {
        this.projectOperations = projectOperations;
    }
}

