/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.schema;

import at.cdes.db.SchemaUpdateSnippet;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUpdate_0_231
implements SchemaUpdateSnippet {
    private static final Logger log = LoggerFactory.getLogger(SchemaUpdate_0_231.class);

    @Override
    public String getTargetVersion() {
        return "0.231";
    }

    @Override
    public String getUpdateComment() {
        return "Add review_cycle_id to label_text_field, make some changes concerning labels";
    }

    @Override
    public void performUpdate(ISchemaEngine schemaEngine) throws SQLException {
        String databaseProductName = schemaEngine.getConnection().getMetaData().getDatabaseProductName();
        log.info("databaseProductName = [" + databaseProductName + "]");
        Boolean isSQLServer = databaseProductName.contains("SQL Server");
        schemaEngine.changeColumn(schemaEngine.fetchTableInfo("label", null), "review_cycle_id", new ColumnInfo("review_cycle_id", 4, Integer.valueOf(20), null, true, null));
        schemaEngine.changeColumn(schemaEngine.fetchTableInfo("label_content", null), "orig_filename", new ColumnInfo("orig_filename", -1, null, null, true, null));
        schemaEngine.changeColumn(schemaEngine.fetchTableInfo("label_content", null), "filename", new ColumnInfo("filename", -1, null, null, true, null));
        schemaEngine.changeColumn(schemaEngine.fetchTableInfo("label_signature_text_field", null), "review_cycle_node_id", new ColumnInfo("review_cycle_node_id", 4, Integer.valueOf(20), null, true, null));
        schemaEngine.addColumn(schemaEngine.fetchTableInfo("label_text_field", null), new ColumnInfo("review_cycle_id", 4, Integer.valueOf(20), null, true, null));
        schemaEngine.addForeignKey(schemaEngine.fetchTableInfo("label_text_field", null), new ForeignKeyInfo("label_text_field_ibfk_1", "review_cycle_id", "review_cycle", "id"));
        String certificateSQL = "SELECT label.review_cycle_id, label_text_field.id FROM     ((label JOIN label_content      ON label_content.label_id = label.id) JOIN label_text_field   ON label_text_field.label_id = label_content.id) ";
        PreparedStatement certificateSelect = schemaEngine.getConnection().prepareStatement(certificateSQL);
        String updateSQL = "UPDATE label_text_field SET review_cycle_id = ? WHERE id = ?";
        PreparedStatement updateStatement = schemaEngine.getConnection().prepareStatement(updateSQL);
        ResultSet certificateResultSet = certificateSelect.executeQuery();
        while (certificateResultSet.next()) {
            int currIndex = 1;
            Long review_cycle_id = JDBCHelper.getLong((ResultSet)certificateResultSet, (int)currIndex++);
            Long label_text_field_id = JDBCHelper.getLong((ResultSet)certificateResultSet, (int)currIndex++);
            if (review_cycle_id == null) continue;
            currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)updateStatement, (int)currIndex++, (Number)review_cycle_id);
            JDBCHelper.setLong((PreparedStatement)updateStatement, (int)currIndex++, (Number)label_text_field_id);
            if (log.isInfoEnabled()) {
                log.info("Populating label_text_field.review_cycle_id: For label_text_field = [" + label_text_field_id + "], setting review_cycle_id = [" + review_cycle_id + "]");
            }
            updateStatement.addBatch();
        }
        updateStatement.executeBatch();
        String asBuiltReferenceSQL = "SELECT document_version.id, document_version.name, document_version.as_built_reference, document_version.label_id, label_content_ref.id label_content_ref_id, project.code, project.name, sub_project.code, sub_project.name, network.name FROM document_version JOIN document on (document_version.document_id = document.id) JOIN document_list on (document.document_list_id = document_list.id) JOIN sub_project on (document_list.sub_project_id = sub_project.id) JOIN project on (sub_project.project_id = project.id) JOIN network on (project.network_id = network.id) JOIN label_content on (document_version.label_id = label_content.id) LEFT JOIN document_version as document_version_ref on (document_version.as_built_reference = document_version_ref.id)  LEFT JOIN label_content as label_content_ref on (document_version_ref.label_id = label_content_ref.id) WHERE (label_content.is_as_built_unchanged_destination = 1 or label_content_ref.is_as_built_unchanged_destination = 1) and document_version.as_built_reference IS NOT NULL;";
        PreparedStatement asBuiltReferenceSelect = schemaEngine.getConnection().prepareStatement(asBuiltReferenceSQL);
        String asBuiltReferenceUpdateSQL = "UPDATE document_version SET label_id = ? WHERE id = ?";
        PreparedStatement asBuiltReferenceUpdateStatement = schemaEngine.getConnection().prepareStatement(asBuiltReferenceUpdateSQL);
        ResultSet asBuiltReferenceResultSet = asBuiltReferenceSelect.executeQuery();
        int rowCount = 0;
        if (!isSQLServer.booleanValue()) {
            asBuiltReferenceResultSet.last();
            rowCount = asBuiltReferenceResultSet.getRow();
            asBuiltReferenceResultSet.beforeFirst();
        }
        if (log.isInfoEnabled()) {
            log.info("Going to UPDATE document_version with " + (isSQLServer == false ? Integer.valueOf(rowCount) : "?") + " found datasets changing document_version's label_id to as_built_reference's label_id");
        }
        while (asBuiltReferenceResultSet.next()) {
            int currIndex = 1;
            Long document_version_id = JDBCHelper.getLong((ResultSet)asBuiltReferenceResultSet, (int)currIndex++);
            String document_version_name = asBuiltReferenceResultSet.getString(currIndex++);
            Long document_version_as_built_reference = JDBCHelper.getLong((ResultSet)asBuiltReferenceResultSet, (int)currIndex++);
            Long document_version_label_id = JDBCHelper.getLong((ResultSet)asBuiltReferenceResultSet, (int)currIndex++);
            Long label_content_ref_id = JDBCHelper.getLong((ResultSet)asBuiltReferenceResultSet, (int)currIndex++);
            String project_code = asBuiltReferenceResultSet.getString(currIndex++);
            String project_name = asBuiltReferenceResultSet.getString(currIndex++);
            String sub_project_code = asBuiltReferenceResultSet.getString(currIndex++);
            String sub_project_name = asBuiltReferenceResultSet.getString(currIndex++);
            String network_name = asBuiltReferenceResultSet.getString(currIndex++);
            JDBCHelper.setLong((PreparedStatement)asBuiltReferenceUpdateStatement, (int)1, (Number)label_content_ref_id);
            JDBCHelper.setLong((PreparedStatement)asBuiltReferenceUpdateStatement, (int)2, (Number)document_version_id);
            if (log.isInfoEnabled()) {
                log.info("UPDATE document_version for document_version_id = [" + document_version_id + "], document_version_name = [" + document_version_name + "], referencing = [" + document_version_as_built_reference + "], changing from label_id = [" + document_version_label_id + "] to label_content_ref_id = [" + label_content_ref_id + ", project = [" + project_code + " " + project_name + "], sub_project = [" + sub_project_code + " " + sub_project_name + "], network = [" + network_name + "]");
            }
            asBuiltReferenceUpdateStatement.addBatch();
        }
        asBuiltReferenceUpdateStatement.executeBatch();
    }
}

