/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.cycle;

import at.cdes.bo.data.HashedObject;
import at.cdes.bo.data.cycle.ReviewCycle;
import at.cdes.bo.data.cycle.ReviewCycleInstance;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellCodeNameComparator;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnection;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstance;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstancePositionComparator;
import at.cdes.bo.data.label.Label;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.sec.DigestCalculatorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReviewCycleInstanceRelease
implements ReviewCycleInstance,
HashedObject {
    static final long serialVersionUID = 1L;
    private Integer id;
    private int duration;
    private int durationMin;
    private int preDuration;
    private String name;
    private ReviewCycle reviewCycle;
    private Map reviewCycleCellInstances;
    private int changed;
    private SubProject subProject;
    private ReviewCycleInstance reviewCycleInstance;
    private String digest;
    private DigestCalculatorType digestCalculatorType;
    private ReleasedObjectList objectList;
    private Label label;
    private String description;

    public ReviewCycleInstanceRelease() {
    }

    public ReviewCycleInstanceRelease(ReviewCycleInstance cyc) {
        this.name = cyc.getName();
        this.reviewCycle = cyc.getReviewCycle();
        this.reviewCycleCellInstances = new HashMap();
        this.changed = cyc.getChanged();
        this.subProject = cyc.getSubProject();
        this.reviewCycleInstance = cyc;
        this.duration = cyc.getDuration();
        this.durationMin = cyc.getDurationMin();
        this.preDuration = cyc.getPreDuration();
        this.label = cyc.getLabel();
        this.description = cyc.getDescription();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(int changed) {
        this.changed = changed;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public ReviewCycle getReviewCycle() {
        return this.reviewCycle;
    }

    @Override
    public void setReviewCycle(ReviewCycle reviewCycle) {
        this.reviewCycle = reviewCycle;
    }

    @Override
    public Map getReviewCycleCellInstances() {
        return this.reviewCycleCellInstances;
    }

    @Override
    public void setReviewCycleCellInstances(Map reviewCycleCellInstances) {
        this.reviewCycleCellInstances = reviewCycleCellInstances;
    }

    @Override
    public SubProject getSubProject() {
        return this.subProject;
    }

    @Override
    public void setSubProject(SubProject subProject) {
        this.subProject = subProject;
    }

    public ReviewCycleInstance getReviewCycleInstance() {
        return this.reviewCycleInstance;
    }

    public void setReviewCycleInstance(ReviewCycleInstance reviewCycleInstance) {
        this.reviewCycleInstance = reviewCycleInstance;
    }

    @Override
    public void setDigest(String hash) {
        this.digest = hash;
    }

    @Override
    public DigestCalculatorType getDigestCalculatorType() {
        return this.digestCalculatorType;
    }

    @Override
    public void setDigestCalculatorType(DigestCalculatorType digestCalculatorType) {
        this.digestCalculatorType = digestCalculatorType;
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    public ReleasedObjectList getObjectList() {
        return this.objectList;
    }

    public void setObjectList(ReleasedObjectList objectList) {
        this.objectList = objectList;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public int getDurationMin() {
        return this.durationMin;
    }

    @Override
    public void setDurationMin(int durationMin) {
        this.durationMin = durationMin;
    }

    @Override
    public int getPreDuration() {
        return this.preDuration;
    }

    @Override
    public void setPreDuration(int preDuration) {
        this.preDuration = preDuration;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(Label label) {
        this.label = label;
    }

    public List getReviewCycleCellInstancesSortedByPosition() {
        ArrayList ret = new ArrayList();
        ret.addAll(this.getReviewCycleCellInstances().values());
        Collections.sort(ret, new ReviewCycleCellInstancePositionComparator());
        return ret;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Collection<ReviewCycleCellInstance> getReviewCycleCellInstancesSortedByCodeAndName() {
        ArrayList<ReviewCycleCellInstance> ret = new ArrayList<ReviewCycleCellInstance>();
        ret.addAll(this.getReviewCycleCellInstances().values());
        Collections.sort(ret, new ReviewCycleCellCodeNameComparator());
        return ret;
    }

    @Override
    public ReviewCycleCellInstance getReviewCycleCellInstanceByCellId(Integer id1) {
        if (this.getReviewCycleCellInstances() == null) {
            return null;
        }
        Collection insts = this.getReviewCycleCellInstances().values();
        for (ReviewCycleCellInstance inst : insts) {
            if (!inst.getReviewCycleCell().getId().equals(id1)) continue;
            return inst;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!ReviewCycleInstanceRelease.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ReviewCycleInstanceRelease other = (ReviewCycleInstanceRelease)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @Override
    public List<ReviewCycleCellInstance> getReviewCycleCellInstancesDefault() {
        ArrayList<ReviewCycleCellInstance> ret = new ArrayList<ReviewCycleCellInstance>();
        Iterator cellInstances = this.getReviewCycleCellInstancesSortedByPosition().iterator();
        ReviewCycleCellInstance nextCellInst = null;
        if (cellInstances != null && cellInstances.hasNext()) {
            nextCellInst = (ReviewCycleCellInstance)cellInstances.next();
        }
        block0: while (nextCellInst != null) {
            ret.add(nextCellInst);
            Iterator leavingConnections = nextCellInst.getReviewCycleCell().getLeavingConnections() != null ? nextCellInst.getReviewCycleCell().getLeavingConnections().values().iterator() : null;
            nextCellInst = null;
            while (leavingConnections != null && leavingConnections.hasNext()) {
                ReviewCycleCellConnection connection = (ReviewCycleCellConnection)leavingConnections.next();
                if (!connection.isDefaultConnection()) continue;
                nextCellInst = this.getReviewCycleCellInstanceByCellId(connection.getDestinationCell().getId());
                continue block0;
            }
        }
        return ret;
    }
}

