/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.action.impl;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstance;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.object.ObjectPlanner;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.role.ActionRule;
import at.cdes.bo.data.role.CDESAction;
import at.cdes.bo.data.role.Context;
import at.cdes.bo.data.task.DocumentVersionTask;
import at.cdes.bo.role.RoleMap;
import at.cdes.controller.ActionValidator;
import at.cdes.controller.action.impl.GlobalValidator;
import at.cdes.controller.action.impl.NetworkValidator;
import at.cdes.controller.action.impl.ObjectPlannerValidator;
import at.cdes.controller.action.impl.ProjectValidator;
import at.cdes.controller.action.impl.ReviewCycleNodeInstanceValidator;
import at.cdes.controller.action.impl.TaskValidator;
import at.cdes.db.dao.ActionDAO;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.ObjectPlannerDAO;
import at.cdes.db.dao.OrganisationPersonDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.db.dao.ReviewCycleNodeInstanceDAO;
import at.cdes.db.dao.SubProjectDAO;
import at.cdes.db.dao.TaskDAO;
import at.cdes.oldGwtDto.ActionCheckDTO;
import at.cdes.oldGwtDto.RoleMapEntryGWT;
import at.cdes.oldGwtDto.RoleMapGWT;
import at.cdes.util.ImplContextHelper;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionValidatorImpl
implements ActionValidator {
    private GlobalValidator globalValidator;
    private NetworkValidator networkValidator;
    private ProjectValidator projectValidator;
    private ObjectPlannerValidator objectPlannerValidator;
    private ReviewCycleNodeInstanceValidator reviewCycleNodeInstanceValidator;
    private TaskValidator taskValidator;
    private ActionDAO actionDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO;
    private SubProjectDAO subProjectDAO;
    private ProjectDAO projectDAO;
    private NetworkDAO networkDAO;
    private TaskDAO taskDAO;
    private boolean globalReadOnly;
    private static Logger log = LoggerFactory.getLogger((String)ActionValidatorImpl.class.getName());

    @Override
    public boolean checkAction(String actionName, Object destination) {
        RoleMap roleMap = ImplContextHelper.getRoleMap();
        if (destination == null) {
            if (ImplContextHelper.getDestinationFreeActions() != null && ImplContextHelper.getDestinationFreeActions().contains(actionName)) {
                return true;
            }
            boolean result = this.validate(actionName, destination, ImplContextHelper.getContextOrganisationPersonId(), roleMap);
            if (result) {
                ImplContextHelper.getDestinationFreeActions().add(actionName);
            }
            return result;
        }
        if (destination instanceof Collection) {
            return this.validate(actionName, destination, ImplContextHelper.getContextOrganisationPersonId(), roleMap);
        }
        Class destinationClass = null;
        if (destination instanceof ObjectPlannerImpl) {
            destinationClass = ObjectPlannerImpl.class;
        } else if (destination instanceof ReleasedObjectPlanner) {
            destinationClass = ReleasedObjectPlanner.class;
        } else if (destination instanceof ReviewCycleNodeInstanceImpl) {
            destinationClass = ReviewCycleNodeInstanceImpl.class;
        } else if (destination instanceof ReviewCycleNodeInstanceRelease) {
            destinationClass = ReviewCycleNodeInstanceRelease.class;
        } else if (destination instanceof SubProject) {
            destinationClass = SubProject.class;
        } else if (destination instanceof Project) {
            destinationClass = Project.class;
        } else if (destination instanceof Network) {
            destinationClass = Network.class;
        } else if (destination instanceof DocumentVersionTask) {
            destinationClass = DocumentVersionTask.class;
        }
        Integer destinationId = ((CdesDataObject)destination).getId();
        if (destinationClass != null) {
            return this.validateId(actionName, destinationId, destinationClass, ImplContextHelper.getContextOrganisationPersonId(), roleMap);
        }
        return this.validate(actionName, destination, ImplContextHelper.getContextOrganisationPersonId(), roleMap);
    }

    @Override
    public boolean checkActionNamesId(List actionNames, Integer destinationId, Class destinationClass, Integer organisationPersonId) {
        RoleMap roleMap = ImplContextHelper.getRoleMap();
        return this.validateActionNamesId(actionNames, destinationId, destinationClass, organisationPersonId, roleMap);
    }

    @Override
    public boolean checkActionNamesIdMultipleDestinations(List<String> actionNames, List<Integer> destinationIds, Class destinationClass, Integer organisationPersonId) {
        RoleMap roleMap = ImplContextHelper.getRoleMap();
        return this.validateActionNamesIdMultipleDestinations(actionNames, destinationIds, destinationClass, organisationPersonId, roleMap);
    }

    @Override
    public boolean checkActionId(String actionName, Integer destinationId, Class destinationClass, Integer organisationPersonId) {
        RoleMap roleMap = ImplContextHelper.getRoleMap();
        if (destinationId == null && destinationClass == null) {
            if (ImplContextHelper.getDestinationFreeActions().contains(actionName)) {
                return true;
            }
            boolean result = this.validateId(actionName, destinationId, destinationClass, organisationPersonId, roleMap);
            if (result) {
                ImplContextHelper.getDestinationFreeActions().add(actionName);
            }
            return result;
        }
        boolean result = this.validateId(actionName, destinationId, destinationClass, organisationPersonId, roleMap);
        return result;
    }

    private boolean checkProjectAccess(ActionRule rule, Project project) {
        if (project.getAccess() == 2) {
            return true;
        }
        if (project.getAccess() == 1 || project.getAccess() == 0) {
            return rule.getAction().getReadOnly() >= 1;
        }
        return false;
    }

    @Override
    public boolean validate(String actionName, Object destination, Integer organisationPersonId, RoleMap roleMap) {
        OrganisationPerson organisationPerson = null;
        if (organisationPersonId != null) {
            organisationPerson = this.organisationPersonDAO.get(organisationPersonId);
        }
        if (destination instanceof Collection) {
            Collection destinationCollection = (Collection)destination;
            for (Object object : destinationCollection) {
                if (!this.validatePart(actionName, object, organisationPerson, roleMap)) continue;
                return true;
            }
            return false;
        }
        return this.validatePart(actionName, destination, organisationPerson, roleMap);
    }

    @Override
    public boolean validateActionNamesId(List actionNames, Integer destinationId, Class destinationClass, Integer organisationPersonId, RoleMap roleMap) {
        CdesDataObject destinationObject = null;
        if (destinationClass == ObjectPlannerImpl.class) {
            destinationObject = this.objectPlannerDAO.getObjectPlanner(destinationId);
        } else if (destinationClass == ReleasedObjectPlanner.class) {
            destinationObject = this.objectPlannerDAO.getReleasedObjectPlanner(destinationId);
        } else if (destinationClass == ReviewCycleNodeInstanceImpl.class) {
            destinationObject = this.reviewCycleNodeInstanceDAO.get(destinationId);
        } else if (destinationClass == ReviewCycleNodeInstanceRelease.class) {
            destinationObject = this.reviewCycleNodeInstanceDAO.getReleased(destinationId);
        } else if (destinationClass == SubProject.class) {
            destinationObject = this.subProjectDAO.get(destinationId);
        } else if (destinationClass == Project.class) {
            destinationObject = this.projectDAO.get(destinationId);
        } else if (destinationClass == Network.class) {
            destinationObject = this.networkDAO.get(destinationId);
        } else if (destinationClass == DocumentVersionTask.class) {
            destinationObject = this.taskDAO.get(destinationId);
        }
        OrganisationPerson orgPerson = null;
        if (organisationPersonId != null) {
            orgPerson = this.organisationPersonDAO.get(organisationPersonId);
        }
        for (int i = 0; i < actionNames.size(); ++i) {
            if (!this.validatePart((String)actionNames.get(i), destinationObject, orgPerson, roleMap)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean validateActionNamesIdMultipleDestinations(List<String> actionNames, List<Integer> destinationIds, Class destinationClass, Integer organisationPersonId, RoleMap roleMap) {
        for (Integer destId : destinationIds) {
            if (!this.validateActionNamesId(actionNames, destId, destinationClass, organisationPersonId, roleMap)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean validateId(String actionName, Integer destinationId, Class destinationClass, Integer organisationPersonId, RoleMap roleMap) {
        CdesDataObject destinationObject = null;
        if (destinationId != null) {
            if (destinationClass == ObjectPlannerImpl.class) {
                destinationObject = this.objectPlannerDAO.getObjectPlanner(destinationId);
            } else if (destinationClass == ReleasedObjectPlanner.class) {
                destinationObject = this.objectPlannerDAO.getReleasedObjectPlanner(destinationId);
            } else if (destinationClass == ReviewCycleNodeInstanceImpl.class) {
                destinationObject = this.reviewCycleNodeInstanceDAO.get(destinationId);
            } else if (destinationClass == ReviewCycleNodeInstanceRelease.class) {
                destinationObject = this.reviewCycleNodeInstanceDAO.getReleased(destinationId);
            } else if (destinationClass == SubProject.class) {
                destinationObject = this.subProjectDAO.get(destinationId);
            } else if (destinationClass == Project.class) {
                destinationObject = this.projectDAO.get(destinationId);
            } else if (destinationClass == Network.class) {
                destinationObject = this.networkDAO.get(destinationId);
            } else if (destinationClass == DocumentVersionTask.class) {
                destinationObject = this.taskDAO.get(destinationId);
            }
        }
        OrganisationPerson orgPerson = null;
        if (organisationPersonId != null) {
            orgPerson = this.organisationPersonDAO.get(organisationPersonId);
        }
        return this.validatePart(actionName, destinationObject, orgPerson, roleMap);
    }

    @Override
    public boolean validatePart(String actionName, Object destination, OrganisationPerson organisationPerson, RoleMap roleMap) {
        List<ActionRule> rules;
        if (log.isDebugEnabled()) {
            log.debug("Called validatePart: actionName = [" + actionName + "], globalReadOnly = " + this.globalReadOnly);
        }
        Network network = null;
        Project project = null;
        ReviewCycleNodeInstance reviewCycleNodeInstance = null;
        DocumentVersionTask task = null;
        ObjectPlanner objectPlanner = null;
        Context destinationContext = null;
        CDESAction action = this.actionDAO.get(actionName);
        if (action == null) {
            log.warn("!!! No action found for actionName '" + actionName + "' !!!");
            return false;
        }
        if (destination instanceof ObjectPlanner) {
            objectPlanner = (ObjectPlanner)destination;
            project = objectPlanner.getObject().getObjectList().getSubProject().getProject();
            network = project.getNetwork();
            if (log.isDebugEnabled()) {
                log.debug("==> destination = O " + (destination == null ? "null" : objectPlanner.getId()) + "; P = [" + (project == null ? "null" : project.getId()) + "]; N = [" + (network == null ? "null" : network.getId()) + "]");
            }
        } else if (destination instanceof ReviewCycleNodeInstance) {
            reviewCycleNodeInstance = (ReviewCycleNodeInstance)destination;
            project = reviewCycleNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance().getSubProject().getProject();
            network = project.getNetwork();
            if (log.isDebugEnabled()) {
                log.debug("==> destination = R " + (destination == null ? "null" : reviewCycleNodeInstance.getId()) + "; P = [" + (project == null ? "null" : project.getId()) + "]; N = [" + (network == null ? "null" : network.getId()) + "]");
            }
        } else if (destination instanceof SubProject) {
            project = ((SubProject)destination).getProject();
            network = project.getNetwork();
            if (log.isDebugEnabled()) {
                log.debug("==> destination = S " + (destination == null ? "null" : ((SubProject)destination).getId()) + "; P = [" + (project == null ? "null" : project.getId()) + "]; N = [" + (network == null ? "null" : network.getId()) + "]");
            }
        } else if (destination instanceof Project) {
            project = (Project)destination;
            network = project.getNetwork();
            if (log.isDebugEnabled()) {
                log.debug("==> destination = P " + (destination == null ? "null" : project.getId()) + "; P = [" + (project == null ? "null" : project.getId()) + "]; N = [" + (network == null ? "null" : network.getId()) + "]");
            }
        } else if (destination instanceof Network) {
            network = (Network)destination;
            if (log.isDebugEnabled()) {
                log.debug("==> destination = N " + (destination == null ? "null" : network.getId()) + "; N = [" + (network == null ? "null" : network.getId()) + "]");
            }
        } else if (destination instanceof DocumentVersionTask) {
            task = (DocumentVersionTask)destination;
            project = task.getDocumentVersion().getDocument().getDocumentList().getSubProject().getProject();
            network = project.getNetwork();
            if (log.isDebugEnabled()) {
                log.debug("==> destination = T " + (destination == null ? "null" : task.getId()) + "; P = [" + (project == null ? "null" : project.getId()) + "]; N = [" + (network == null ? "null" : network.getId()) + "]");
            }
        } else if (destination == null) {
            network = null;
        } else if (log.isDebugEnabled()) {
            log.debug("Network wasn't found from destination.");
        }
        if ((rules = this.actionDAO.getActionRules(action.getId(), network != null ? network.getId() : null)) == null || rules.isEmpty()) {
            rules = this.actionDAO.getActionRules(action.getId(), null);
        }
        if (roleMap == null) {
            return false;
        }
        if (rules == null || rules.isEmpty()) {
            return false;
        }
        ActionRule rule = rules.get(0);
        if (this.globalReadOnly) {
            return rule.getAction().getReadOnly() >= 1;
        }
        destinationContext = rule.getDestinationContext();
        boolean result = false;
        if (log.isDebugEnabled()) {
            log.debug(".... destContext = " + destinationContext.getCode());
        }
        if (destinationContext.getCode() == 1) {
            result = this.globalValidator.validateAction(roleMap.getGlobalRole(), rule);
            if (log.isDebugEnabled()) {
                log.debug("RESULT: globalValidator answered " + result + " for global role " + roleMap.getGlobalRole().getId());
            }
            return result;
        }
        if (destinationContext.getCode() == 2) {
            List roles;
            if (network != null && organisationPerson != null && (result = this.networkValidator.validateAction(roles = roleMap.getNetworkRoles(network.getId(), organisationPerson.getId()), rule)) && log.isDebugEnabled()) {
                log.debug("RESULT: networkValidator answered " + result + " for one of the network roles");
            }
            if (!result && organisationPerson != null) {
                result = this.globalValidator.validateAction(roleMap.getGlobalRole(), rule);
                if (result && log.isDebugEnabled()) {
                    log.debug("RESULT: globalValidator answered YES for global role " + roleMap.getGlobalRole().getId());
                }
                if (rule.isCheckMember()) {
                    boolean bl = result = result && this.networkValidator.validateMember(network, organisationPerson);
                    if (log.isDebugEnabled()) {
                        log.debug("RESULT: CheckMember true and networkValidator said " + result + " for network " + network.getId());
                    }
                }
            }
        } else if (destinationContext.getCode() == 3) {
            if (project == null || project.getId() == null || organisationPerson == null) {
                log.warn("Project was null when checking project context action rule " + actionName);
                return false;
            }
            List roles = roleMap.getProjectRoles(project.getId(), organisationPerson.getId());
            if (!this.checkProjectAccess(rule, project)) {
                if (log.isDebugEnabled()) {
                    log.debug("RESULT: NO, since no project access");
                }
                return false;
            }
            result = this.projectValidator.validateAction(roles, rule);
            if (result && log.isDebugEnabled()) {
                log.debug("RESULT: projectValidator answered YES");
            }
            if (rule.isCheckMember()) {
                boolean bl = result = result && this.projectValidator.validateMember(project, organisationPerson);
                if (log.isDebugEnabled()) {
                    log.debug("CheckMember is true, and result " + result + "according to projectValidator.validateMember");
                }
            }
            if (!result) {
                roles = roleMap.getNetworkRoles(network.getId(), organisationPerson.getId());
                result = this.networkValidator.validateAction(roles, rule);
                if (result && log.isDebugEnabled()) {
                    log.debug("RESULT: networkValidator said YES");
                }
                if (rule.isCheckMember()) {
                    boolean bl = result = result && this.projectValidator.validateMember(project, organisationPerson);
                }
                if (!result) {
                    result = this.globalValidator.validateAction(roleMap.getGlobalRole(), rule);
                    if (result && log.isDebugEnabled()) {
                        log.debug("RESULT: globalValidator said YES");
                    }
                    if (rule.isCheckMember()) {
                        result = result && this.projectValidator.validateMember(project, organisationPerson);
                    }
                }
            }
        } else if (destinationContext.getCode() == 4) {
            if (objectPlanner == null || objectPlanner.getId() == null || organisationPerson == null) {
                log.warn("ObjectPlanner was null when checking project context action rule " + actionName);
                return false;
            }
            if (!this.checkProjectAccess(rule, project)) {
                if (log.isDebugEnabled()) {
                    log.debug("RESULT: NO, since no project access");
                }
                return false;
            }
            List roles = roleMap.getProjectRoles(project.getId(), organisationPerson.getId());
            result = this.projectValidator.validateAction(roles, rule);
            if (result && log.isDebugEnabled()) {
                log.debug("RESULT: projectValidator answered YES");
            }
            if (rule.isCheckMember()) {
                boolean bl = result = result && this.objectPlannerValidator.validateMember(objectPlanner, organisationPerson, rule, network);
                if (log.isDebugEnabled()) {
                    log.debug(".... checkMember is true, and objectPlannerValidator answered " + result + " for objectPlanner [" + objectPlanner.getId() + "]");
                }
            }
            if (!result) {
                roles = roleMap.getNetworkRoles(network.getId(), organisationPerson.getId());
                result = this.networkValidator.validateAction(roles, rule);
                if (result && log.isDebugEnabled()) {
                    log.debug("RESULT: networkValidator answered YES");
                }
                if (rule.isCheckMember()) {
                    boolean bl = result = result && this.objectPlannerValidator.validateMember(objectPlanner, organisationPerson, rule, network);
                }
                if (!result) {
                    result = this.globalValidator.validateAction(roleMap.getGlobalRole(), rule);
                    if (result && log.isDebugEnabled()) {
                        log.debug("RESULT: globalValidator answered YES for global role " + roleMap.getGlobalRole().getId());
                    }
                    if (rule.isCheckMember()) {
                        result = result && this.objectPlannerValidator.validateMember(objectPlanner, organisationPerson, rule, network);
                    }
                }
            }
        } else if (destinationContext.getCode() == 5) {
            if (reviewCycleNodeInstance == null || reviewCycleNodeInstance.getId() == null || organisationPerson == null) {
                log.warn("ReviewCycleNodeInstance was null when checking project context action rule " + actionName);
                return false;
            }
            if (!this.checkProjectAccess(rule, project)) {
                return false;
            }
            List roles = roleMap.getProjectRoles(project.getId(), organisationPerson.getId());
            result = this.reviewCycleNodeInstanceValidator.validateAction(roles, rule);
            if (rule.isCheckMember()) {
                boolean bl = result = result && this.reviewCycleNodeInstanceValidator.validateMember(reviewCycleNodeInstance, organisationPerson);
            }
            if (!result) {
                roles = roleMap.getNetworkRoles(network.getId(), organisationPerson.getId());
                result = this.networkValidator.validateAction(roles, rule);
                if (rule.isCheckMember()) {
                    boolean bl = result = result && this.reviewCycleNodeInstanceValidator.validateMember(reviewCycleNodeInstance, organisationPerson);
                }
                if (!result) {
                    result = this.globalValidator.validateAction(roleMap.getGlobalRole(), rule);
                    if (rule.isCheckMember()) {
                        result = result && this.reviewCycleNodeInstanceValidator.validateMember(reviewCycleNodeInstance, organisationPerson);
                    }
                }
            }
        } else if (destinationContext.getCode() == 6) {
            if (task == null || task.getId() == null || organisationPerson == null) {
                log.warn("Task was null when checking task context action rule " + actionName);
                return false;
            }
            if (!this.checkProjectAccess(rule, project)) {
                return false;
            }
            List roles = roleMap.getProjectRoles(project.getId(), organisationPerson.getId());
            result = this.taskValidator.validateAction(roles, rule);
            if (rule.isCheckMember()) {
                boolean bl = result = result && this.taskValidator.validateMember(task, organisationPerson, rule);
            }
            if (!result) {
                roles = roleMap.getNetworkRoles(network.getId(), organisationPerson.getId());
                result = this.networkValidator.validateAction(roles, rule);
                if (rule.isCheckMember()) {
                    boolean bl = result = result && this.taskValidator.validateMember(task, organisationPerson, rule);
                }
                if (!result) {
                    result = this.globalValidator.validateAction(roleMap.getGlobalRole(), rule);
                    if (rule.isCheckMember()) {
                        result = result && this.taskValidator.validateMember(task, organisationPerson, rule);
                    }
                }
            }
        } else {
            log.warn("ActionRule for Context is not yet implemented");
        }
        if (log.isDebugEnabled()) {
            log.debug("FINAL RESULT: " + result);
        }
        return result;
    }

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setGlobalValidator(GlobalValidator globalValidator) {
        this.globalValidator = globalValidator;
    }

    public void setNetworkValidator(NetworkValidator networkValidator) {
        this.networkValidator = networkValidator;
    }

    public void setProjectValidator(ProjectValidator projectValidator) {
        this.projectValidator = projectValidator;
    }

    public void setObjectPlannerValidator(ObjectPlannerValidator objectPlannerValidator) {
        this.objectPlannerValidator = objectPlannerValidator;
    }

    public void setReviewCycleNodeInstanceValidator(ReviewCycleNodeInstanceValidator reviewCycleInstanceValidator) {
        this.reviewCycleNodeInstanceValidator = reviewCycleInstanceValidator;
    }

    public void setTaskValidator(TaskValidator taskValidator) {
        this.taskValidator = taskValidator;
    }

    public void setGlobalReadOnly(boolean globalReadOnly) {
        this.globalReadOnly = globalReadOnly;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setReviewCycleNodeInstanceDAO(ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO) {
        this.reviewCycleNodeInstanceDAO = reviewCycleNodeInstanceDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setTaskDAO(TaskDAO taskDAO) {
        this.taskDAO = taskDAO;
    }

    @Override
    public List<ActionCheckDTO> validateActionChecks(RoleMapGWT roleMapGWT, List<ActionCheckDTO> actionChecks) {
        RoleMap roleMap = this.createRoleMap(roleMapGWT);
        Calendar validUntil = Calendar.getInstance();
        validUntil.add(12, 30);
        for (ActionCheckDTO actionCheck : actionChecks) {
            Class destinationClass = null;
            switch (actionCheck.getDestination()) {
                case DocumentVersionTask: {
                    destinationClass = DocumentVersionTask.class;
                    break;
                }
                case Network: {
                    destinationClass = Network.class;
                    break;
                }
                case ObjectPlannerImpl: {
                    destinationClass = ObjectPlannerImpl.class;
                    break;
                }
                case Project: {
                    destinationClass = Project.class;
                    break;
                }
                case ReleasedObjectPlanner: {
                    destinationClass = ReleasedObjectPlanner.class;
                    break;
                }
                case ReviewCycleNodeInstanceImpl: {
                    destinationClass = ReviewCycleNodeInstanceImpl.class;
                    break;
                }
                case ReviewCycleNodeInstanceRelease: {
                    destinationClass = ReviewCycleNodeInstanceImpl.class;
                    break;
                }
                case SubProject: {
                    destinationClass = SubProject.class;
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                Integer destinationId = actionCheck.getDestinationId();
                String destinationIdString = destinationId != null ? String.valueOf(destinationId) : "null";
                String destinationClassString = destinationClass != null ? destinationClass.getName() : "null";
                log.debug("validating action " + actionCheck.getActionName() + ", destId=" + destinationIdString + ", destClass=" + destinationClassString + ", destination=" + (Object)((Object)actionCheck.getDestination()) + ", opId=" + actionCheck.getOrganisationPersonId());
            }
            boolean isValid = this.validateId(actionCheck.getActionName(), actionCheck.getDestinationId(), destinationClass, actionCheck.getOrganisationPersonId(), roleMap);
            actionCheck.setValid(isValid);
            if (!isValid) continue;
            actionCheck.setValidToDate(validUntil.getTime());
        }
        return actionChecks;
    }

    private RoleMap createRoleMap(RoleMapGWT roleMapGWT) {
        RoleMap roleMap = new RoleMap();
        List<RoleMapEntryGWT> allRoleMapEntryGWTs = roleMapGWT.getAllRoles();
        for (RoleMapEntryGWT roleMapEntryGWT : allRoleMapEntryGWTs) {
            roleMap.add(roleMapEntryGWT.getId(), roleMapEntryGWT.getNetworkId(), roleMapEntryGWT.getProjectId(), roleMapEntryGWT.getProjectParticipantId(), roleMapEntryGWT.getOrganisationPersonId());
        }
        return roleMap;
    }
}

