/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.role.ActionRule;
import at.cdes.bo.data.role.ActionRuleDefault;
import at.cdes.bo.data.role.Role;
import at.cdes.bo.data.role.RoleDefault;
import at.cdes.bo.data.role.RoleType;
import at.cdes.db.dao.ActionDAO;
import at.cdes.db.dao.ContextDAO;
import at.cdes.db.dao.RoleDAO;
import at.cdes.db.dao.RoleDefaultDAO;
import at.cdes.service.RoleOperations;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class RoleOperationsImpl
implements RoleOperations {
    static Logger logger = Logger.getLogger(RoleOperationsImpl.class);
    private RoleDAO roleDAO;
    private ActionDAO actionDAO;
    private ContextDAO contextDAO;
    private RoleDefaultDAO roleDefaultDAO;

    @Override
    public List getAll(Integer networkId) {
        return this.roleDAO.getAll(networkId);
    }

    @Override
    public Role get(Integer roleId) {
        return this.roleDAO.get(roleId);
    }

    @Override
    public Role insertRole(Role role) {
        return this.roleDAO.save(role);
    }

    @Override
    public Role updateRole(Role erole) {
        Role role = this.get(erole.getId());
        role.setName(erole.getName());
        role.setProjectFlag(erole.getProjectFlag());
        role.setDescription(erole.getDescription());
        role.setType(erole.getType());
        role.setContextDefaultRole(erole.isContextDefaultRole());
        return this.roleDAO.update(role);
    }

    @Override
    public void deleteRole(Role role) {
        if (role.getActionRules() != null) {
            role.getActionRules().clear();
        }
        this.roleDAO.delete(role);
    }

    public void setRoleDAO(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public void setActionDAO(ActionDAO acatDAO) {
        this.actionDAO = acatDAO;
    }

    @Override
    public Role updateRoleActionRules(Integer roleId, List all) {
        Role role = this.roleDAO.get(roleId);
        if (role.getActionRules() == null) {
            role.setActionRules(new HashMap());
        }
        for (int i = 0; i < all.size(); ++i) {
            ActionRule rule = (ActionRule)all.get(i);
            if (rule.getRoles() == null) {
                rule.setRoles(new HashMap());
            }
            if (!rule.hasRole(role) && rule.isSelected()) {
                role.getActionRules().put(rule.getId(), rule);
            } else if (rule.hasRole(role) && !rule.isSelected()) {
                role.getActionRules().remove(rule.getId());
            }
            rule = this.actionDAO.merge(rule);
        }
        return this.roleDAO.update(role);
    }

    @Override
    public List getContexts() {
        return this.contextDAO.getAll();
    }

    public void setContextDAO(ContextDAO contextDAO) {
        this.contextDAO = contextDAO;
    }

    @Override
    public List getRoleTypes() {
        return this.roleDAO.getAllTypes();
    }

    @Override
    public List getReviewRoleTypes() {
        return this.roleDAO.getAllTypesExclusiveType(10);
    }

    @Override
    public RoleType getRoleType(Integer typeId) {
        return this.roleDAO.getType(typeId);
    }

    public void setRoleDefaultDAO(RoleDefaultDAO roleDefaultDAO) {
        this.roleDefaultDAO = roleDefaultDAO;
    }

    @Override
    public List getDefaultRoles(Integer networkTypeId) {
        return this.roleDefaultDAO.getAll(networkTypeId);
    }

    @Override
    public RoleDefault getRoleDefault(Integer roleId) {
        return this.roleDefaultDAO.get(roleId);
    }

    @Override
    public RoleDefault updateRoleDefault(RoleDefault erole) {
        return this.roleDefaultDAO.update(erole);
    }

    @Override
    public RoleDefault insertRoleDefault(RoleDefault roleDefault) {
        return this.roleDefaultDAO.save(roleDefault);
    }

    @Override
    public void deleteRoleDefault(RoleDefault roleDefault) {
        this.roleDefaultDAO.delete(roleDefault);
    }

    @Override
    public RoleDefault updateRoleDefaultActionRules(Integer roleDefaultId, List all) {
        RoleDefault roleDefault = this.roleDefaultDAO.get(roleDefaultId);
        if (roleDefault.getActionRuleDefaults() == null) {
            roleDefault.setActionRuleDefaults(new HashMap());
        }
        for (int i = 0; i < all.size(); ++i) {
            ActionRuleDefault rule = (ActionRuleDefault)all.get(i);
            if (rule.getDefaultRoles() == null) {
                rule.setDefaultRoles(new HashMap());
            }
            if (!rule.hasDefaultRole(roleDefault) && rule.isSelected()) {
                roleDefault.getActionRuleDefaults().put(rule.getId(), rule);
            } else if (rule.hasDefaultRole(roleDefault) && !rule.isSelected()) {
                roleDefault.getActionRuleDefaults().remove(rule.getId());
            }
            this.actionDAO.merge(rule);
        }
        return this.roleDefaultDAO.update(roleDefault);
    }

    @Override
    public boolean checkRoleDefaultDeletable(Integer roleDefaultId) {
        List roles = this.roleDAO.getAllRoles();
        for (Role role : roles) {
            if (role.getRoleDefault() == null || !role.getRoleDefault().getId().equals(roleDefaultId)) continue;
            return false;
        }
        return true;
    }
}

