/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.document;

import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.document.DocumentTranslator;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.xnap.commons.i18n.I18n;

public class CompactReviewStatus
implements Serializable {
    private static final long serialVersionUID = -3244048200378578358L;
    private final Integer documentId;
    private final Integer documentVersionId;
    private final String name;
    private final String content;
    private final String objectPlannerText;
    private final String statusString;
    private final Date uploadDate;
    private final Date effectiveEndDate;
    private final Date startDate;
    private final Date endDate;
    private final int status;
    private final int documentNumber;
    private int filterStatus;

    public CompactReviewStatus(DocumentVersion dv, ReleasedObjectPlanner rop, Date effectiveEndDate, I18n i18n) {
        this.documentId = dv.getDocument().getId();
        this.documentVersionId = dv.getId();
        this.status = dv.getStatus();
        this.name = dv.getName();
        this.objectPlannerText = rop.getCode() + rop.getArea() + rop.getReviewCycleInstance().getName();
        this.statusString = DocumentTranslator.getStatusName(i18n, this.status);
        this.effectiveEndDate = effectiveEndDate;
        this.startDate = dv.getDocument().getStartDate();
        this.endDate = dv.getDocument().getEndDate();
        this.documentNumber = dv.getDocument().getNumber();
        this.uploadDate = dv.getUploaded();
        this.content = dv.getDocument().getContent();
        this.filterStatus = 0;
    }

    public CompactReviewStatus(Map result, I18n i18n) {
        this.documentId = (Integer)result.get("documentId");
        this.documentVersionId = (Integer)result.get("dvId");
        this.filterStatus = 0;
        this.status = result.get("dvStatus") == null ? 11 : (Integer)result.get("dvStatus");
        this.name = result.get("dvName") == null ? (String)result.get("documentName") : (String)result.get("dvName");
        String opText = "";
        opText = result.get("opRelCode") == null ? opText + (String)result.get("opCode") : opText + (String)result.get("opRelCode");
        opText = result.get("opRelName") == null ? opText + (String)result.get("opName") : opText + (String)result.get("opRelName");
        opText = result.get("rciRelName") == null ? opText + (String)result.get("rciName") : opText + (String)result.get("rciRelName");
        this.objectPlannerText = opText;
        String statusStr = DocumentTranslator.getStatusName(i18n, this.status);
        if (this.status != 2 && this.status != 11 && this.status != 6) {
            statusStr = statusStr + "_" + result.get("activeCellName") + "_" + result.get("activeNodeName");
        }
        this.effectiveEndDate = this.status == 2 ? (Date)result.get("nodeResultArrivalDate") : null;
        this.statusString = statusStr;
        this.content = (String)result.get("documentContent");
        this.startDate = (Date)result.get("documentStartDate");
        this.endDate = (Date)result.get("documentEndDate");
        this.uploadDate = (Date)result.get("uploadDate");
        this.documentNumber = (Integer)result.get("documentNumber");
    }

    public Integer getDocumentId() {
        return this.documentId;
    }

    public Integer getDocumentVersionId() {
        return this.documentVersionId;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public String getObjectPlannerText() {
        return this.objectPlannerText;
    }

    public Date getUploadDate() {
        return this.uploadDate;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getStatus() {
        return this.status;
    }

    public Date getEffectiveEndDate() {
        return this.effectiveEndDate;
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public void setFilterStatus(int filterStatus) {
        this.filterStatus = filterStatus;
    }

    public int getFilterStatus() {
        return this.filterStatus;
    }
}

