/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.file;

import at.cdes.bo.data.file.CDESDataFile;
import at.cdes.bo.file.FileFinder;
import at.cdes.bo.service.ArchiveServiceJobInfo;
import at.cdes.bo.service.JobInfo;
import at.cdes.controller.actionhandler.ArchiveServiceInvocationInformationImpl;
import at.cdes.service.OrderOperations;
import at.cdes.service.ServiceInvocationInformation;
import at.cdes.service.exception.FileHandleException;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

public class OutdatedFileRemover
extends Thread {
    private OrderOperations orderOperations;
    private FileFinder fileFinder;
    private ServiceInvocationInformation invocationInformation;
    private int executionHour;
    private int archiveJobExpirationDays;
    private int originalDocumentExpirationDays;
    static Logger logger = Logger.getLogger(OutdatedFileRemover.class);

    public void requestStop() {
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            logger.info((Object)("OutdatedFileRemover has been started. Scheduled Start=[" + (this.executionHour < 10 ? "0" + this.executionHour + ":00" : this.executionHour + ":00") + "] - archiveJobExpirationDays=[" + this.archiveJobExpirationDays + "] originalDocumentExpirationDays=[" + this.originalDocumentExpirationDays + "]"));
            if (this.originalDocumentExpirationDays == 0 && this.archiveJobExpirationDays == 0) {
                logger.info((Object)"OutdatedFileRemover seems disabled and will exit now.");
                return;
            }
            Calendar originalDocumentsDeadline = Calendar.getInstance();
            originalDocumentsDeadline.add(5, -this.originalDocumentExpirationDays);
            Calendar jobInfoDeadline = Calendar.getInstance();
            jobInfoDeadline.add(5, -this.archiveJobExpirationDays);
            while (!this.isInterrupted()) {
                if (Calendar.getInstance().get(11) == this.executionHour) {
                    logger.info((Object)"OutdatedFileRemover starts to scan for outdated files.");
                    if (this.originalDocumentExpirationDays > 0) {
                        try {
                            this.orderOperations.invalidateOriginalDocumentOrdersCompletedBeforeDate(originalDocumentsDeadline.getTime());
                        }
                        catch (FileHandleException e) {
                            logger.error((Object)"Could not delete uploaded file of OriginalDocumentOrder!", (Throwable)e);
                        }
                        catch (IOException e) {
                            logger.error((Object)"Could not delete uploaded file of OriginalDocumentOrder!", (Throwable)e);
                        }
                    }
                    if (this.archiveJobExpirationDays > 0) {
                        List<JobInfo> jobInfos = this.invocationInformation.getJobInfos();
                        for (JobInfo jobInfo : jobInfos) {
                            if (!(jobInfo instanceof ArchiveServiceJobInfo) || jobInfo.getEnded() == null || !jobInfo.getEnded().toCalendar().before(jobInfoDeadline)) continue;
                            try {
                                CDESDataFile df = (CDESDataFile)jobInfo.getResult();
                                File file = this.fileFinder.findFile(df);
                                boolean deleted = file.delete();
                                if (deleted) {
                                    ((ArchiveServiceInvocationInformationImpl)this.invocationInformation).getServiceInvocationQueue().deleteRecentJobInfo(jobInfo.getId());
                                    continue;
                                }
                                logger.error((Object)("Could not delete bulk download file for JobInfo with id=[" + jobInfo.getId() + "]"));
                            }
                            catch (Exception e) {
                                logger.error((Object)"Could not delete bulk download file", (Throwable)e);
                            }
                        }
                    }
                    logger.info((Object)"scan completed, next run in an hour.");
                }
                OutdatedFileRemover outdatedFileRemover = this;
                synchronized (outdatedFileRemover) {
                    this.wait(3600000L);
                }
            }
            return;
        }
        catch (InterruptedException e) {
            logger.warn((Object)"OutdatedFileRemover has been interrupted");
            return;
        }
        catch (Throwable e) {
            logger.error((Object)"Exception in OutdatedFileRemover.run()", e);
        }
    }

    public void setOrderOperations(OrderOperations orderOperations) {
        this.orderOperations = orderOperations;
    }

    public void setInvocationInformation(ServiceInvocationInformation invocationInformation) {
        this.invocationInformation = invocationInformation;
    }

    public void setExecutionHour(int executionHour) {
        this.executionHour = executionHour;
    }

    public void setArchiveJobExpirationDays(int archiveJobExpirationDays) {
        this.archiveJobExpirationDays = archiveJobExpirationDays;
    }

    public void setOriginalDocumentExpirationDays(int originalDocumentExpirationDays) {
        this.originalDocumentExpirationDays = originalDocumentExpirationDays;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }
}

