/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.service.JobInfo;
import at.cdes.service.ServiceInvocationInformation;
import at.cdes.service.ServiceInvocationQueue;
import java.util.List;
import org.aopalliance.intercept.Joinpoint;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;
import org.clazzes.util.aop.ReflectiveMethodInvocation;

public class QueuedServiceCallInterceptor
implements MethodInterceptor {
    private static final Logger log = Logger.getLogger(QueuedServiceCallInterceptor.class);
    private ServiceInvocationQueue queue;
    private Object invocationTarget;
    private boolean allowMultipleInvocations;
    private ServiceInvocationInformation invocationInformation;

    public QueuedServiceCallInterceptor() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"instanciated.");
        }
        this.allowMultipleInvocations = true;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (invocation == null) {
            log.error((Object)"invoke called with 'null' argument.");
        } else {
            JobInfo job;
            String methodName = invocation.getMethod().getName();
            if (!("getPlotStudioBulkDownload".equals(methodName) || "getBulkDownload".equals(methodName) || "getArchiveBulkDownload".equals(methodName) || "getCustomLabelBulkDownload".equals(methodName) || "archiveProject".equals(methodName) || "removeProjectDataFiles".equals(methodName) || "restoreProjectFiles".equals(methodName) || "activateProject".equals(methodName) || "getPlotOrderDeliveryNoteBulkDownload".equals(methodName))) {
                return invocation.proceed();
            }
            if (!this.allowMultipleInvocations) {
                if (this.invocationInformation == null) {
                    log.error((Object)"Can't test for multiplicity: No ServiceInvocationInformation set.");
                } else {
                    List<JobInfo> queuedJobs = this.invocationInformation.getJobInfos();
                    if (queuedJobs != null && queuedJobs.size() > 0) {
                        JobInfo current = this.invocationInformation.getJobInfo((Joinpoint)invocation);
                        for (JobInfo test : queuedJobs) {
                            if (test.getEnded() != null || !current.equals(test)) continue;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Won't queue invocation: [" + invocation.toString() + "], is allready on queue."));
                            }
                            return null;
                        }
                    }
                }
            }
            ReflectiveMethodInvocation res = new ReflectiveMethodInvocation(this.invocationTarget, invocation.getMethod(), invocation.getArguments());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding new invocation: [" + invocation.getMethod().getName() + ", arguments: " + (invocation.getArguments() == null ? "null" : invocation.getArguments()) + "] to queue: [" + this.queue.getClass().getName() + "]."));
            }
            if ((job = this.invocationInformation.getJobInfo((Joinpoint)res)) == null) {
                log.error((Object)("Can't get Job form [" + this.invocationInformation.getClass().getName() + "]."));
            } else {
                this.queue.addInvocation(job);
            }
        }
        return null;
    }

    public void setQueue(ServiceInvocationQueue queue) {
        this.queue = queue;
    }

    public void setInvocationTarget(Object invocationTarget) {
        this.invocationTarget = invocationTarget;
    }

    public void setAllowMultipleInvocations(boolean allowMultipleInvocations) {
        this.allowMultipleInvocations = allowMultipleInvocations;
    }

    public void setInvocationInformation(ServiceInvocationInformation invocationInformation) {
        this.invocationInformation = invocationInformation;
    }
}

