/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.person.OldPassword;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.sec.TapestryPasswordChanger;
import at.cdes.db.dao.OldPasswordDAO;
import at.cdes.db.dao.PersonDAO;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.clazzes.util.sec.BCryptPasswordHasher;

public class TapestryPasswordChangerImpl
implements TapestryPasswordChanger {
    private OldPasswordDAO oldPasswordDAO;
    private PersonDAO personDAO;
    private Long maximumNumberOfOldPasswords;

    public void setOldPasswordDAO(OldPasswordDAO oldPasswordDAO) {
        this.oldPasswordDAO = oldPasswordDAO;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public void setMaximumNumberOfOldPasswords(Long maximumNumberOfOldPasswords) {
        this.maximumNumberOfOldPasswords = maximumNumberOfOldPasswords;
    }

    @Override
    public void setPassword(Integer personId, String newPassword) {
        Person person = this.personDAO.get(personId);
        OldPassword oldPassword = new OldPassword();
        oldPassword.setPerson(person);
        oldPassword.setPassword(person.getPassword());
        oldPassword.setSetTs(person.getLastPasswordChangeTs());
        BCryptPasswordHasher pwhasher = new BCryptPasswordHasher();
        String hashed = pwhasher.hashPassword(newPassword);
        person.setLastPasswordChangeTs(Instant.now().toEpochMilli());
        person.setPassword(hashed);
        this.personDAO.update(person);
        int maximumNumberOfOldPasswordsToStore = 0;
        if (oldPassword.getPassword() != null && !oldPassword.getPassword().isEmpty()) {
            List<OldPassword> allOldPasswords;
            this.oldPasswordDAO.save(oldPassword);
            if (this.maximumNumberOfOldPasswords != null && this.maximumNumberOfOldPasswords > 0L) {
                maximumNumberOfOldPasswordsToStore = this.maximumNumberOfOldPasswords.intValue() - 1;
            }
            if ((allOldPasswords = this.oldPasswordDAO.getByPerson(personId)).size() <= maximumNumberOfOldPasswordsToStore) {
                return;
            }
            Collections.sort(allOldPasswords, new Comparator<OldPassword>(){

                @Override
                public int compare(OldPassword o1, OldPassword o2) {
                    Long tsTwo;
                    Long tsOne = o1.getSetTs();
                    long diff = (tsOne != null ? tsOne : 0L) - ((tsTwo = o2.getSetTs()) != null ? tsTwo : 0L);
                    if (diff < 0L) {
                        return -1;
                    }
                    if (diff > 0L) {
                        return 1;
                    }
                    return 0;
                }
            });
            if (allOldPasswords.size() > maximumNumberOfOldPasswordsToStore) {
                List<OldPassword> oldPasswordsToRemove = allOldPasswords.subList(0, allOldPasswords.size() - maximumNumberOfOldPasswordsToStore);
                for (OldPassword oldPasswordToRemove : oldPasswordsToRemove) {
                    this.oldPasswordDAO.delete(oldPasswordToRemove);
                }
            }
        }
    }
}

