/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler.login;

import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.person.Person;
import at.cdes.controller.actionhandler.login.URLMapTagHandler;
import at.cdes.controller.actionhandler.login.URLMapper;
import at.cdes.controller.actionhandler.login.URLRule;
import at.cdes.service.exception.ActionException;
import at.cdes.util.ConfigurationHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ognl.OgnlException;
import org.apache.log4j.Logger;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.xml.SAXTagHandler;
import org.clazzes.util.xml.SimpleContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class URLRuleMatcher
implements URLMapper {
    private static final Logger log = Logger.getLogger(URLRuleMatcher.class);
    private List<URLRule> rules;
    private String instance;
    private String applicationUrlThreadLocalKey;

    public void setApplicationUrlThreadLocalKey(String applicationUrlThreadLocalKey) {
        this.applicationUrlThreadLocalKey = applicationUrlThreadLocalKey;
    }

    public String getDefaultURL() {
        return (String)ThreadLocalManager.getBoundResource((String)this.applicationUrlThreadLocalKey);
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) throws SAXException, IOException {
        this.instance = instance;
        String filename = ConfigurationHelper.getInstanceConfigFileName(ConfigurationHelper.getOperationSystemStatic(), instance, "urlMap.xml");
        File file = new File(filename);
        if (file.exists()) {
            log.info((Object)("Reading login URL rules from file [" + filename + "]."));
            this.readXmlFile(new InputSource(new FileInputStream(filename)));
        } else {
            log.info((Object)("File [" + filename + "] does not exist, using a single default login URL."));
        }
    }

    public void readXmlFile(final InputSource source) throws SAXException, IOException {
        SimpleContentHandler handler = new SimpleContentHandler(){

            protected SAXTagHandler getRootHandler(String uri, String localName, String name, Attributes atts) throws SAXException {
                if (!uri.equals("http://www.cdes.at/login/2008")) {
                    throw new SAXException("Invalid namespace URI [" + uri + "] in file [" + source + "].");
                }
                if (!"urlMap".equals(localName)) {
                    throw new SAXException("Invalid root tag [" + localName + "] in file [" + source + "].");
                }
                return new URLMapTagHandler(URLRuleMatcher.this);
            }
        };
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler((ContentHandler)handler);
        reader.parse(source);
    }

    public URLRule getURLRule(OrganisationPerson op) {
        URLRule matchedRule = null;
        if (this.rules != null) {
            for (URLRule rule : this.rules) {
                try {
                    if (!rule.matches(op) || matchedRule != null && matchedRule.getPriority() >= rule.getPriority()) continue;
                    matchedRule = rule;
                }
                catch (OgnlException e) {
                    throw new ActionException("OGNL error evaluating rule [" + rule.getRule() + "].", e);
                }
            }
        }
        return matchedRule;
    }

    @Override
    public String getURL(OrganisationPerson op) {
        URLRule rule = this.getURLRule(op);
        String defaultURL = (String)ThreadLocalManager.getBoundResource((String)this.applicationUrlThreadLocalKey);
        return rule == null ? defaultURL : rule.getUrl();
    }

    @Override
    public String getURL(Person p) {
        URLRule matchedRule = null;
        for (OrganisationPerson op : p.getOrganisationPersons().values()) {
            URLRule rule = this.getURLRule(op);
            if (rule == null) continue;
            if (matchedRule == null || matchedRule.getPriority() < rule.getPriority()) {
                matchedRule = rule;
                continue;
            }
            if (matchedRule.getPriority() != rule.getPriority() || matchedRule == rule) continue;
            throw new ActionException("Ambiguous rules [" + matchedRule.getRule() + "] and [" + rule.getRule() + "] for person [id=" + p.getId() + "]");
        }
        String defaultURL = (String)ThreadLocalManager.getBoundResource((String)this.applicationUrlThreadLocalKey);
        return matchedRule == null ? defaultURL : matchedRule.getUrl();
    }

    public void addRule(URLRule rule) {
        if (this.rules == null) {
            this.rules = new ArrayList<URLRule>();
        }
        this.rules.add(rule);
    }

    public List<URLRule> getRules() {
        return this.rules;
    }
}

