/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.bo.document.DocumentTranslator;
import at.cdes.bo.document.DocumentVersionHelper;
import at.cdes.bo.plot.TiledImage;
import at.cdes.ext.preview.AbstractDocumentVersionMimeSource;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.preview.api.Annotation;
import at.cdes.preview.api.BoundingBoxWithAngle;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.ByteArrayMimeInputStream;
import at.cdes.preview.streams.FileMimeInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.clazzes.util.http.osgi.DefaultHttpContext;
import org.xnap.commons.i18n.I18n;

public class DocumentVersionPngTileMimeSource
extends AbstractDocumentVersionMimeSource {
    private static Logger log = Logger.getLogger(DocumentVersionPngTileMimeSource.class);

    @Override
    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        Integer id = (Integer)parameters[0];
        int baseSize = (Integer)parameters[1];
        boolean antialias = (Boolean)parameters[2];
        double resolution = (Double)parameters[3];
        int itile = (Integer)parameters[4];
        int jtile = (Integer)parameters[5];
        LabelContent labelContent = null;
        DocumentVersion dv = this.getDocumentVersionDAO().get(id);
        if (dv.getLabelContentId() != null) {
            labelContent = this.getLabelOperations().getLabelContent(dv.getLabelContentId());
        }
        int angle = dv.getPreviewRotation();
        if (parameters.length > 6) {
            angle = (Integer)parameters[6];
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("id=" + id + ",baseSize=" + baseSize + ",antialias=" + antialias + ",resolution=" + resolution + ",itile=" + itile + ",jtile=" + jtile + ",angle=" + angle));
        }
        try (FileMimeInputStream stream = null;){
            IMimeInputStream ret;
            File file = this.getFileFinder().findFile(dv.getFileName(), CDESFileRepository.PLANREPOSITORY);
            String unique = this.getFileFinder().makeUniqueName(dv.getFileName(), CDESFileRepository.PLANREPOSITORY);
            IHPGLRenderer renderer = this.getHpglRenderer();
            stream = new FileMimeInputStream(file, unique, dv.getName() + "." + dv.getFileType(), DefaultHttpContext.getInstance().getMimeType(dv.getFileName()));
            ArrayList<Annotation> annotations = null;
            if (labelContent != null && dv.getLabelCorrelation() != null) {
                annotations = new ArrayList<Annotation>();
                Date creationDate = new Date();
                creationDate.setTime(file.lastModified());
                byte[] fdf_data = this.getLabelOperations().formatFDF(dv, false);
                ByteArrayMimeInputStream fdf_is = new ByteArrayMimeInputStream(fdf_data, 0.001 * (double)file.lastModified(), labelContent.getName(), "application/vnd.fdf");
                annotations.add(new Annotation((IMimeInputStream)fdf_is, "", "", "", 2));
            }
            Locale locale = DocumentVersionHelper.getProjectLocaleFromDocumentVersion(dv);
            I18n i18n = I18nFactory.getI18n(locale);
            String stamp = DocumentTranslator.getStatusStamp(i18n, dv.getStatus());
            TiledImage ti = new TiledImage(dv, baseSize, resolution, angle);
            BoundingBoxWithAngle tileBox = ti.getTileBox(itile, jtile);
            if (log.isDebugEnabled()) {
                log.debug((Object)("llx=" + tileBox.getLlx() + ",lly=" + tileBox.getLly() + ",urx=" + tileBox.getUrx() + ",ury=" + tileBox.getUry() + ",angle=" + tileBox.getAngle()));
            }
            IMimeInputStream iMimeInputStream = ret = renderer.renderPngTileByResolution((IMimeInputStream)stream, resolution, antialias, tileBox, stamp, annotations);
            return iMimeInputStream;
        }
    }
}

