/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.search;

import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.ReleasedDocument;
import at.cdes.bo.data.search.ReviewCycleStatusSearch;
import at.cdes.bo.data.task.ReviewCycleEntryTask;
import at.cdes.bo.data.task.ReviewCycleTask;
import at.cdes.bo.date.HolidayCalculator;
import at.cdes.service.ReviewOperations;
import at.cdes.service.TaskOperations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class ReviewCycleStatusSearchInterpreter
implements Serializable {
    private static final long serialVersionUID = 4769663471692399482L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkDocumentVersion(DocumentVersion version, ReviewCycleStatusSearch search, TaskOperations taskOperations, ReviewOperations reviewOperations, HolidayCalculator hc) {
        boolean selected;
        block34: {
            block35: {
                boolean found;
                boolean found2;
                selected = true;
                if (search.getDocumentStatus() != 0 && search.getDocumentStatus() != 9 && search.getDocumentStatus() != version.getStatus() && search.getDocumentStatus() != 6) {
                    return false;
                }
                if (search.getDocumentStatus() != 0 && search.getDocumentStatus() == 6) {
                    switch (version.getStatus()) {
                        case 2: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 11: {
                            return false;
                        }
                    }
                }
                if (search.getDocumentStatus() == 9) {
                    if (version.getStatus() == 7) return false;
                    if (version.getStatus() == 4) return false;
                    if (version.getStatus() == 5) {
                        return false;
                    }
                }
                if (search.isUseReleaseDate() && (search.getUploadedFrom() != null || search.getUploadedTo() != null) && version.getStatus() != 2) {
                    return false;
                }
                String dvName = search.getDocumentVersionName();
                if (!(dvName != null && dvName.length() == 1 && dvName.startsWith(" ") || dvName == null || dvName.length() <= 0 || (found2 = this.evalSearchTerm(version.getName(), dvName)))) {
                    return false;
                }
                String content = search.getDocumentContent();
                if (!(content != null && content.length() == 1 && content.startsWith(" ") || content == null || content.length() <= 0 || (found = this.evalSearchTerm(version.getDocument().getContent(), content)))) {
                    return false;
                }
                if (search.getReviewCycleNodeId() != null) {
                    if (!version.getActualReviewCycleNode().getId().equals(search.getReviewCycleNodeId())) {
                        if (search.getReviewCycleNodeId2() == null) return false;
                        if (!version.getActualReviewCycleNode().getId().equals(search.getReviewCycleNodeId2())) {
                            return false;
                        }
                    }
                } else if (search.getReviewCycleCellId() != null && !version.getActualReviewCycleNode().getReviewCycleCell().getId().equals(search.getReviewCycleCellId())) {
                    if (search.getReviewCycleCellId2() == null) return false;
                    if (!version.getActualReviewCycleNode().getReviewCycleCell().getId().equals(search.getReviewCycleCellId2())) {
                        return false;
                    }
                }
                if (search.getDaysOfDelay() == 0) break block34;
                ReviewCycleTask task = taskOperations.getFirstTaskOfDocumentVersion(version.getId());
                if (task == null) break block35;
                switch (search.getDaysOfDelay()) {
                    case 1: {
                        if (!search.checkForNoDelay(task, hc)) {
                            selected = false;
                            break;
                        }
                        break block34;
                    }
                    case 2: {
                        if (!search.checkForDelay(task, hc)) {
                            selected = false;
                            break;
                        }
                        break block34;
                    }
                    case 3: {
                        if (!search.checkForLongDelay(task, hc)) {
                            selected = false;
                            break;
                        }
                        break block34;
                    }
                }
                break block34;
            }
            selected = false;
        }
        if (search.getUploadedFrom() == null) {
            if (search.getUploadedTo() == null) return selected;
        }
        Calendar cal = Calendar.getInstance();
        if (search.isUseReleaseDate()) {
            ReviewCycleNodeResult nodeRes = reviewOperations.getReviewCycleNodeResult(version.getActualReviewCycleNode(), version);
            Calendar until = null;
            if (search.getUploadedTo() != null) {
                until = Calendar.getInstance();
                until.setTime(search.getUploadedTo());
                until.set(11, 23);
                until.set(12, 59);
                until.set(13, 59);
            }
            Date releaseDate = null;
            if (nodeRes != null && version.getStatus() != 1) {
                ReviewCyclePositionResult latestPositionResult = reviewOperations.getLatestPositionResultOfDocumentVersion(version.getId());
                if (latestPositionResult == null && version.getStatus() == 2) {
                    releaseDate = nodeRes.getDocumentArrivalDate();
                } else if (latestPositionResult != null && latestPositionResult.getReviewCycleResultOption() != null && Integer.valueOf(2).equals(latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus())) {
                    releaseDate = latestPositionResult.getResultDate();
                }
            }
            if (releaseDate == null) return false;
            if (search.getUploadedFrom() != null) {
                if (releaseDate.before(search.getUploadedFrom())) return false;
            }
            if (until == null) return selected;
            if (!releaseDate.after(until.getTime())) return selected;
            return false;
        }
        if (search.getUploadedFrom() != null) {
            cal.setTime(search.getUploadedFrom());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            if (version.getUploaded().compareTo(cal.getTime()) < 0) {
                selected = false;
            }
        }
        if (search.getUploadedTo() == null) return selected;
        cal.setTime(search.getUploadedTo());
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        if (version.getUploaded().compareTo(cal.getTime()) <= 0) return selected;
        return false;
    }

    public boolean checkDocument(Document document, ReviewCycleStatusSearch search, TaskOperations taskOperations, HolidayCalculator hc) {
        boolean selected;
        block16: {
            block17: {
                boolean found;
                boolean found2;
                String dvName;
                if (search.isUseReleaseDate() && (search.getUploadedFrom() != null || search.getUploadedTo() != null)) {
                    return false;
                }
                selected = true;
                if (search.getDocumentStatus() != 0) {
                    selected = false;
                }
                if (search.getDocumentStatus() == 11 || search.getDocumentStatus() == 9) {
                    selected = true;
                }
                if (!((dvName = search.getDocumentVersionName()) != null && dvName.length() == 1 && dvName.startsWith(" ") || dvName == null || dvName.length() <= 0 || (found2 = this.evalSearchTerm(document.getName(), dvName)))) {
                    return false;
                }
                String content = search.getDocumentContent();
                if (!(content != null && content.length() == 1 && content.startsWith(" ") || content == null || content.length() <= 0 || (found = this.evalSearchTerm(document.getContent(), content)))) {
                    return false;
                }
                if (search.getDaysOfDelay() == 0) break block16;
                ReviewCycleEntryTask task = taskOperations.getReviewCycleEntryTask(document instanceof ReleasedDocument ? ((ReleasedDocument)document).getDocument().getId() : document.getId());
                if (task == null) break block17;
                switch (search.getDaysOfDelay()) {
                    case 1: {
                        if (!search.checkForNoDelay(task, hc)) {
                            selected = false;
                            break;
                        }
                        break block16;
                    }
                    case 2: {
                        if (!search.checkForDelay(task, hc)) {
                            selected = false;
                            break;
                        }
                        break block16;
                    }
                    case 3: {
                        if (!search.checkForLongDelay(task, hc)) {
                            selected = false;
                            break;
                        }
                        break block16;
                    }
                }
                break block16;
            }
            selected = false;
        }
        if (search.getReviewCycleNodeId() != null) {
            selected = false;
        } else if (search.getReviewCycleCellId() != null) {
            selected = false;
        }
        return selected;
    }

    private boolean evalSearchTerm(String documentText, String searchTerm) {
        boolean found = false;
        if (searchTerm.contains("'") || searchTerm.contains("\"")) {
            searchTerm = searchTerm.replace('\'', '\"');
            ArrayList<String> subStrs = new ArrayList<String>();
            while (searchTerm.length() > 0 && (searchTerm.length() != 1 || !searchTerm.startsWith(" ") && !searchTerm.startsWith("\""))) {
                int i;
                boolean notlastword;
                if (searchTerm.startsWith(" ")) {
                    searchTerm = searchTerm.substring(1);
                    continue;
                }
                if (searchTerm.startsWith("\"")) {
                    notlastword = false;
                    for (i = 1; i < searchTerm.length(); ++i) {
                        if (searchTerm.charAt(i) != '\"') continue;
                        subStrs.add(new String(searchTerm.substring(1, i)));
                        searchTerm = searchTerm.substring(i + 1);
                        notlastword = true;
                        break;
                    }
                    if (notlastword) continue;
                    subStrs.add(new String(searchTerm.substring(1)));
                    searchTerm = "";
                    continue;
                }
                notlastword = false;
                for (i = 0; i < searchTerm.length(); ++i) {
                    if (!Character.isWhitespace(searchTerm.charAt(i))) continue;
                    subStrs.add(new String(searchTerm.substring(0, i)));
                    searchTerm = searchTerm.substring(i);
                    notlastword = true;
                    break;
                }
                if (notlastword) continue;
                subStrs.add(searchTerm);
                searchTerm = "";
            }
            for (String part : subStrs) {
                if (!documentText.toLowerCase().contains(part.toLowerCase())) continue;
                found = true;
                break;
            }
        } else {
            String[] parts;
            if (searchTerm.startsWith(" ")) {
                searchTerm = searchTerm.substring(1);
            }
            searchTerm = searchTerm.toLowerCase();
            for (String part : parts = searchTerm.split(" ")) {
                if (part.length() <= 0 || !documentText.toLowerCase().contains(part)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public ArrayList<String> getSearchSubstrings(String searchTerm) {
        searchTerm = searchTerm.trim();
        searchTerm = searchTerm.toLowerCase();
        ArrayList<String> subStrs = new ArrayList<String>();
        if (searchTerm.contains("'") || searchTerm.contains("\"")) {
            searchTerm = searchTerm.replace('\'', '\"');
            while (searchTerm.length() > 0 && (searchTerm.length() != 1 || !searchTerm.startsWith(" ") && !searchTerm.startsWith("\""))) {
                int i;
                boolean notlastword;
                if (searchTerm.startsWith(" ")) {
                    searchTerm = searchTerm.substring(1);
                    continue;
                }
                if (searchTerm.startsWith("\"")) {
                    notlastword = false;
                    for (i = 1; i < searchTerm.length(); ++i) {
                        if (searchTerm.charAt(i) != '\"') continue;
                        subStrs.add(new String(searchTerm.substring(1, i)));
                        searchTerm = searchTerm.substring(i + 1);
                        notlastword = true;
                        break;
                    }
                    if (notlastword) continue;
                    subStrs.add(new String(searchTerm.substring(1)));
                    searchTerm = "";
                    continue;
                }
                notlastword = false;
                for (i = 0; i < searchTerm.length(); ++i) {
                    if (!Character.isWhitespace(searchTerm.charAt(i))) continue;
                    subStrs.add(new String(searchTerm.substring(0, i)));
                    searchTerm = searchTerm.substring(i);
                    notlastword = true;
                    break;
                }
                if (notlastword) continue;
                subStrs.add(searchTerm);
                searchTerm = "";
            }
        } else {
            String[] parts;
            for (String part : parts = searchTerm.split(" ")) {
                if (part.length() <= 0) continue;
                subStrs.add(part);
            }
        }
        return subStrs;
    }
}

