/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.document.DocumentType;
import at.cdes.bo.data.document.DocumentTypeDefault;
import at.cdes.bo.data.network.MasterDataSet;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.network.NetworkNameComparator;
import at.cdes.bo.data.network.NetworkPerson;
import at.cdes.bo.data.network.NetworkPersonSelectWrapper;
import at.cdes.bo.data.network.NetworkType;
import at.cdes.bo.data.network.Support;
import at.cdes.bo.data.number.DocumentNumberPart;
import at.cdes.bo.data.number.DocumentNumberPartDefault;
import at.cdes.bo.data.number.DocumentNumberPartGroup;
import at.cdes.bo.data.number.DocumentNumberPartGroupDefault;
import at.cdes.bo.data.number.DocumentNumberPartOption;
import at.cdes.bo.data.object.ObjectType;
import at.cdes.bo.data.object.ObjectTypeDefault;
import at.cdes.bo.data.organisation.Organisation;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.data.planningNotification.PersonInChargeType;
import at.cdes.bo.data.planningNotification.PersonInChargeTypeDefault;
import at.cdes.bo.data.planningNotification.StatutoryDutyType;
import at.cdes.bo.data.planningNotification.StatutoryDutyTypeDefault;
import at.cdes.bo.data.planningNotification.SubjectAreaType;
import at.cdes.bo.data.planningNotification.SubjectAreaTypeDefault;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.SubProjectType;
import at.cdes.bo.data.project.SubProjectTypeDefault;
import at.cdes.bo.data.role.ActionRule;
import at.cdes.bo.data.role.ActionRuleDefault;
import at.cdes.bo.data.role.Role;
import at.cdes.bo.data.role.RoleDefault;
import at.cdes.bo.data.sec.SignatureCalculatorType;
import at.cdes.db.dao.ActionDAO;
import at.cdes.db.dao.DocumentDAO;
import at.cdes.db.dao.DocumentNumberPartDAO;
import at.cdes.db.dao.DocumentTypeDAO;
import at.cdes.db.dao.DocumentTypeDefaultDAO;
import at.cdes.db.dao.MasterDataSetDAO;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.NetworkTypeDAO;
import at.cdes.db.dao.ObjectDAO;
import at.cdes.db.dao.ObjectTypeDAO;
import at.cdes.db.dao.OrganisationDAO;
import at.cdes.db.dao.OrganisationPersonDAO;
import at.cdes.db.dao.PersonDAO;
import at.cdes.db.dao.PlanningNotificationMasterDataDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.db.dao.ReviewCycleDAO;
import at.cdes.db.dao.RoleDAO;
import at.cdes.db.dao.SignatureDAO;
import at.cdes.db.dao.SubProjectDAO;
import at.cdes.db.dao.SubProjectTypeDAO;
import at.cdes.db.dao.SubProjectTypeDefaultDAO;
import at.cdes.db.dao.SupportDAO;
import at.cdes.service.NetworkOperations;
import at.cdes.service.OrganisationOperations;
import at.cdes.service.RoleOperations;
import at.cdes.util.ImplContextHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NetworkOperationsImpl
implements NetworkOperations {
    private NetworkDAO networkDAO;
    private RoleDAO roleDAO;
    private ActionDAO actionDAO;
    private OrganisationDAO organisationDAO;
    private SubProjectDAO subProjectDAO;
    private SubProjectTypeDAO subProjectTypeDAO;
    private SubProjectTypeDefaultDAO subProjectTypeDefaultDAO;
    private DocumentNumberPartDAO documentNumberPartDAO;
    private DocumentTypeDefaultDAO documentTypeDefaultDAO;
    private DocumentTypeDAO documentTypeDAO;
    private ObjectTypeDAO objectTypeDAO;
    private SignatureDAO signatureDAO;
    private NetworkTypeDAO networkTypeDAO;
    private MasterDataSetDAO masterDataSetDAO;
    private ObjectDAO objectDAO;
    private DocumentDAO documentDAO;
    private ProjectDAO projectDAO;
    private SupportDAO supportDAO;
    private ReviewCycleDAO reviewCycleDAO;
    private PersonDAO personDAO;
    private PlanningNotificationMasterDataDAO PlanningNotificationMasterDataDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private OrganisationOperations organisationOperations;
    private RoleOperations roleOperations;

    public void setRoleOperations(RoleOperations roleOperations) {
        this.roleOperations = roleOperations;
    }

    public void setOrganisationOperations(OrganisationOperations organisationOperations) {
        this.organisationOperations = organisationOperations;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setObjectDAO(ObjectDAO objectDAO) {
        this.objectDAO = objectDAO;
    }

    public void setMasterDataSetDAO(MasterDataSetDAO masterDataSetDAO) {
        this.masterDataSetDAO = masterDataSetDAO;
    }

    public void setDocumentTypeDAO(DocumentTypeDAO documentTypeDAO) {
        this.documentTypeDAO = documentTypeDAO;
    }

    public void setObjectTypeDAO(ObjectTypeDAO objectTypeDAO) {
        this.objectTypeDAO = objectTypeDAO;
    }

    public void setDocumentTypeDefaultDAO(DocumentTypeDefaultDAO documentTypeDefaultDAO) {
        this.documentTypeDefaultDAO = documentTypeDefaultDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setRoleDAO(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public void setOrganisationDAO(OrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setSubProjectDAO(SubProjectDAO projectDAO) {
        this.subProjectDAO = projectDAO;
    }

    public void setNetworkTypeDAO(NetworkTypeDAO networkTypeDAO) {
        this.networkTypeDAO = networkTypeDAO;
    }

    public void setSupportDAO(SupportDAO supportDAO) {
        this.supportDAO = supportDAO;
    }

    public void setPlanningNotificationMasterDataDAO(PlanningNotificationMasterDataDAO planningNotificationMasterDataDAO) {
        this.PlanningNotificationMasterDataDAO = planningNotificationMasterDataDAO;
    }

    @Override
    public Map getNetworkPersons(Integer networkId) {
        return this.networkDAO.get(networkId).getNetworkPersons();
    }

    @Override
    public Network getNetwork(Integer id) {
        return id != null ? this.networkDAO.get(id) : null;
    }

    @Override
    public List getAllNetworks() {
        return this.networkDAO.getAll();
    }

    @Override
    public Network insertNetwork(Network network, Map networkPersons, List otherNetworkPersonsInsert) {
        SignatureCalculatorType sct = this.signatureDAO.getSignatureCalculatorType(2);
        network.setSignatureCalculatorType(sct);
        network = this.networkDAO.save(network);
        this.organisationOperations.addOrganisationToNetwork(network.getMaintainer(), network);
        List<Organisation> eviOrgs = this.organisationDAO.getByName("ev-i Informationst");
        network.setRoles(new HashMap());
        Collection templateRoles = network.getNetworkType().getRoles().values();
        Iterator it = templateRoles.iterator();
        RoleDefault defaultRole = network.getNetworkType().getNetworkAdministratorRole();
        Role administratorRole = null;
        HashMap templateActionRules = new HashMap();
        HashMap<Integer, ActionRule> createdActionRules = new HashMap<Integer, ActionRule>();
        while (it.hasNext()) {
            RoleDefault templateRole = (RoleDefault)it.next();
            Role role = new Role();
            role.setDescription(templateRole.getDescription());
            role.setName(templateRole.getName());
            role.setId(null);
            role.setNetwork(network);
            role.setRoleDefault(templateRole);
            role.setContextDefaultRole(templateRole.isContextDefaultRole());
            role.setProjectFlag(templateRole.getProjectFlag());
            role.setType(templateRole.getRoleType());
            role = this.roleDAO.save(role);
            if (role.getActionRules() == null) {
                role.setActionRules(new HashMap());
            }
            Collection templateRoleActionRules = templateRole.getActionRuleDefaults().values();
            Iterator templateRoleActionRuleIt = templateRoleActionRules.iterator();
            templateActionRules.putAll(templateRole.getActionRuleDefaults());
            while (templateRoleActionRuleIt.hasNext()) {
                ActionRule rule;
                ActionRuleDefault templateActionRule = (ActionRuleDefault)templateRoleActionRuleIt.next();
                if (!createdActionRules.containsKey(templateActionRule.getId())) {
                    rule = new ActionRule();
                    rule.setNetwork(network);
                    rule.setAction(templateActionRule.getAction());
                    rule.setDestinationContext(templateActionRule.getDestinationContext());
                    rule.setSelected(templateActionRule.isSelected());
                    rule.setCheckMember(templateActionRule.isCheckMember());
                    if (rule.getRoles() == null) {
                        rule.setRoles(new HashMap());
                    }
                    rule.getRoles().put(role.getId(), role);
                    rule = this.actionDAO.save(rule);
                    role.getActionRules().put(rule.getId(), rule);
                    createdActionRules.put(templateActionRule.getId(), rule);
                    continue;
                }
                rule = (ActionRule)createdActionRules.get(templateActionRule.getId());
                if (rule.getRoles() == null) {
                    rule.setRoles(new HashMap());
                }
                rule.getRoles().put(rule.getId(), rule);
                rule = this.actionDAO.update(rule);
                role.getActionRules().put(rule.getId(), rule);
            }
            role = this.roleDAO.update(role);
            if (templateRole.getId().equals(defaultRole.getId())) {
                administratorRole = role;
            }
            network.getRoles().put(role.getId(), role);
        }
        List actionRules = this.actionDAO.getAllActionRuleDefaults();
        for (int i = 0; i < actionRules.size(); ++i) {
            ActionRuleDefault actionRule = (ActionRuleDefault)actionRules.get(i);
            if (templateActionRules.containsKey(actionRule.getId())) continue;
            ActionRule rule = new ActionRule();
            rule.setNetwork(network);
            rule.setAction(actionRule.getAction());
            rule.setDestinationContext(actionRule.getDestinationContext());
            rule.setCheckMember(actionRule.isCheckMember());
            rule = this.actionDAO.save(rule);
        }
        it = networkPersons.values().iterator();
        HashMap<Integer, NetworkPerson> newEntries = new HashMap<Integer, NetworkPerson>();
        while (it.hasNext()) {
            NetworkPerson np = (NetworkPerson)it.next();
            np.setRole(administratorRole);
            np.setNetwork(network);
            np = this.networkDAO.save(np);
            newEntries.put(np.getId(), np);
        }
        for (OrganisationPerson op : otherNetworkPersonsInsert) {
            Organisation org = op.getOrganisation();
            ArrayList orgsNetworks = new ArrayList(org.getNetworks().values());
            if (!orgsNetworks.contains(network.getId())) {
                this.organisationOperations.addOrganisationToNetwork(org, network);
            }
            NetworkPerson np = new NetworkPerson();
            np.setRole(administratorRole);
            np.setNetwork(network);
            np.setOrganisationPerson(op);
            np = this.networkDAO.save(np);
            newEntries.put(np.getId(), np);
            if (network.getOrganisations().containsKey(np.getOrganisationPerson().getOrganisation().getId())) continue;
            network.getOrganisations().put(np.getOrganisationPerson().getOrganisation().getId(), np.getOrganisationPerson().getOrganisation());
        }
        network.setNetworkPersons(newEntries);
        network = this.copyMasterDataForNetwork(network);
        network = this.copyDocumentNumberPartGroupsForNetwork(network);
        network = this.networkDAO.merge(network);
        return network;
    }

    @Override
    public Network updateNetwork(Network editNetwork, Collection networkPersons, List otherNetworkPersonsInserts, List otherNetworkPersonsDeletes) {
        ArrayList nps;
        Network network = this.networkDAO.get(editNetwork.getId());
        network.setName(editNetwork.getName());
        HashMap<Integer, NetworkPerson> newEntries = new HashMap<Integer, NetworkPerson>();
        Iterator roleIt = network.getRoles().values().iterator();
        Role role = null;
        while (roleIt.hasNext() && ((role = (Role)roleIt.next()).getRoleDefault() == null || role.getRoleDefault().getId() != network.getNetworkType().getNetworkAdministratorRole().getId())) {
            role = null;
        }
        if (otherNetworkPersonsInserts != null) {
            nps = new ArrayList(network.getNetworkPersons().values());
            for (OrganisationPerson op : otherNetworkPersonsInserts) {
                boolean foundNetworkPerson = false;
                for (NetworkPerson np : nps) {
                    if (!np.getOrganisationPerson().getId().equals(op.getId())) continue;
                    foundNetworkPerson = true;
                    break;
                }
                if (foundNetworkPerson) continue;
                Organisation org = op.getOrganisation();
                ArrayList orgsNetworks = new ArrayList(org.getNetworks().values());
                if (!orgsNetworks.contains(network.getId())) {
                    this.organisationOperations.addOrganisationToNetwork(org, network);
                }
                NetworkPerson np = new NetworkPerson();
                np.setNetwork(network);
                np.setOrganisationPerson(op);
                np.setRole(role);
                np = this.networkDAO.update(np);
                newEntries.put(np.getId(), np);
            }
        }
        if (otherNetworkPersonsDeletes != null) {
            nps = new ArrayList(network.getNetworkPersons().values());
            block3: for (OrganisationPerson op : otherNetworkPersonsDeletes) {
                for (NetworkPerson np : nps) {
                    if (!np.getOrganisationPerson().getId().equals(op.getId())) continue;
                    newEntries.remove(np.getId());
                    this.networkDAO.delete(np);
                    continue block3;
                }
            }
        }
        for (NetworkPersonSelectWrapper np : networkPersons) {
            if (!np.isSelected()) {
                if (np.getId() == null) continue;
                this.networkDAO.delete(this.networkDAO.getNetworkPerson(np.getId()));
                continue;
            }
            NetworkPerson selectedPerson = np.getNetworkPerson();
            selectedPerson.setNetwork(network);
            if (selectedPerson.getId() != null) continue;
            selectedPerson.setRole(role);
            selectedPerson = this.networkDAO.save(selectedPerson);
            newEntries.put(selectedPerson.getId(), selectedPerson);
        }
        return this.networkDAO.merge(network);
    }

    @Override
    public void updateNetworkSubProjectTypes(Integer networkId, List<SubProjectType> subProjectTypes, MasterDataSet masterDataSet) {
        Network network = this.networkDAO.get(networkId);
        for (SubProjectType spt : subProjectTypes) {
            if (spt.getId() == null && (spt.getName() == null || spt.getName().length() == 0 || spt.getCode() == null || spt.getCode().length() == 0)) continue;
            spt.setNetwork(network);
            spt.setMasterDataSet(masterDataSet);
            if (spt.getId() == null) {
                this.subProjectTypeDAO.save(spt);
                continue;
            }
            if (spt.getName() == null || spt.getName().length() == 0 || spt.getCode() == null || spt.getCode().length() == 0) {
                this.subProjectTypeDAO.delete(spt);
                continue;
            }
            this.subProjectTypeDAO.update(spt);
        }
    }

    @Override
    public DocumentNumberPartGroup insertDocumentNumberParts(List parts, DocumentNumberPartGroup g) {
        g = this.documentNumberPartDAO.save(g);
        return this.updateDocumentNumberParts(parts, g);
    }

    @Override
    public DocumentNumberPartGroup updateDocumentNumberParts(List parts, DocumentNumberPartGroup g) {
        for (int i = 0; i < parts.size(); ++i) {
            DocumentNumberPart part = (DocumentNumberPart)parts.get(i);
            part.setGroup(g);
            if (part.getName() != null && part.getName().length() > 0) {
                if (part.getId() != null && part.getId() > 0) {
                    this.documentNumberPartDAO.update(part);
                } else {
                    this.documentNumberPartDAO.save(part);
                }
            }
            this.documentNumberPartDAO.update(g);
        }
        return g;
    }

    @Override
    public List getNetworkTypes() {
        return this.networkDAO.getNetworkTypes();
    }

    @Override
    public NetworkType getNetworkType(Integer id) {
        return this.networkDAO.getNetworkType(id);
    }

    @Override
    public List getNetworksByPersonId(Integer personId) {
        ArrayList<Network> networks = new ArrayList<Network>();
        Person person = this.personDAO.get(personId);
        for (OrganisationPerson orgPerson : person.getOrganisationPersons().values()) {
            if (orgPerson.isInActive()) continue;
            ArrayList orgPersonNetworks = new ArrayList(this.getNetworksByOrgPersonId(orgPerson.getId()));
            for (Network network : orgPersonNetworks) {
                if (networks.contains(network)) continue;
                networks.add(network);
            }
        }
        Collections.sort(networks, new NetworkNameComparator());
        return networks;
    }

    @Override
    public List getNetworksByOrgPersonId(Integer orgPersonId) {
        ArrayList<Object> networks = new ArrayList<Object>();
        OrganisationPerson orgPerson = this.organisationPersonDAO.get(orgPersonId);
        if (orgPerson.isInActive()) {
            return networks;
        }
        networks.addAll(orgPerson.getOrganisation().getNetworks().values());
        List networkPersonsNetworks = this.networkDAO.getNetworksByNetworkPersonsOrgPersonId(orgPersonId);
        for (Network network : networkPersonsNetworks) {
            if (networks.contains(network)) continue;
            networks.add(network);
        }
        Collections.sort(networks, new NetworkNameComparator());
        return networks;
    }

    @Override
    public List getPersonalNetworks() {
        return this.getNetworksByOrgPersonId(ImplContextHelper.getContextOrganisationPersonId());
    }

    @Override
    public List getNumberPatternGroups(Integer activeNetworkId) {
        return this.documentNumberPartDAO.getAllGroups(activeNetworkId);
    }

    @Override
    public List getNumberPatterns(Integer groupId) {
        return this.documentNumberPartDAO.getAll(groupId);
    }

    public void setDocumentNumberPartDAO(DocumentNumberPartDAO documentNumberPartDAO) {
        this.documentNumberPartDAO = documentNumberPartDAO;
    }

    @Override
    public DocumentNumberPartGroup getNumberPatternGroup(Integer numberPatternGroupId) {
        return this.documentNumberPartDAO.getGroup(numberPatternGroupId);
    }

    @Override
    public List getDocumentNumberParts(Integer groupId) {
        return this.documentNumberPartDAO.getAll(groupId);
    }

    @Override
    public List getPossibleDocumentPartsOption() {
        ArrayList<DocumentNumberPartOption> parts = new ArrayList<DocumentNumberPartOption>();
        parts.add(new DocumentNumberPartOption("Objektblattcode", "objectPlanner.code"));
        parts.add(new DocumentNumberPartOption("Objektcode", "objectPlanner.object.code"));
        parts.add(new DocumentNumberPartOption("Subprojektcode", "documentList.subProject.code"));
        parts.add(new DocumentNumberPartOption("Projektcode", "documentList.subProject.project.code"));
        parts.add(new DocumentNumberPartOption("Dokumenttypcode", "documentType.code"));
        parts.add(new DocumentNumberPartOption("Dokumenttypgruppe", "documentType.group.code"));
        parts.add(new DocumentNumberPartOption("Dokumentnummer", "number"));
        parts.add(new DocumentNumberPartOption("Auftragnehmercode", "objectPlanner.planner.customerId"));
        return parts;
    }

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setSubProjectTypeDAO(SubProjectTypeDAO subProjectTypeDAO) {
        this.subProjectTypeDAO = subProjectTypeDAO;
    }

    public void setSignatureDAO(SignatureDAO signatureDAO) {
        this.signatureDAO = signatureDAO;
    }

    @Override
    public List<DocumentTypeDefault> getDocumentTypesDefault() {
        return this.documentTypeDefaultDAO.getAll();
    }

    @Override
    public DocumentTypeDefault getDocumentTypeDefault(Integer id) {
        return this.documentTypeDefaultDAO.get(id);
    }

    public void setSubProjectTypeDefaultDAO(SubProjectTypeDefaultDAO subProjectTypeDefaultDAO) {
        this.subProjectTypeDefaultDAO = subProjectTypeDefaultDAO;
    }

    @Override
    public void updateSubProjectTypesDefault(List<SubProjectTypeDefault> sptList, NetworkType networkType) {
        for (SubProjectTypeDefault spt : sptList) {
            if (spt.getCode() == null || spt.getCode().length() == 0 || spt.getName() == null || spt.getName().length() == 0) continue;
            if (spt.getId() == null || spt.getId() < 0) {
                spt.setNetworkType(networkType);
                spt = this.subProjectTypeDefaultDAO.save(spt);
                networkType.getSubProjectTypeDefaults().put(spt.getId(), spt);
                continue;
            }
            this.subProjectTypeDefaultDAO.update(spt);
        }
    }

    @Override
    public SubProjectTypeDefault getSubProjectTypeDefault(Integer sptId) {
        return this.subProjectTypeDefaultDAO.get(sptId);
    }

    @Override
    public void deleteSubProjectTypeDefault(SubProjectTypeDefault spt) {
        this.subProjectTypeDefaultDAO.delete(spt);
    }

    @Override
    public DocumentTypeDefault updateDocumentTypesDefault(DocumentTypeDefault group, List<DocumentTypeDefault> documentTypes) {
        if (group.getId() != null) {
            group = this.documentTypeDefaultDAO.update(group);
        } else if (group.getName() != null && group.getName().length() > 0) {
            group = this.documentTypeDefaultDAO.save(group);
        }
        if (documentTypes != null) {
            for (DocumentTypeDefault type : documentTypes) {
                if (group.getNetworkType() != null) {
                    type.setNetworkType(group.getNetworkType());
                }
                if (type.getId() != null && type.getId() > 0) {
                    this.documentTypeDefaultDAO.update(type);
                    continue;
                }
                if (type.getName() == null || type.getName().length() == 0 || type.getCode() == null || type.getCode().length() == 0) continue;
                if (group.getId() != null) {
                    type.setDocumentTypeGroup(group);
                }
                type = this.documentTypeDefaultDAO.save(type);
                if (group.getId() == null) continue;
                if (group.getDocumentTypesDefault() == null) {
                    group.setDocumentTypesDefault(new HashMap());
                }
                group.getDocumentTypesDefault().put(type.getId(), type);
            }
        }
        return group.getId() != null ? group : null;
    }

    @Override
    public void deleteDocumentTypeDefaultGroup(Integer documentTypeGroupId) {
        DocumentTypeDefault group = this.documentTypeDefaultDAO.get(documentTypeGroupId);
        List documentTypes = this.documentTypeDefaultDAO.getDocumentTypesDefaultByGroup(group);
        if (documentTypes != null) {
            for (int i = 0; i < documentTypes.size(); ++i) {
                DocumentTypeDefault docType = (DocumentTypeDefault)documentTypes.get(i);
                this.documentTypeDefaultDAO.delete(docType);
            }
        }
        this.documentTypeDefaultDAO.delete(group);
    }

    @Override
    public List<DocumentTypeDefault> getDocumentTypeDefaultGroupsByNetworkType(Integer networkTypeId) {
        return this.documentTypeDefaultDAO.getAllGroupsByNetworkType(networkTypeId);
    }

    @Override
    public void deleteDocumentTypeDefault(Integer documentTypeDefaultId) {
        DocumentTypeDefault document = this.documentTypeDefaultDAO.get(documentTypeDefaultId);
        this.documentTypeDefaultDAO.delete(document);
    }

    @Override
    public SubProjectType getSubProjectType(Integer id) {
        return this.subProjectTypeDAO.get(id);
    }

    @Override
    public void deleteSubProjectType(SubProjectType type) {
        this.subProjectTypeDAO.delete(type);
    }

    @Override
    public void updateNetworkType(NetworkType networkType) {
        this.networkTypeDAO.update(networkType);
    }

    @Override
    public MasterDataSet getMasterDataSet(Integer id) {
        return this.masterDataSetDAO.getMasterDataSet(id);
    }

    @Override
    public void deleteMasterDataSet(MasterDataSet set) {
        this.masterDataSetDAO.delete(set);
    }

    @Override
    public MasterDataSet insertMasterDataSet(MasterDataSet set) {
        return this.masterDataSetDAO.save(set);
    }

    @Override
    public MasterDataSet updateMasterDataSet(MasterDataSet set) {
        return this.masterDataSetDAO.update(set);
    }

    @Override
    public MasterDataSet insertNewDefaultMasterDataSet(Integer networkId, MasterDataSet set) {
        Network net = this.getNetwork(networkId);
        set.setNetwork(net);
        set.setCreated(new Date(System.currentTimeMillis()));
        set = this.insertMasterDataSet(set);
        NetworkType networkType = net.getNetworkType();
        set.setDocumentTypes(new HashMap());
        set.setSubProjectTypes(new HashMap());
        set.setObjectTypes(new HashMap());
        List docTypeDefParents = networkType.getDocumentTypeDefaultsParentOnly();
        for (Object docTypeDef : docTypeDefParents) {
            DocumentType type = new DocumentType();
            type.setCode(((DocumentTypeDefault)docTypeDef).getCode());
            type.setDescription(((DocumentTypeDefault)docTypeDef).getDescription());
            type.setMasterDataSet(set);
            type.setName(((DocumentTypeDefault)docTypeDef).getName());
            type.setNetwork(net);
            type = this.documentTypeDAO.save(type);
            type.setDocumentTypes(new HashMap());
            Collection subTypes = ((DocumentTypeDefault)docTypeDef).getDocumentTypesDefault().values();
            for (DocumentTypeDefault subType : subTypes) {
                DocumentType st = new DocumentType();
                st.setCode(subType.getCode());
                st.setDescription(subType.getDescription());
                st.setMasterDataSet(set);
                st.setName(subType.getName());
                st.setNetwork(net);
                st.setDocumentTypeGroup(type);
                st = this.documentTypeDAO.save(st);
                type.getDocumentTypes().put(st.getId(), st);
                set.getDocumentTypes().put(type.getId(), type);
            }
            set.getDocumentTypes().put(type.getId(), type);
        }
        Collection subProjectTypeDefs = networkType.getSubProjectTypeDefaults().values();
        for (SubProjectTypeDefault sptDef : subProjectTypeDefs) {
            SubProjectType spt = sptDef.getAsSubProjectType();
            spt.setNetwork(net);
            spt.setMasterDataSet(set);
            spt.setSubProjectTypeDefault(sptDef);
            spt = this.subProjectTypeDAO.save(spt);
            set.getSubProjectTypes().put(spt.getId(), spt);
        }
        Collection objectTypeDefs = networkType.getObjectTypeDefaults().values();
        for (ObjectTypeDefault otd : objectTypeDefs) {
            ObjectType ot = new ObjectType();
            ot.setName(otd.getName());
            ot.setComment(otd.getComment());
            ot.setCode(otd.getCode());
            ot.setNetwork(net);
            ot.setMasterDataSet(set);
            ot.setObjectTypeDefault(otd);
            ot = this.objectTypeDAO.insertObjectType(ot);
            set.getObjectTypes().put(ot.getId(), ot);
        }
        set = this.updateMasterDataSet(set);
        return set;
    }

    @Override
    public boolean isMasterDataSetDeletable(Integer masterDataSetId) {
        MasterDataSet set = this.getMasterDataSet(masterDataSetId);
        if (set.getDocumentNumberPartGroups() != null && set.getDocumentNumberPartGroups().size() > 0) {
            return false;
        }
        List docTypeGroups = set.getDocumentTypesParentOnly();
        for (DocumentType docTypeGroup : docTypeGroups) {
            if (docTypeGroup.getLabelContents() != null && docTypeGroup.getLabelContents().size() > 0) {
                return false;
            }
            List docImpls = this.documentDAO.getDocumentsByDocumentType(docTypeGroup);
            if (docImpls != null && docImpls.size() > 0) {
                return false;
            }
            List releasedDocImpls = this.documentDAO.getReleasedDocumentsByDocumentType(docTypeGroup);
            if (releasedDocImpls != null && releasedDocImpls.size() > 0) {
                return false;
            }
            if (docTypeGroup.getDocumentTypes() == null) continue;
            Collection docTypes = docTypeGroup.getDocumentTypes().values();
            for (DocumentType docType : docTypes) {
                if (docType.getLabelContents() != null && docType.getLabelContents().size() > 0) {
                    return false;
                }
                List subDocImpls = this.documentDAO.getDocumentsByDocumentType(docType);
                if (subDocImpls != null && subDocImpls.size() > 0) {
                    return false;
                }
                List subReleasedDocImpls = this.documentDAO.getReleasedDocumentsByDocumentType(docType);
                if (subReleasedDocImpls == null || subReleasedDocImpls.size() <= 0) continue;
                return false;
            }
        }
        if (set.getSubProjectTypes() != null) {
            Collection spts = set.getSubProjectTypes().values();
            for (SubProjectType spt : spts) {
                List sps = this.subProjectDAO.getByType(spt.getId());
                if (sps == null || sps.size() <= 0) continue;
                return false;
            }
        }
        if (set.getObjectTypes() != null) {
            Collection ots = set.getObjectTypes().values();
            for (ObjectType ot : ots) {
                List objects = this.objectDAO.getUnreleasedByObjectType(ot);
                if (objects != null && objects.size() > 0) {
                    return false;
                }
                List releasedObjects = this.objectDAO.getReleasedByObjectType(ot);
                if (releasedObjects == null || releasedObjects.size() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void deleteMasterDataSetAndTypes(Integer masterDataSetId) {
        MasterDataSet set = this.masterDataSetDAO.getMasterDataSet(masterDataSetId);
        if (set.getSubProjectTypes() != null) {
            Collection spts = set.getSubProjectTypes().values();
            for (SubProjectType spt : spts) {
                this.subProjectTypeDAO.delete(spt);
            }
        }
        if (set.getObjectTypes() != null) {
            Collection ots = set.getObjectTypes().values();
            for (ObjectType ot : ots) {
                this.objectTypeDAO.deleteObjectType(ot);
            }
        }
        if (set.getDocumentTypes() != null) {
            List docTypeGroups = set.getDocumentTypesParentOnly();
            for (DocumentType docTypeGroup : docTypeGroups) {
                if (docTypeGroup.getDocumentTypes() != null) {
                    Collection docTypes = docTypeGroup.getDocumentTypes().values();
                    for (DocumentType docType : docTypes) {
                        this.documentTypeDAO.delete(docType);
                    }
                }
                this.documentTypeDAO.delete(docTypeGroup);
            }
        }
        this.deleteMasterDataSet(set);
    }

    public Network copyMasterDataForNetwork(Network network) {
        MasterDataSet set = new MasterDataSet();
        set.setCreated(new Date(System.currentTimeMillis()));
        set.setName("Standardsatz");
        set.setDescription("Vorkonfigurierte Stammdaten");
        set.setNetwork(network);
        set = this.insertMasterDataSet(set);
        for (ObjectTypeDefault otDefault : network.getNetworkType().getObjectTypeDefaults().values()) {
            ObjectType ot = new ObjectType();
            ot.setCode(otDefault.getCode());
            ot.setName(otDefault.getName());
            ot.setComment(otDefault.getComment());
            ot.setNetwork(network);
            ot.setMasterDataSet(set);
            ot = this.objectTypeDAO.insertObjectType(ot);
        }
        Iterator it = network.getNetworkType().getSubProjectTypeDefaults().values().iterator();
        while (it.hasNext()) {
            SubProjectType spt = ((SubProjectTypeDefault)it.next()).getAsSubProjectType();
            spt.setNetwork(network);
            spt.setMasterDataSet(set);
            spt = this.subProjectTypeDAO.save(spt);
        }
        List<DocumentTypeDefault> docTypesDefaultGroups = this.getDocumentTypeDefaultGroupsByNetworkType(network.getNetworkType().getId());
        for (DocumentTypeDefault docTypeDefaultGroup : docTypesDefaultGroups) {
            DocumentType docTypeGroup = new DocumentType();
            docTypeGroup.setCode(docTypeDefaultGroup.getCode());
            docTypeGroup.setName(docTypeDefaultGroup.getName());
            docTypeGroup.setDescription(docTypeDefaultGroup.getDescription());
            docTypeGroup.setNetwork(network);
            docTypeGroup.setDocumentTypes(new HashMap());
            docTypeGroup.setMasterDataSet(set);
            docTypeGroup = this.documentTypeDAO.save(docTypeGroup);
            List docTypesDefault = docTypeDefaultGroup.getDocumentTypesDefaultSortedByCode();
            for (DocumentTypeDefault docTypeDefault : docTypesDefault) {
                DocumentType docType = new DocumentType();
                docType.setCode(docTypeDefault.getCode());
                docType.setName(docTypeDefault.getName());
                docType.setDescription(docTypeDefault.getDescription());
                docType.setDocumentTypeGroup(docTypeGroup);
                docType.setNetwork(network);
                docType.setMasterDataSet(set);
                docType = this.documentTypeDAO.save(docType);
                docTypeGroup.getDocumentTypes().put(docType.getId(), docType);
            }
        }
        for (StatutoryDutyTypeDefault statDefault : network.getNetworkType().getStatutoryDutyTypeDefaults().values()) {
            StatutoryDutyType stat = new StatutoryDutyType();
            stat.setName(statDefault.getName());
            stat.setDescription(statDefault.getDescription());
            stat.setNetwork(network);
            stat = this.PlanningNotificationMasterDataDAO.insertStatutoryDutyType(stat);
        }
        for (PersonInChargeTypeDefault perDefault : network.getNetworkType().getPersonInChargeTypeDefaults().values()) {
            PersonInChargeType per = new PersonInChargeType();
            per.setName(perDefault.getName());
            per.setDescription(perDefault.getDescription());
            per.setNetwork(network);
            per = this.PlanningNotificationMasterDataDAO.insertPersonInChargeType(per);
        }
        for (SubjectAreaTypeDefault subDefault : network.getNetworkType().getSubjectAreaTypeDefaults().values()) {
            SubjectAreaType sub = new SubjectAreaType();
            sub.setName(subDefault.getName());
            sub.setDescription(subDefault.getDescription());
            sub.setNetwork(network);
            sub = this.PlanningNotificationMasterDataDAO.insertSubjectAreaType(sub);
        }
        return network;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    @Override
    public List getMasterDataSetsByNetwork(Integer networkId) {
        return this.masterDataSetDAO.getAllFromNetwork(networkId);
    }

    @Override
    public DocumentNumberPart getDocumentNumberPart(Integer documentNumberPartId) {
        return this.documentNumberPartDAO.get(documentNumberPartId);
    }

    @Override
    public void deleteDocumentNumberPart(Integer documentNumberPartId) {
        DocumentNumberPart dnp = this.documentNumberPartDAO.get(documentNumberPartId);
        this.documentNumberPartDAO.delete(dnp);
    }

    @Override
    public DocumentNumberPartGroupDefault getNumberPatternGroupDefault(Integer groupId) {
        return this.documentNumberPartDAO.getDefaultGroup(groupId);
    }

    @Override
    public void deleteDocumentNumberPartGroupDefault(Integer documentNumberPartGroupId) {
        DocumentNumberPartGroupDefault group = this.getNumberPatternGroupDefault(documentNumberPartGroupId);
        this.documentNumberPartDAO.delete(group);
    }

    @Override
    public DocumentNumberPartDefault getDocumentNumberPartDefault(Integer id) {
        return this.documentNumberPartDAO.getDefault(id);
    }

    @Override
    public void deleteDocumentNumberPartDefault(Integer documentNumberPartId) {
        DocumentNumberPartDefault dnp = this.getDocumentNumberPartDefault(documentNumberPartId);
        this.documentNumberPartDAO.delete(dnp);
    }

    @Override
    public DocumentNumberPartGroupDefault updateNumberPatternDefault(DocumentNumberPartGroupDefault group, List<DocumentNumberPartDefault> parts) {
        this.documentNumberPartDAO.update(group);
        for (DocumentNumberPartDefault part : parts) {
            if (part.getRule() == null || part.getRule().length() == 0 || part.getName() == null || part.getName().length() == 0) continue;
            if (part.getId() != null && part.getId() > 0) {
                this.documentNumberPartDAO.update(part);
                continue;
            }
            part.setGroup(group);
            this.documentNumberPartDAO.save(part);
        }
        return this.documentNumberPartDAO.update(group);
    }

    @Override
    public DocumentNumberPartGroupDefault insertNumberPatternDefault(DocumentNumberPartGroupDefault group, List<DocumentNumberPartDefault> parts) {
        this.documentNumberPartDAO.save(group);
        for (DocumentNumberPartDefault part : parts) {
            part.setGroup(group);
            if (part.getName() == null || part.getName().length() <= 0 || part.getRule() == null || part.getRule().length() <= 0) continue;
            this.documentNumberPartDAO.save(part);
        }
        return this.documentNumberPartDAO.update(group);
    }

    private Network copyDocumentNumberPartGroupsForNetwork(Network network) {
        NetworkType networkType = network.getNetworkType();
        if (networkType.getDocumentNumberPartGroupDefaults() != null) {
            Collection defaultGroups = networkType.getDocumentNumberPartGroupDefaults().values();
            for (DocumentNumberPartGroupDefault defaultGroup : defaultGroups) {
                DocumentNumberPartGroup group = new DocumentNumberPartGroup();
                List networkMasterDataSets = this.masterDataSetDAO.getAllFromNetwork(network.getId());
                if (networkMasterDataSets != null && networkMasterDataSets.size() > 0) {
                    MasterDataSet mds = (MasterDataSet)networkMasterDataSets.get(0);
                    group.setMasterDataSet(mds);
                }
                group.setName(defaultGroup.getName());
                group.setNetwork(network);
                group.setRendererName(defaultGroup.getRendererName());
                group = this.documentNumberPartDAO.save(group);
                if (defaultGroup.getParts() != null) {
                    Collection defaultParts = defaultGroup.getParts().values();
                    for (DocumentNumberPartDefault defaultPart : defaultParts) {
                        DocumentNumberPart part = new DocumentNumberPart();
                        part.setName(defaultPart.getName());
                        part.setFormat(defaultPart.getFormat());
                        part.setLength(defaultPart.getLength());
                        part.setPosition(defaultPart.getPosition());
                        part.setRule(defaultPart.getRule());
                        part.setSeperator(defaultPart.getSeperator());
                        part.setUniqueKey(defaultPart.isUniqueKey());
                        part.setGroup(group);
                        part.setFieldType(defaultPart.getFieldType());
                        part = this.documentNumberPartDAO.save(part);
                    }
                }
                group = this.documentNumberPartDAO.update(group);
            }
            network = this.networkDAO.merge(network);
        }
        return network;
    }

    @Override
    public void deleteDocumentNumberPartGroup(Integer documentNumberPartGroupId) {
        DocumentNumberPartGroup group = this.documentNumberPartDAO.getGroup(documentNumberPartGroupId);
        if (group.getParts() != null) {
            Collection parts = group.getParts().values();
            for (DocumentNumberPart part : parts) {
                this.documentNumberPartDAO.delete(part);
            }
        }
        this.documentNumberPartDAO.delete(group);
    }

    @Override
    public boolean getIsNumberPatternDeletable(DocumentNumberPartGroup group, Network network) {
        List projects = this.projectDAO.getAllFromNetwork(network.getId());
        for (Project project : projects) {
            if (project.getDocumentNumberPartGroup() == null || !project.getDocumentNumberPartGroup().getId().equals(group.getId())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void insertCopiesOfDefaultNumberPatternsIntoNetwork(List<Integer> numberPatternIds, Network network) {
        for (Integer nextId : numberPatternIds) {
            DocumentNumberPartGroupDefault defaultGroup = this.documentNumberPartDAO.getDefaultGroup(nextId);
            DocumentNumberPartGroup group = new DocumentNumberPartGroup();
            List networkMasterDataSets = this.masterDataSetDAO.getAllFromNetwork(network.getId());
            if (networkMasterDataSets != null && networkMasterDataSets.size() > 0) {
                MasterDataSet mds = (MasterDataSet)networkMasterDataSets.get(0);
                group.setMasterDataSet(mds);
            }
            group.setName(defaultGroup.getName());
            group.setNetwork(network);
            group.setRendererName(defaultGroup.getRendererName());
            group = this.documentNumberPartDAO.save(group);
            if (defaultGroup.getParts() != null) {
                Collection defaultParts = defaultGroup.getParts().values();
                for (DocumentNumberPartDefault defaultPart : defaultParts) {
                    DocumentNumberPart part = new DocumentNumberPart();
                    part.setName(defaultPart.getName());
                    part.setFormat(defaultPart.getFormat());
                    part.setLength(defaultPart.getLength());
                    part.setPosition(defaultPart.getPosition());
                    part.setRule(defaultPart.getRule());
                    part.setSeperator(defaultPart.getSeperator());
                    part.setUniqueKey(defaultPart.isUniqueKey());
                    part.setGroup(group);
                    part.setFieldType(defaultPart.getFieldType());
                    part = this.documentNumberPartDAO.save(part);
                }
            }
            group = this.documentNumberPartDAO.update(group);
        }
        network = this.networkDAO.merge(network);
    }

    @Override
    public List getAllSupportContacts() {
        return this.supportDAO.getAll();
    }

    @Override
    public void deleteSupportContact(Integer supportId) {
        Support sup = this.supportDAO.get(supportId);
        this.supportDAO.delete(sup);
    }

    @Override
    public Support updateSupportContact(Support support) {
        return this.supportDAO.update(support);
    }

    @Override
    public Support getSupportContact(Integer id) {
        return this.supportDAO.get(id);
    }

    @Override
    public Support insertSupportContact(Support support) {
        return this.supportDAO.save(support);
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public void setReviewCycleDAO(ReviewCycleDAO reviewCycleDAO) {
        this.reviewCycleDAO = reviewCycleDAO;
    }

    @Override
    public void deleteNetwork(Integer networkId) {
        Network network = this.networkDAO.get(networkId);
        Collection networkPersons = network.getNetworkPersons().values();
        for (Object networkPerson : networkPersons) {
            this.networkDAO.delete((NetworkPerson)networkPerson);
        }
        network.getNetworkPersons().clear();
        this.networkDAO.update(network);
        Collection organisations = network.getOrganisations().values();
        for (Object organisation : organisations) {
            ((Organisation)organisation).getOwnNetworks().clear();
            ((Organisation)organisation).getNetworks().clear();
            this.organisationDAO.update((Organisation)organisation);
        }
        network.getOrganisations().clear();
        this.networkDAO.update(network);
        List documentNumberPartGroups = this.getNumberPatternGroups(networkId);
        for (Object documentNumberPartGroup : documentNumberPartGroups) {
            this.deleteDocumentNumberPartGroup(((DocumentNumberPartGroup)documentNumberPartGroup).getId());
        }
        Collection masterDataSets = network.getMasterDataSets().values();
        for (MasterDataSet masterDataSet : masterDataSets) {
            this.deleteMasterDataSetAndTypes(masterDataSet.getId());
        }
        network.getMasterDataSets().clear();
        this.networkDAO.update(network);
        Collection roles = network.getRoles().values();
        for (Role role : roles) {
            this.roleOperations.deleteRole(role);
        }
        network.getRoles().clear();
        this.networkDAO.update(network);
        this.networkDAO.delete(network);
    }
}

