/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.cycle.cell;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.data.cycle.ReviewCycleInstance;
import at.cdes.bo.data.cycle.cell.ReviewCycleCell;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstance;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstance;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstancePositionComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReviewCycleCellInstanceBase
implements CdesDataObject,
ReviewCycleCellInstance {
    static final long serialVersionUID = 1L;
    protected Integer id;
    protected int duration;
    protected ReviewCycleInstance reviewCycleInstance;
    protected ReviewCycleCell reviewCycleCell;
    protected Map reviewCycleNodeInstances;
    protected Map freeReviewCycleNodeInstances;
    protected boolean startCell;
    protected int changed;
    protected boolean projectsAllowedFinalReviewCycleCell;

    public int getChanged() {
        return this.changed;
    }

    public void setChanged(int changed) {
        this.changed = changed;
    }

    @Override
    public ReviewCycleNodeInstance getNodeInstance(Integer nodeId) {
        return this.getNodeInstance(nodeId, this.getReviewCycleNodeInstances());
    }

    public ReviewCycleNodeInstance getFreeNodeInstance(Integer nodeId) {
        return this.getNodeInstance(nodeId, this.getFreeReviewCycleNodeInstances());
    }

    private ReviewCycleNodeInstance getNodeInstance(Integer nodeId, Map nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        if (nodeId == null) {
            return null;
        }
        for (ReviewCycleNodeInstance res : nodes.values()) {
            if (res.getReviewCycleNode().getId() == null || !res.getReviewCycleNode().getId().equals(nodeId)) continue;
            return res;
        }
        return null;
    }

    @Override
    public List getReviewCycleNodeInstancesSortedByPosition() {
        ArrayList ret = new ArrayList();
        ret.addAll(this.getReviewCycleNodeInstances().values());
        Collections.sort(ret, new ReviewCycleNodeInstancePositionComparator());
        return ret;
    }

    @Override
    public ReviewCycleNodeInstance getNextNodeInstance(ReviewCycleNodeInstance n) {
        if (this.reviewCycleNodeInstances == null) {
            return null;
        }
        Iterator it = this.reviewCycleNodeInstances.values().iterator();
        ReviewCycleNodeInstance ret = null;
        while (it.hasNext()) {
            ReviewCycleNodeInstance ni = (ReviewCycleNodeInstance)it.next();
            if (ni.getReviewCycleNode().getPosition() <= n.getReviewCycleNode().getPosition() || ret != null && ni.getReviewCycleNode().getPosition() >= ret.getReviewCycleNode().getPosition()) continue;
            ret = ni;
        }
        return ret;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public ReviewCycleCell getReviewCycleCell() {
        return this.reviewCycleCell;
    }

    @Override
    public void setReviewCycleCell(ReviewCycleCell reviewCycleCell) {
        this.reviewCycleCell = reviewCycleCell;
    }

    @Override
    public ReviewCycleInstance getReviewCycleInstance() {
        return this.reviewCycleInstance;
    }

    @Override
    public void setReviewCycleInstance(ReviewCycleInstance reviewCycleInstance) {
        this.reviewCycleInstance = reviewCycleInstance;
    }

    @Override
    public Map getReviewCycleNodeInstances() {
        return this.reviewCycleNodeInstances;
    }

    @Override
    public void setReviewCycleNodeInstances(Map reviewCycleNodeInstances) {
        this.reviewCycleNodeInstances = reviewCycleNodeInstances;
    }

    @Override
    public boolean isStartCell() {
        return this.startCell;
    }

    @Override
    public void setStartCell(boolean startCell) {
        this.startCell = startCell;
    }

    @Override
    public ReviewCycleNodeInstance getFirstNodeInstance() {
        if (this.reviewCycleNodeInstances == null) {
            return null;
        }
        Iterator it = this.reviewCycleNodeInstances.values().iterator();
        ReviewCycleNodeInstance ret = null;
        while (it.hasNext()) {
            ReviewCycleNodeInstance ni = (ReviewCycleNodeInstance)it.next();
            if (ret != null && ni.getReviewCycleNode().getPosition() >= ret.getReviewCycleNode().getPosition()) continue;
            ret = ni;
        }
        return ret;
    }

    @Override
    public ReviewCycleNodeInstance getFirstFreeReviewCycleNodeInstance() {
        if (this.getFreeReviewCycleNodeInstances() == null) {
            return null;
        }
        Iterator it = this.getFreeReviewCycleNodeInstances().values().iterator();
        if (it.hasNext()) {
            return (ReviewCycleNodeInstance)it.next();
        }
        return null;
    }

    @Override
    public ReviewCycleNodeInstance getLastReviewCycleNodeInstance() {
        if (this.reviewCycleNodeInstances == null) {
            return null;
        }
        List list = this.getReviewCycleNodeInstancesSortedByPosition();
        return (ReviewCycleNodeInstance)list.get(list.size() - 1);
    }

    @Override
    public Map getFreeReviewCycleNodeInstances() {
        return this.freeReviewCycleNodeInstances;
    }

    @Override
    public void setFreeReviewCycleNodeInstances(Map freeReviewCycleNodeInstances) {
        this.freeReviewCycleNodeInstances = freeReviewCycleNodeInstances;
    }

    @Override
    public ReviewCycleNodeInstance getNodeInstanceByNodePosition(int position) {
        if (this.getReviewCycleNodeInstances() == null) {
            return null;
        }
        Collection nodes = this.getReviewCycleNodeInstances().values();
        for (ReviewCycleNodeInstance node : nodes) {
            if (node.getReviewCycleNode().getPosition() != position) continue;
            return node;
        }
        return null;
    }

    @Override
    public boolean isProjectsAllowedFinalReviewCycleCell() {
        return this.projectsAllowedFinalReviewCycleCell;
    }

    @Override
    public void setProjectsAllowedFinalReviewCycleCell(boolean projectsAllowedFinalReviewCycleCell) {
        this.projectsAllowedFinalReviewCycleCell = projectsAllowedFinalReviewCycleCell;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!ReviewCycleCellInstanceBase.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ReviewCycleCellInstanceBase other = (ReviewCycleCellInstanceBase)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }
}

