/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.action.impl;

import at.cdes.bo.data.cycle.ReviewCyclePosition;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.object.ObjectPlanner;
import at.cdes.bo.data.object.ObjectPlannerPosition;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.role.ActionRule;
import at.cdes.bo.data.role.Role;
import at.cdes.controller.action.impl.ProjectValidator;
import at.cdes.db.dao.ReviewCyclePositionDAO;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPlannerValidator
extends ProjectValidator {
    private static final Logger log = LoggerFactory.getLogger(ObjectPlannerValidator.class);
    public ReviewCyclePositionDAO reviewCyclePositionDAO;

    @Override
    public boolean validateAction(Role role, ActionRule action) {
        return role.hasAction(action.getAction().getName());
    }

    public boolean validateMember(ObjectPlanner objectPlanner, OrganisationPerson organisationPerson, ActionRule action, Network network) {
        if (log.isDebugEnabled()) {
            log.debug("........ ObjectPlannerValidator called: ObjPl = [" + objectPlanner.getId() + "]; OrgPerson = [" + organisationPerson.getId() + "]; action: [" + action.getAction().getName() + "]; Net = [" + network.getId() + "]");
        }
        if (objectPlanner.getObject().getObjectList().getSubProject().isReadOnly() && action.getAction().getReadOnly() != 1) {
            if (log.isDebugEnabled()) {
                log.debug("............ Returning false because sub project is readonly.");
            }
            return false;
        }
        if (objectPlanner.getPlanner() == null || objectPlanner.getPlanner().getProjectParticipants() == null) {
            if (log.isDebugEnabled()) {
                log.debug("............ Returning false because objectPlanner.planner is null, or no participants given.");
            }
            return false;
        }
        Iterator it = objectPlanner.getPlanner().getProjectParticipants().values().iterator();
        if (log.isDebugEnabled()) {
            log.debug("............ Step 1: Return true if the OrganisationPerson is planner.");
        }
        while (it.hasNext()) {
            boolean ppRoleHasAction = this.validateAction(objectPlanner.getPlanner().getRole(), action);
            ProjectParticipant part = (ProjectParticipant)it.next();
            if (log.isDebugEnabled()) {
                log.debug("................ ppRoleHasAction = [" + ppRoleHasAction + "]; Checking participant [" + part.getId() + "] with orgPerson = [" + part.getOrganisationPerson().getId() + "]");
            }
            if (!ppRoleHasAction || !part.getOrganisationPerson().getId().equals(organisationPerson.getId())) continue;
            if (log.isDebugEnabled()) {
                log.debug("............ Returning true.");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("............ Step 2: Return true if the OrganisationPerson is selected in a ObjectPlannerPosition");
        }
        Collection positions = objectPlanner.getPositions().values();
        for (ObjectPlannerPosition position : positions) {
            ProjectParticipation pp = position.getProjectParticipation();
            boolean ppRoleHasAction = this.validateAction(pp.getRole(), action);
            if (log.isDebugEnabled()) {
                log.debug("................ Checking ObjectPlannerPosition = [" + position.getId() + "]; ppRoleHasAction = [" + ppRoleHasAction + "]");
            }
            Collection participants = pp.getProjectParticipants().values();
            for (ProjectParticipant participant : participants) {
                if (log.isDebugEnabled()) {
                    log.debug(".................... Checking participant = [" + participant.getId() + "] with orgPerson = [" + participant.getOrganisationPerson().getId() + "]");
                }
                if (!ppRoleHasAction || !participant.getOrganisationPerson().getId().equals(organisationPerson.getId())) continue;
                if (log.isDebugEnabled()) {
                    log.debug(".................... Returning true.");
                }
                return true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("............ Step 3: Return true if the OrganisationPerson is selected in a ReviewCyclePosition");
        }
        if (objectPlanner.getReviewCycleInstance() != null) {
            List rcpositions = this.reviewCyclePositionDAO.getAll(organisationPerson, objectPlanner.getReviewCycleInstance());
            for (ReviewCyclePosition rcposition : rcpositions) {
                if (log.isDebugEnabled()) {
                    log.debug("................ Checking ReviewCyclePosition = [" + rcposition.getId() + "]");
                }
                if (!this.validateAction(rcposition.getProjectParticipation().getRole(), action)) continue;
                if (log.isDebugEnabled()) {
                    log.debug(".................... Returning true.");
                }
                return true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("............ Returning false since none of the options above matched.");
        }
        return false;
    }

    public void setReviewCyclePositionDAO(ReviewCyclePositionDAO reviewCyclePositionDAO) {
        this.reviewCyclePositionDAO = reviewCyclePositionDAO;
    }
}

