/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.certificate.CDESCertificate;
import at.cdes.bo.data.certificate.CertificateRequest;
import at.cdes.db.dao.CertificateDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class CertificateDAOHibernate
extends HibernateDaoSupport
implements CertificateDAO {
    @Override
    public Integer getMostRecentSignedUserPolicyVersionForPerson(Integer personId) {
        Criteria crit = this.getSession().createCriteria(CertificateRequest.class).createCriteria("createdFor").createCriteria("person").add(Restrictions.idEq((Object)personId));
        List candidateRequests = crit.list();
        Integer maxVersion = null;
        for (CertificateRequest candidateRequest : candidateRequests) {
            if (candidateRequest.getRequestPdfUploadVersion() == null || maxVersion != null && candidateRequest.getRequestPdfUploadVersion() <= maxVersion) continue;
            maxVersion = candidateRequest.getRequestPdfUploadVersion();
        }
        return maxVersion;
    }

    @Override
    public List<CertificateRequest> getSignedUserPolicyVersionsForPerson(Integer personId) {
        Calendar now = Calendar.getInstance();
        now.add(5, -30);
        Date nowMinus30 = now.getTime();
        Criteria crit = this.getSession().createCriteria(CDESCertificate.class);
        Criteria critCertificateRequest = crit.createCriteria("certificateRequest");
        critCertificateRequest.createCriteria("createdFor").createCriteria("person").add(Restrictions.idEq((Object)personId));
        crit.add((Criterion)Restrictions.eq((String)"mayLogin", (Object)Boolean.TRUE));
        crit.add((Criterion)Restrictions.eq((String)"maySign", (Object)Boolean.TRUE));
        crit.add((Criterion)Restrictions.gt((String)"validTo", (Object)nowMinus30));
        critCertificateRequest.addOrder(Order.desc((String)"requestPdfUploadVersion"));
        List res = crit.list();
        ArrayList<CertificateRequest> certificateRequests = new ArrayList<CertificateRequest>();
        for (CDESCertificate cdesCertificate : res) {
            certificateRequests.add(cdesCertificate.getCertificateRequest());
        }
        return certificateRequests;
    }

    @Override
    public CDESCertificate get(Integer id) {
        return (CDESCertificate)this.getSession().load(CDESCertificate.class, (Serializable)id);
    }

    public List getAll() {
        return this.loadAllHibernate(CDESCertificate.class);
    }

    @Override
    public CDESCertificate save(CDESCertificate cons) {
        return this.get((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public CDESCertificate update(CDESCertificate cons) {
        return (CDESCertificate)this.getSession().merge((Object)cons);
    }

    @Override
    public void delete(CDESCertificate cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public CertificateRequest getRequest(Integer id) {
        return (CertificateRequest)this.getSession().load(CertificateRequest.class, (Serializable)id);
    }

    @Override
    public CertificateRequest getCertificateRequestByChallenge1(String c1) {
        return (CertificateRequest)this.getSession().createCriteria(CertificateRequest.class).add((Criterion)Restrictions.eq((String)"challenge1", (Object)c1)).uniqueResult();
    }

    public List getAllRequests() {
        return this.loadAllHibernate(CertificateRequest.class);
    }

    @Override
    public CertificateRequest saveRequest(CertificateRequest cons) {
        return this.getRequest((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public CertificateRequest updateRequest(CertificateRequest cons) {
        this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public void deleteRequest(CertificateRequest cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public List getCertificates(Integer for_orgperson_id) {
        List all_certs = this.getAll();
        Vector<CDESCertificate> matching_certs = new Vector<CDESCertificate>();
        for (CDESCertificate cert : all_certs) {
            if (cert.getOrganisationPerson() == null || !cert.getOrganisationPerson().getId().equals(for_orgperson_id)) continue;
            matching_certs.add(cert);
        }
        return matching_certs;
    }

    @Override
    public List getInvitations(Integer for_orgperson_id) {
        List all_certreqs = this.getCertificateRequests(for_orgperson_id);
        Vector<CertificateRequest> matching_certreqs = new Vector<CertificateRequest>();
        for (CertificateRequest certreq : all_certreqs) {
            if (certreq.getCreatedFor() == null || certreq.getRequest() != null && certreq.getRequest().length != 0) continue;
            matching_certreqs.add(certreq);
        }
        return matching_certreqs;
    }

    @Override
    public List getAcceptedCertificateRequests(Integer for_orgperson_id) {
        List all_certreqs = this.getCertificateRequests(for_orgperson_id);
        Vector<CertificateRequest> matching_certreqs = new Vector<CertificateRequest>();
        for (CertificateRequest certreq : all_certreqs) {
            if (certreq.getCreatedFor() == null || certreq.getRequest() == null || certreq.getRequest().length <= 0 || certreq.getRequestType().equals("Accepted")) continue;
            matching_certreqs.add(certreq);
        }
        return matching_certreqs;
    }

    @Override
    public List getCertificateRequests(Integer for_orgperson_id) {
        return this.getSession().createCriteria(CertificateRequest.class).createCriteria("createdFor").add(Restrictions.idEq((Object)for_orgperson_id)).list();
    }

    @Override
    public CDESCertificate getCertificateByRequest(CertificateRequest cr) {
        List matching_requests = this.getSession().createCriteria(CDESCertificate.class).createCriteria("certificateRequest").add(Restrictions.idEq((Object)cr.getId())).list();
        if (matching_requests.size() < 1) {
            return null;
        }
        return (CDESCertificate)matching_requests.get(0);
    }

    @Override
    public CDESCertificate getSignerCertificate(Integer organisationPersonId, boolean includeExpired) {
        Criteria crit = this.getSession().createCriteria(CDESCertificate.class);
        crit.createCriteria("organisationPerson").add(Restrictions.idEq((Object)organisationPersonId));
        crit.add((Criterion)Restrictions.eq((String)"maySign", (Object)true));
        crit.addOrder(Order.desc((String)"id"));
        List res = crit.list();
        if (res == null || res.size() == 0) {
            return null;
        }
        for (CDESCertificate certificate : res) {
            if (certificate.getPrivateKey() == null || !includeExpired && (certificate.getValidTo() == null || !certificate.getValidTo().after(new Date(System.currentTimeMillis())))) continue;
            return certificate;
        }
        return null;
    }

    @Override
    public List getCertificatesByNetwork(Integer network_id) {
        Criteria crit = this.getSession().createCriteria(CDESCertificate.class);
        crit.add(Restrictions.isNotNull((String)"certificate"));
        crit.createCriteria("organisationPerson").createCriteria("organisation").createCriteria("networks").add(Restrictions.idEq((Object)network_id)).list();
        crit.addOrder(Order.desc((String)"validTo"));
        return crit.list();
    }

    @Override
    public List getInvitationsByNetwork(Integer network_id) {
        Criteria crit = this.getSession().createCriteria(CertificateRequest.class);
        crit.add(Restrictions.isNotNull((String)"requestDate"));
        crit.add((Criterion)Restrictions.eq((String)"requestType", (Object)"Invitation"));
        crit.createCriteria("createdFor").createCriteria("organisation").createCriteria("networks").add(Restrictions.idEq((Object)network_id));
        return crit.list();
    }

    @Override
    public List getCertificateRequestsByNetwork(Integer network_id) {
        Criteria crit = this.getSession().createCriteria(CertificateRequest.class);
        crit.add(Restrictions.isNotNull((String)"requestDate"));
        crit.add((Criterion)Restrictions.eq((String)"requestType", (Object)"Request"));
        crit.createCriteria("createdFor").createCriteria("organisation").createCriteria("networks").add(Restrictions.idEq((Object)network_id));
        return crit.list();
    }

    @Override
    public List<CDESCertificate> getCertificatesByRequestId(Integer id) {
        Criteria crit = this.getSession().createCriteria(CDESCertificate.class);
        crit.createCriteria("certificateRequest").add(Restrictions.idEq((Object)id));
        return crit.list();
    }

    @Override
    public List getCertificatesByPerson(Integer personId) {
        Criteria crit = this.getSession().createCriteria(CDESCertificate.class);
        crit.createCriteria("organisationPerson").createCriteria("person").add(Restrictions.idEq((Object)personId));
        return crit.list();
    }

    @Override
    public List getSignableCertificatesByPerson(Integer personId) {
        Criteria crit = this.getSession().createCriteria(CDESCertificate.class);
        crit.createCriteria("organisationPerson").createCriteria("person").add(Restrictions.idEq((Object)personId));
        crit.add((Criterion)Restrictions.eq((String)"maySign", (Object)true));
        return crit.list();
    }

    @Override
    public List getInvitationsOrRequestsForPerson(Integer personId) {
        Criteria crit = this.getSession().createCriteria(CertificateRequest.class);
        crit.add(Restrictions.isNotNull((String)"requestDate"));
        crit.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"requestType", (Object)"Invitation"), (Criterion)Restrictions.eq((String)"requestType", (Object)"Request")));
        crit.createCriteria("createdFor").createCriteria("person").add(Restrictions.idEq((Object)personId));
        return crit.list();
    }
}

