/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.cycle;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.data.cycle.ReviewCycleResultOption;
import at.cdes.bo.data.cycle.cell.ReviewCycleCell;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellCodeNameComparator;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellPositionComparator;
import at.cdes.bo.data.number.DocumentNumberVersionPart;
import at.cdes.util.TapestryI18nHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ReviewCycle
implements CdesDataObject {
    static final long serialVersionUID = 1L;
    private Integer id;
    private String name;
    private String description;
    private Map reviewCycleCells;
    private DocumentNumberVersionPart documentNumberVersionPart;
    private ReviewCycleResultOption documentVersionInvalidationOption;
    private ReviewCycleResultOption documentInvalidationOption;
    private ReviewCycleResultOption emptyNodeOption;
    private ReviewCycleResultOption documentVersionDeletedOption;
    private ReviewCycleResultOption documentVersionAbortedOption;
    private Map labels;
    private Map networks;
    private boolean labelMandatory;
    private boolean defaultCycle;

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getI18nName() {
        return TapestryI18nHelper.getLocalizedString(this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map getReviewCycleCells() {
        return this.reviewCycleCells;
    }

    public void setReviewCycleCells(Map reviewCycleCells) {
        this.reviewCycleCells = reviewCycleCells;
    }

    public DocumentNumberVersionPart getDocumentNumberVersionPart() {
        return this.documentNumberVersionPart;
    }

    public void setDocumentNumberVersionPart(DocumentNumberVersionPart documentNumberVersionPart) {
        this.documentNumberVersionPart = documentNumberVersionPart;
    }

    public ReviewCycleResultOption getDocumentInvalidationOption() {
        return this.documentInvalidationOption;
    }

    public void setDocumentInvalidationOption(ReviewCycleResultOption documentInvalidationOption) {
        this.documentInvalidationOption = documentInvalidationOption;
    }

    public ReviewCycleResultOption getDocumentVersionInvalidationOption() {
        return this.documentVersionInvalidationOption;
    }

    public void setDocumentVersionInvalidationOption(ReviewCycleResultOption documentVersionInvalidationOption) {
        this.documentVersionInvalidationOption = documentVersionInvalidationOption;
    }

    public ReviewCycleResultOption getEmptyNodeOption() {
        return this.emptyNodeOption;
    }

    public void setEmptyNodeOption(ReviewCycleResultOption emptyNodeOption) {
        this.emptyNodeOption = emptyNodeOption;
    }

    public Map getLabels() {
        return this.labels;
    }

    public void setLabels(Map labels) {
        this.labels = labels;
    }

    public Map getNetworks() {
        return this.networks;
    }

    public void setNetworks(Map networks) {
        this.networks = networks;
    }

    public Collection<ReviewCycleCell> getReviewCycleCellsSortedByCodeAndName() {
        ArrayList<ReviewCycleCell> ret = new ArrayList<ReviewCycleCell>();
        ret.addAll(this.getReviewCycleCells().values());
        Collections.sort(ret, new ReviewCycleCellCodeNameComparator());
        return ret;
    }

    public ReviewCycleResultOption getDocumentVersionDeletedOption() {
        return this.documentVersionDeletedOption;
    }

    public void setDocumentVersionDeletedOption(ReviewCycleResultOption documentVersionDeletedOption) {
        this.documentVersionDeletedOption = documentVersionDeletedOption;
    }

    public ReviewCycleResultOption getDocumentVersionAbortedOption() {
        return this.documentVersionAbortedOption;
    }

    public void setDocumentVersionAbortedOption(ReviewCycleResultOption documentVersionAbortedOption) {
        this.documentVersionAbortedOption = documentVersionAbortedOption;
    }

    public List<ReviewCycleCell> getReviewCycleCellsSortedByPosition() {
        if (this.getReviewCycleCells() == null) {
            return null;
        }
        ArrayList<ReviewCycleCell> cells = new ArrayList<ReviewCycleCell>();
        cells.addAll(this.getReviewCycleCells().values());
        Collections.sort(cells, new ReviewCycleCellPositionComparator());
        return cells;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!ReviewCycle.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ReviewCycle other = (ReviewCycle)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public void setLabelMandatory(boolean labelMandatory) {
        this.labelMandatory = labelMandatory;
    }

    public boolean isLabelMandatory() {
        return this.labelMandatory;
    }

    public boolean isDefaultCycle() {
        return this.defaultCycle;
    }

    public void setDefaultCycle(boolean defaultCycle) {
        this.defaultCycle = defaultCycle;
    }
}

