/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.digest;

import at.cdes.bo.sec.digest.DigestCalculator;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DigestList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

public class FileDigestCalculator
implements DigestCalculator {
    static Logger logger = Logger.getLogger((String)"File digester");

    @Override
    public String getSignableContent(Object o) throws DigestCalculatorException {
        DigestList<String> list = new DigestList<String>();
        this.getSignableContentIteration(o, list);
        return list.toString();
    }

    public void getSignableContentIteration(Object o, DigestList<String> digests) throws DigestCalculatorException {
        if (!(o instanceof File)) {
            throw new DigestCalculatorException("Class " + o.getClass().getName() + " is not supported in this DigestCalculation. java.io.File is required");
        }
        File f = (File)o;
        try {
            int length;
            FileInputStream fis = new FileInputStream(f);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream osd = new DataOutputStream(os);
            DigestOutputStream dos = new DigestOutputStream(osd, this.getMessageDigest());
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) >= 0) {
                dos.write(buffer, 0, length);
            }
            fis.close();
            String res = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
            dos.close();
            digests.add(res);
        }
        catch (IOException e) {
            throw new DigestCalculatorException("Error hashing file = " + f.getName(), e);
        }
    }

    protected MessageDigest getMessageDigest() throws DigestCalculatorException {
        try {
            return MessageDigest.getInstance("SHA1", "BC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestCalculatorException("Init Message Digest", e);
        }
        catch (NoSuchProviderException e) {
            throw new DigestCalculatorException("Init Message Digest", e);
        }
    }

    @Override
    public String getDigest(Object o) throws DigestCalculatorException {
        return this.getSignableContent(o);
    }

    @Override
    public boolean validate(byte[] digest, Object o) throws DigestCalculatorException {
        byte[] newDigest = this.getDigest(o).getBytes();
        return MessageDigest.isEqual(newDigest, digest);
    }
}

