/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectConfig;
import at.cdes.bo.data.project.ProjectHoliday;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.ProjectStatusChange;
import at.cdes.bo.data.project.SubProject;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ProjectDAOHibernate
extends HibernateDaoSupport
implements ProjectDAO {
    @Override
    public int countProjects() {
        Criteria crit = this.getSession().createCriteria(Project.class);
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)10));
        List l = crit.list();
        if (l == null) {
            return 0;
        }
        return l.size();
    }

    @Override
    public Project get(Integer id) {
        return (Project)this.getSession().load(Project.class, (Serializable)id);
    }

    @Override
    public List getAll(Integer networkId, Integer organisationId, String filter, Integer projectStatus) {
        Criteria crit = this.getSession().createCriteria(Project.class);
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)10));
        if (filter != null) {
            crit.add((Criterion)Restrictions.like((String)"name", (Object)("%" + filter + "%")));
        }
        if (networkId != null) {
            crit.createCriteria("network").add(Restrictions.idEq((Object)networkId));
        } else if (organisationId != null) {
            crit.createCriteria("network").createCriteria("organisations").add(Restrictions.idEq((Object)organisationId));
        }
        if (projectStatus != null) {
            crit.add((Criterion)Restrictions.like((String)"status", (Object)projectStatus));
        }
        return crit.list();
    }

    @Override
    public List getAllProjectsByStatus(Integer networkId, Integer organisationId, Integer status) {
        Criteria crit = this.getSession().createCriteria(Project.class);
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)10));
        if (status != null && status != -1) {
            crit.add((Criterion)Restrictions.like((String)"status", (Object)status));
        }
        if (networkId != null) {
            crit = crit.createCriteria("network").add(Restrictions.idEq((Object)networkId));
        } else if (organisationId != null) {
            crit.createCriteria("network").createCriteria("organisations").add(Restrictions.idEq((Object)organisationId));
        }
        return crit.list();
    }

    @Override
    public List getAllPersonal(Integer networkId, Integer organisationPersonId, String filter) {
        Criteria crit = this.getSession().createCriteria(Project.class);
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)10));
        if (filter != null) {
            crit.add((Criterion)Restrictions.like((String)"name", (Object)(filter + "%")));
        }
        if (networkId != null) {
            crit.createCriteria("network").add(Restrictions.idEq((Object)networkId));
        }
        List projects = crit.list();
        if (organisationPersonId == null) {
            return projects;
        }
        ArrayList<Project> result = new ArrayList<Project>();
        for (Project project : projects) {
            crit = this.getSession().createCriteria(ProjectParticipant.class);
            crit.createCriteria("organisationPerson").add(Restrictions.idEq((Object)organisationPersonId));
            crit.createCriteria("participation").add((Criterion)Restrictions.ne((String)"status", (Object)2)).createCriteria("project").add(Restrictions.idEq((Object)project.getId()));
            crit.add((Criterion)Restrictions.eq((String)"inactive", (Object)false));
            List res = crit.list();
            if (res == null || res.isEmpty()) continue;
            result.add(project);
        }
        return result;
    }

    @Override
    public List getAllVisiblePersonal(Integer networkId, Integer organisationPersonId, String filter) {
        Criteria crit = this.getSession().createCriteria(Project.class);
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)10));
        crit.add(Restrictions.between((String)"access", (Object)1, (Object)2));
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)7));
        if (filter != null) {
            crit.add((Criterion)Restrictions.like((String)"name", (Object)("%" + filter + "%")));
        }
        if (networkId != null) {
            crit.createCriteria("network").add(Restrictions.idEq((Object)networkId));
        }
        List projects = crit.list();
        if (organisationPersonId == null) {
            return projects;
        }
        ArrayList<Project> result = new ArrayList<Project>();
        for (Project project : projects) {
            crit = this.getSession().createCriteria(ProjectParticipant.class);
            crit.createCriteria("organisationPerson").add(Restrictions.idEq((Object)organisationPersonId));
            crit.createCriteria("participation").add((Criterion)Restrictions.ne((String)"status", (Object)2)).createCriteria("project").add(Restrictions.idEq((Object)project.getId()));
            crit.add((Criterion)Restrictions.eq((String)"inactive", (Object)false));
            List res = crit.list();
            if (res == null || res.isEmpty()) continue;
            result.add(project);
        }
        return result;
    }

    @Override
    public Project save(Project project) {
        return this.get((Integer)this.getSession().save((Object)project));
    }

    @Override
    public void delete(Project project) {
        this.getSession().delete((Object)project);
    }

    @Override
    public Project update(Project project) {
        this.getSession().merge((Object)project);
        return project;
    }

    @Override
    public ProjectHoliday getProjectHoliday(Integer id) {
        return (ProjectHoliday)this.getSession().load(ProjectHoliday.class, (Serializable)id);
    }

    @Override
    public ProjectHoliday save(ProjectHoliday ProjectHoliday2) {
        return this.getProjectHoliday((Integer)this.getSession().save((Object)ProjectHoliday2));
    }

    @Override
    public void delete(ProjectHoliday ProjectHoliday2) {
        this.getSession().delete((Object)ProjectHoliday2);
    }

    @Override
    public ProjectHoliday update(ProjectHoliday ProjectHoliday2) {
        this.getSession().merge((Object)ProjectHoliday2);
        return ProjectHoliday2;
    }

    @Override
    public Project updateProject(Project p) {
        this.getSession().saveOrUpdate((Object)p);
        return p;
    }

    @Override
    public ProjectStatusChange getStatusChange(Integer id) {
        return (ProjectStatusChange)this.getSession().load(ProjectStatusChange.class, (Serializable)id);
    }

    @Override
    public ProjectStatusChange save(ProjectStatusChange psc) {
        return this.getStatusChange((Integer)this.getSession().save((Object)psc));
    }

    @Override
    public ProjectStatusChange update(ProjectStatusChange psc) {
        this.getSession().merge((Object)psc);
        return psc;
    }

    private ProjectStatusChange getLastStatusChangeForNewStatus(Project p, int newStatus) {
        Criteria crit = this.getSession().createCriteria(ProjectStatusChange.class);
        crit.createCriteria("project").add(Restrictions.idEq((Object)p.getId()));
        List changes = crit.list();
        ProjectStatusChange ret = null;
        Date last_date = null;
        for (ProjectStatusChange change : changes) {
            if (change.getNewStatus() != newStatus || last_date != null && change.getSignature().getTime().compareTo(last_date) < 0) continue;
            ret = change;
            last_date = ret.getSignature().getTime();
        }
        return ret;
    }

    @Override
    public ProjectStatusChange getLastStatusChange(Project p) {
        return this.getLastStatusChangeForNewStatus(p, p.getStatus());
    }

    @Override
    public ProjectStatusChange getLastExportStatusChange(Project p) {
        return this.getLastStatusChangeForNewStatus(p, 2);
    }

    @Override
    public List getAllFromNetwork(Integer networkId) {
        Criteria crit = this.getSession().createCriteria(Project.class);
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)10));
        crit.createCriteria("network").add(Restrictions.idEq((Object)networkId));
        return crit.list();
    }

    @Override
    public List getAllPlanningNotificationProjectsFromNetwork(Integer networkId) {
        Criteria crit = this.getSession().createCriteria(Project.class);
        crit.add((Criterion)Restrictions.eq((String)"status", (Object)10));
        crit.createCriteria("network").add(Restrictions.idEq((Object)networkId));
        return crit.list();
    }

    @Override
    public List getAllActiveFromNetwork(Integer networkId) {
        Criteria crit = this.getSession().createCriteria(Project.class);
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)10));
        crit.createCriteria("network").add(Restrictions.idEq((Object)networkId));
        crit.add((Criterion)Restrictions.like((String)"status", (Object)0));
        crit.add((Criterion)Restrictions.ne((String)"access", (Object)0));
        return crit.list();
    }

    @Override
    public List<Project> getAllProjectsWithMonitoringParticipation(Integer orgPersonId) {
        Criteria crit = this.getSession().createCriteria(Project.class);
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)10));
        crit.add((Criterion)Restrictions.eq((String)"status", (Object)0)).add((Criterion)Restrictions.eq((String)"access", (Object)2));
        Criteria ppCrit = crit.createCriteria("projectParticipations");
        ppCrit.add((Criterion)Restrictions.eq((String)"status", (Object)0));
        Criteria ppntsCrit = ppCrit.createCriteria("projectParticipants");
        ppntsCrit.createCriteria("organisationPerson").add(Restrictions.idEq((Object)orgPersonId));
        ppntsCrit.add((Criterion)Restrictions.eq((String)"inactive", (Object)false));
        Criteria roleCrit = ppCrit.createCriteria("role");
        roleCrit.createCriteria("actionRules").createCriteria("action").add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"name", (Object)"monitorLateReviews"), (Criterion)Restrictions.eq((String)"name", (Object)"overrideLateReviews")));
        roleCrit.createCriteria("type").add((Criterion)Restrictions.eq((String)"type", (Object)2));
        crit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return crit.list();
    }

    @Override
    public int getActiveProjectCount(boolean withInvalid) {
        Criteria crit = this.getSession().createCriteria(Project.class);
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)10));
        if (!withInvalid) {
            crit.add((Criterion)Restrictions.ne((String)"status", (Object)6));
        }
        crit.setProjection((Projection)Projections.count((String)"id"));
        List list = crit.list();
        if (list == null || list.isEmpty()) {
            return 0;
        }
        return (Integer)list.get(0);
    }

    @Override
    public int getActiveSubProjectCount(boolean withInvalid) {
        Criteria crit = this.getSession().createCriteria(SubProject.class);
        if (!withInvalid) {
            crit.add((Criterion)Restrictions.eq((String)"invalidated", (Object)false));
        }
        crit.setProjection((Projection)Projections.count((String)"id"));
        List list = crit.list();
        if (list == null || list.isEmpty()) {
            return 0;
        }
        return (Integer)list.get(0);
    }

    @Override
    public ProjectConfig getProjectConfig(Integer id) {
        return (ProjectConfig)this.getSession().load(ProjectConfig.class, (Serializable)id);
    }

    @Override
    public ProjectConfig save(ProjectConfig projectConfig) {
        return this.getProjectConfig((Integer)this.getSession().save((Object)projectConfig));
    }

    @Override
    public ProjectConfig update(ProjectConfig projectConfig) {
        this.getSession().merge((Object)projectConfig);
        return projectConfig;
    }

    @Override
    public void delete(ProjectConfig projectConfig) {
        this.getSession().delete((Object)projectConfig);
    }
}

