/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.service.visit;

import at.cdes.bo.data.person.Person;
import at.cdes.service.LoginManager;
import at.cdes.service.exception.NoPasswordException;
import at.cdes.service.exception.RedirectLoginException;
import at.cdes.service.exception.UnkownLoginException;
import at.cdes.service.exception.WrongPasswordException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.clazzes.util.aop.ThreadLocalManager;

public class DelegatingLoginManager
implements LoginManager {
    private LoginManager delegate;
    private String loginRegex;
    private Pattern loginPattern;
    private String applicationUrlThreadLocalKey;
    private static final Logger logger = Logger.getLogger(DelegatingLoginManager.class);

    public void setApplicationUrlThreadLocalKey(String applicationUrlThreadLocalKey) {
        this.applicationUrlThreadLocalKey = applicationUrlThreadLocalKey;
    }

    @Override
    public Person getPersonLogin(String login, String password) throws UnkownLoginException, WrongPasswordException, NoPasswordException, RedirectLoginException {
        String applicationUrl;
        logger.info((Object)("Attempted login with username [" + login + "] ..."));
        if (this.loginPattern != null) {
            Matcher matcher = this.loginPattern.matcher(login);
            if (!matcher.matches()) {
                logger.info((Object)"Login not permitted by Regular Expression.");
            }
            throw new UnkownLoginException("User not permitted by local server policy.");
        }
        Person person = this.delegate.getPersonLogin(login, password);
        String url = this.delegate.getPersonURL(person.getId());
        if (!url.equals(applicationUrl = (String)ThreadLocalManager.getBoundResource((String)this.applicationUrlThreadLocalKey))) {
            String msg = "Invalid login of user [id=" + person.getId() + "] redirected to [" + url + "].";
            logger.error((Object)msg);
            throw new RedirectLoginException(url, msg);
        }
        return person;
    }

    @Override
    public String getOrganisationPersonURL(Integer organisationPersonId) {
        return this.delegate.getOrganisationPersonURL(organisationPersonId);
    }

    @Override
    public String getPersonURL(Integer personId) {
        return this.delegate.getPersonURL(personId);
    }

    public LoginManager getDelegate() {
        return this.delegate;
    }

    public void setDelegate(LoginManager delegate) {
        this.delegate = delegate;
    }

    public String getLoginRegex() {
        return this.loginRegex;
    }

    public void setLoginRegex(String loginRegex) {
        this.loginPattern = loginRegex == null || loginRegex.length() <= 0 ? null : Pattern.compile(loginRegex);
        this.loginRegex = loginRegex;
    }
}

