/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ObjectPlannerPositionImpl;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.object.ReleasedObjectPlannerPosition;
import at.cdes.db.dao.ObjectPlannerDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPlannerDAOHibernate
extends HibernateDaoSupport
implements ObjectPlannerDAO {
    private static final Logger log = LoggerFactory.getLogger(ObjectPlannerDAOHibernate.class);

    @Override
    public ObjectPlannerImpl getObjectPlanner(Integer id) {
        return (ObjectPlannerImpl)this.getSession().get(ObjectPlannerImpl.class, (Serializable)id);
    }

    @Override
    public List getAllObjectPlanners() {
        return this.loadAllHibernate(ObjectPlannerImpl.class);
    }

    @Override
    public ObjectPlannerImpl save(ObjectPlannerImpl cons) {
        return this.getObjectPlanner((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public ObjectPlannerImpl update(ObjectPlannerImpl cons) {
        this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public void delete(ObjectPlannerImpl cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public ReleasedObjectPlanner getReleasedObjectPlanner(Integer id) {
        return (ReleasedObjectPlanner)this.getSession().get(ReleasedObjectPlanner.class, (Serializable)id);
    }

    @Override
    public List getAllReleasedObjectPlanners() {
        return this.loadAllHibernate(ReleasedObjectPlanner.class);
    }

    @Override
    public ReleasedObjectPlanner save(ReleasedObjectPlanner cons) {
        return this.getReleasedObjectPlanner((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public ReleasedObjectPlanner update(ReleasedObjectPlanner cons) {
        this.getSession().update((Object)cons);
        return cons;
    }

    public ReleasedObjectPlanner merge(ReleasedObjectPlanner cons) {
        this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public void delete(ReleasedObjectPlanner cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public ReleasedObjectPlanner getReleasedObjectPlanner(Integer releasedObjectListId, Integer objectPlannerImplId) {
        if (log.isDebugEnabled()) {
            log.debug("Executing getReleasedObjectPlanner with releasedObjectListId = [" + releasedObjectListId + "] and objectPlannerImplId = [" + objectPlannerImplId + "]");
        }
        Criteria criteria = this.getSession().createCriteria(ReleasedObjectPlanner.class);
        criteria.createCriteria("objectPlanner").add(Restrictions.idEq((Object)objectPlannerImplId));
        criteria.createCriteria("object").createCriteria("objectList").add(Restrictions.idEq((Object)releasedObjectListId));
        return (ReleasedObjectPlanner)criteria.uniqueResult();
    }

    @Override
    public List<ObjectPlannerImpl> getObjectPlannerByCDESObject(Integer objectId) {
        Criteria criteria = this.getSession().createCriteria(ObjectPlannerImpl.class);
        criteria.createCriteria("object").add(Restrictions.idEq((Object)objectId));
        if (criteria.list().size() > 0) {
            return criteria.list();
        }
        return null;
    }

    @Override
    public ObjectPlannerPositionImpl getObjectPlannerPositionImpl(Integer id) {
        return (ObjectPlannerPositionImpl)this.getSession().get(ObjectPlannerPositionImpl.class, (Serializable)id);
    }

    @Override
    public ObjectPlannerPositionImpl save(ObjectPlannerPositionImpl posRel) {
        return this.getObjectPlannerPositionImpl((Integer)this.getSession().save((Object)posRel));
    }

    @Override
    public ObjectPlannerPositionImpl update(ObjectPlannerPositionImpl posRel) {
        this.getSession().merge((Object)posRel);
        return posRel;
    }

    @Override
    public void delete(ObjectPlannerPositionImpl cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public ReleasedObjectPlannerPosition getReleasedObjectPlannerPosition(Integer id) {
        return (ReleasedObjectPlannerPosition)this.getSession().get(ReleasedObjectPlannerPosition.class, (Serializable)id);
    }

    @Override
    public ReleasedObjectPlannerPosition save(ReleasedObjectPlannerPosition posRel) {
        return this.getReleasedObjectPlannerPosition((Integer)this.getSession().save((Object)posRel));
    }

    @Override
    public ReleasedObjectPlannerPosition update(ReleasedObjectPlannerPosition posRel) {
        this.getSession().merge((Object)posRel);
        return posRel;
    }

    @Override
    public Collection<ObjectPlannerPositionImpl> getAllObjectPlannerPositions() {
        return this.loadAllHibernate(ObjectPlannerPositionImpl.class);
    }

    @Override
    public ReleasedObjectPlanner getLastReleasedObjectPlannerFromInvalidatedObjectPlanner(Integer objectPlannerImplId, Integer objectListImplId) {
        Criteria crit = this.getSession().createCriteria(ReleasedObjectPlanner.class);
        crit.createCriteria("object").createCriteria("object").createCriteria("objectList").add(Restrictions.idEq((Object)objectListImplId));
        crit.createCriteria("objectPlanner").add(Restrictions.idEq((Object)objectPlannerImplId));
        List planners = crit.list();
        ReleasedObjectPlanner mostRecent = null;
        for (ReleasedObjectPlanner op : planners) {
            if (mostRecent != null && !((ReleasedObjectList)op.getObject().getObjectList()).getSignature().getTime().after(((ReleasedObjectList)mostRecent.getObject().getObjectList()).getSignature().getTime())) continue;
            mostRecent = op;
        }
        return mostRecent;
    }

    @Override
    public List<ObjectPlannerPositionImpl> getObjectPlannerPositionsByObjectPlannerId(Integer objectPlannerImplId) {
        return this.getSession().createCriteria(ObjectPlannerPositionImpl.class).createCriteria("objectPlanner").add(Restrictions.idEq((Object)objectPlannerImplId)).list();
    }

    @Override
    public List<ReleasedObjectPlanner> getAllReleasedObjectPlannersFromUnreleased(Integer objectPlannerImplId) {
        return this.getSession().createCriteria(ReleasedObjectPlanner.class).createCriteria("objectPlanner").add(Restrictions.idEq((Object)objectPlannerImplId)).list();
    }

    @Override
    public List getUnreleasedObjectPlannerPositionsByParticipation(Integer subProjectId, Integer projectParticipationId) {
        Criteria crit = this.getSession().createCriteria(ObjectPlannerImpl.class);
        crit.add((Criterion)Restrictions.ne((String)"inactive", (Object)Boolean.TRUE));
        crit.createCriteria("planner").add(Restrictions.idEq((Object)projectParticipationId));
        Criteria crita = crit.createCriteria("object");
        crita.add((Criterion)Restrictions.ne((String)"inactive", (Object)Boolean.TRUE));
        crita.createCriteria("objectList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        Criteria crit2 = this.getSession().createCriteria(ObjectPlannerPositionImpl.class);
        crit2.createCriteria("projectParticipation").add(Restrictions.idEq((Object)projectParticipationId));
        Criteria crit2a = crit2.createCriteria("objectPlanner");
        crit2a.add((Criterion)Restrictions.ne((String)"inactive", (Object)Boolean.TRUE));
        Criteria crit2b = crit2a.createCriteria("object");
        crit2b.add((Criterion)Restrictions.ne((String)"inactive", (Object)Boolean.TRUE));
        crit2b.createCriteria("objectList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        List result = crit2.list();
        result.addAll(crit.list());
        return result;
    }

    @Override
    public List getReleasedObjectPlannerPositionByParticipation(Integer projectParticipationId, Integer releasedObjectListId) {
        Criteria crit = this.getSession().createCriteria(ReleasedObjectPlanner.class);
        crit.createCriteria("object").createCriteria("objectList").add(Restrictions.idEq((Object)releasedObjectListId));
        crit.createCriteria("planner").add(Restrictions.idEq((Object)projectParticipationId));
        Criteria crit2 = this.getSession().createCriteria(ReleasedObjectPlannerPosition.class);
        crit2.createCriteria("objectPlanner").createCriteria("object").createCriteria("objectList").add(Restrictions.idEq((Object)releasedObjectListId));
        crit2.createCriteria("projectParticipation").add(Restrictions.idEq((Object)projectParticipationId));
        List result = crit2.list();
        result.addAll(crit.list());
        return result;
    }

    @Override
    public ReleasedObjectPlanner getReleasedObjectPlannerByDate(Integer objectPlannerImplId, Date signatureDate) {
        Criteria crit = this.getSession().createCriteria(ReleasedObjectPlanner.class);
        crit.createCriteria("objectPlanner").add(Restrictions.idEq((Object)objectPlannerImplId));
        Criteria crit2 = crit.createCriteria("object").createCriteria("objectList").createCriteria("signature");
        crit2.add((Criterion)Restrictions.lt((String)"time", (Object)signatureDate));
        crit2.addOrder(Order.desc((String)"time"));
        List objectPlanners = crit2.list();
        return objectPlanners.isEmpty() ? null : (ReleasedObjectPlanner)objectPlanners.get(0);
    }

    @Override
    public List getAllAsBuiltReferences(Integer sourceSubProjectId, Integer destinationSubProjectId) {
        Criteria crit = this.getSession().createCriteria(ObjectPlannerImpl.class);
        crit.createCriteria("asBuiltReference").createCriteria("object").createCriteria("objectList").createCriteria("subProject").add(Restrictions.idEq((Object)sourceSubProjectId));
        crit.createCriteria("object").createCriteria("objectList").createCriteria("subProject").add(Restrictions.idEq((Object)destinationSubProjectId));
        crit.add((Criterion)Restrictions.ne((String)"inactive", (Object)Boolean.TRUE));
        return crit.list();
    }

    @Override
    public List getAllReleasedObjectPlannersForReviewCycleInstance(Integer reviewCycleInstanceReleaseId) {
        Criteria crit = this.getSession().createCriteria(ReleasedObjectPlanner.class);
        crit.createCriteria("reviewCycleInstance").add(Restrictions.idEq((Object)reviewCycleInstanceReleaseId));
        crit.createCriteria("objectPlanner").add((Criterion)Restrictions.ne((String)"inactive", (Object)Boolean.TRUE));
        return crit.list();
    }

    @Override
    public List getAllUnreleasedObjectPlannersForReviewCycleInstance(Integer reviewCycleInstanceImplId) {
        Criteria crit = this.getSession().createCriteria(ObjectPlannerImpl.class);
        crit.createCriteria("reviewCycleInstance").add(Restrictions.idEq((Object)reviewCycleInstanceImplId));
        crit.add((Criterion)Restrictions.ne((String)"inactive", (Object)Boolean.TRUE));
        return crit.list();
    }
}

