/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.service;

import at.cdes.bo.data.certificate.CDESCertificate;
import at.cdes.bo.data.certificate.CDESCertificateAuthority;
import at.cdes.bo.data.certificate.CertificateRequest;
import at.cdes.bo.data.mail.EMail;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.data.person.PersonCertificatesTO;
import at.cdes.service.exception.CDESCertificateException;
import at.cdes.service.exception.Challenge1NotFoundException;
import at.cdes.service.exception.Challenge2EnrolementException;
import at.cdes.service.exception.WrongPasswordException;
import java.util.List;

public interface CertificateOperations {
    public List getRootCAs();

    public List getAllUserCAs();

    public List getUserCAs(Network var1);

    public List getInvitationsByOrganisationPerson(Integer var1);

    public List getAcceptedCertificateRequestsByOrganisationPerson(Integer var1);

    public List getCertificateRequestsByOrganisationPerson(Integer var1);

    public List getCertificatesByOrganisationPerson(Integer var1);

    public List getCertificatesByNetwork(Integer var1);

    public CDESCertificateAuthority insertCA(CDESCertificateAuthority var1);

    public CDESCertificateAuthority updateCA(CDESCertificateAuthority var1);

    public void deleteCA(Integer var1);

    public CDESCertificateAuthority getCAById(Integer var1);

    public CDESCertificate insertCert(CDESCertificate var1);

    public CDESCertificate updateCert(CDESCertificate var1);

    public CDESCertificate deleteCert(Integer var1);

    public CDESCertificate getCertById(Integer var1);

    public CDESCertificate getCertByRequest(CertificateRequest var1);

    public CertificateRequest insertCertRequest(CertificateRequest var1);

    public CertificateRequest updateCertRequest(CertificateRequest var1);

    public CertificateRequest deleteCertRequest(CertificateRequest var1);

    public CertificateRequest getCertRequestById(Integer var1);

    public CertificateRequest getCertRequestByChallenges(String var1, String var2) throws Challenge1NotFoundException, Challenge2EnrolementException;

    public CDESCertificateAuthority generateRootCA(String var1, String var2, int var3, OrganisationPerson var4) throws CDESCertificateException;

    public CDESCertificateAuthority generateUserCA(String var1, String var2, Network var3, OrganisationPerson var4, CDESCertificateAuthority var5, String var6) throws CDESCertificateException, WrongPasswordException;

    public CertificateRequest generateInvitation(OrganisationPerson var1, OrganisationPerson var2);

    public CDESCertificate generateCertificateRequest(CertificateRequest var1, OrganisationPerson var2, String var3) throws CDESCertificateException;

    public String generateSecurityCodeEMailText(CertificateRequest var1);

    public CDESCertificate signCertificateRequest(CDESCertificate var1, CDESCertificateAuthority var2, String var3, OrganisationPerson var4, int var5) throws CDESCertificateException, WrongPasswordException;

    public String generateInvitationEMailText(CertificateRequest var1);

    public void fillInvitationEMail(EMail var1, CertificateRequest var2);

    public String generateCertificateSignedEMailText(CDESCertificate var1);

    public String generateCertificateRequestEMailText(CDESCertificate var1);

    public List getInvitationsByNetwork(Integer var1);

    public List getCertificateRequestsByNetwork(Integer var1);

    public CDESCertificate changePassword(String var1, String var2, CDESCertificate var3) throws WrongPasswordException;

    public CDESCertificateAuthority changePassword2(String var1, String var2, CDESCertificateAuthority var3) throws WrongPasswordException;

    public CertificateRequest getCertRequestByChallenge1(String var1);

    public CDESCertificate invalidateCert(CDESCertificate var1);

    public CDESCertificate renewCertificate(CDESCertificate var1, CertificateRequest var2, CDESCertificateAuthority var3, String var4, OrganisationPerson var5, int var6) throws WrongPasswordException, CDESCertificateException;

    public CDESCertificate generateDirectCertificate(OrganisationPerson var1, String var2);

    public CDESCertificate signCertificateDirectly(CDESCertificate var1, CDESCertificateAuthority var2, String var3, OrganisationPerson var4, int var5, CDESCertificate var6) throws CDESCertificateException, WrongPasswordException;

    public List getCertificatesByPerson(Integer var1);

    public List getValidUserCAs(Integer var1);

    public CDESCertificate getSignerCertificate(Integer var1, boolean var2);

    public CDESCertificateAuthority insertRootCAIfDatabaseCreatedFromScratch(Person var1);

    public boolean hasMultipleCertifiedOrganisationPersons(Integer var1);

    public List getSignableCertificatesByPerson(Integer var1);

    public boolean hasOrganisationPersonCertificatesWithSignatures(Integer var1);

    public boolean hasPendingInvitationsOrRequests(Integer var1);

    public List<PersonCertificatesTO> getCertifiedPersonsByNetwork(Integer var1);

    public PersonCertificatesTO getPersonCertificateTO(Integer var1);
}

