/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.person;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.data.localisation.Country;
import at.cdes.bo.data.mail.MailModes;
import at.cdes.bo.data.order.OrderAddress;
import at.cdes.bo.data.order.OrderAddressVisitor;
import at.cdes.bo.data.order.OrderAddressVisitorAcceptor;
import at.cdes.bo.data.organisation.Organisation;
import at.cdes.bo.data.person.Person;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

public class OrganisationPerson
implements CdesDataObject,
OrderAddressVisitorAcceptor {
    static final long serialVersionUID = 1L;
    private Map certificates;
    private Organisation organisation;
    private Person person;
    private Country country;
    private Integer id;
    private String organisationalUnitName;
    private String facsimileNumber;
    private Integer emailSendTime;
    private Integer emailSendMode;
    private String emailAddress;
    private boolean inActive;
    private String retiredComment;
    private Date from;
    private Date to;
    private String postalAddress;
    private String postalCode;
    private String localityName;
    private String stateOrProvinceName;
    private String mobileTelephoneNumber;
    private String telephoneNumber;
    private OrganisationPerson directCertificationRequestIssuer;
    private boolean certificateHasExpired;

    public void copyOrganisationValues(Organisation org) {
        this.country = org.getCountry();
        this.facsimileNumber = org.getFacsimileNumber();
        this.emailAddress = org.getEmailAddress();
        this.postalAddress = org.getPostalAddress();
        this.postalCode = org.getPostalCode();
        this.localityName = org.getLocalityName();
        this.stateOrProvinceName = org.getStateOrProvinceName();
        this.mobileTelephoneNumber = org.getMobileTelephoneNumber();
        this.telephoneNumber = org.getTelephoneNumber();
    }

    public Map getCertificates() {
        return this.certificates;
    }

    public void setCertificates(Map certificates) {
        this.certificates = certificates;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Integer getEmailSendTime() {
        return this.emailSendTime;
    }

    public void setEmailSendTime(Integer emailSendTime) {
        this.emailSendTime = emailSendTime;
    }

    public String getFacsimileNumber() {
        return this.facsimileNumber;
    }

    public void setFacsimileNumber(String facsimileNumber) {
        this.facsimileNumber = facsimileNumber;
    }

    public Date getFrom() {
        return this.from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public boolean isInActive() {
        return this.inActive;
    }

    public void setInActive(boolean inActive) {
        this.inActive = inActive;
    }

    public String getLocalityName() {
        return this.localityName;
    }

    public void setLocalityName(String localityName) {
        this.localityName = localityName;
    }

    public String getMobileTelephoneNumber() {
        return this.mobileTelephoneNumber;
    }

    public void setMobileTelephoneNumber(String mobileTelephoneNumber) {
        this.mobileTelephoneNumber = mobileTelephoneNumber;
    }

    public Organisation getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    public String getOrganisationalUnitName() {
        return this.organisationalUnitName;
    }

    public void setOrganisationalUnitName(String organisationalUnitName) {
        this.organisationalUnitName = organisationalUnitName;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public String getPostalAddress() {
        return this.postalAddress;
    }

    public void setPostalAddress(String postalAddress) {
        this.postalAddress = postalAddress;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getRetiredComment() {
        return this.retiredComment;
    }

    public void setRetiredComment(String retiredComment) {
        this.retiredComment = retiredComment;
    }

    public String getStateOrProvinceName() {
        return this.stateOrProvinceName;
    }

    public void setStateOrProvinceName(String stateOrProvinceName) {
        this.stateOrProvinceName = stateOrProvinceName;
    }

    public Date getTo() {
        return this.to;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public Integer getEmailSendMode() {
        return this.emailSendMode;
    }

    public void setEmailSendMode(Integer emailSendMode) {
        this.emailSendMode = emailSendMode;
    }

    public Calendar getNextEMailSendTime(Calendar now) {
        if (this.emailSendMode == null || this.emailSendMode.equals(MailModes.NEVER) || this.isInActive()) {
            return null;
        }
        if (this.emailSendMode.equals(MailModes.ALWAYS)) {
            return now;
        }
        if (this.emailSendTime == null) {
            return now;
        }
        int minute_of_day = now.get(11) * 60 + now.get(12);
        GregorianCalendar ret = new GregorianCalendar(now.get(1), now.get(2), now.get(5), this.emailSendTime / 60, this.emailSendTime % 60);
        if (this.emailSendTime < minute_of_day) {
            ((Calendar)ret).add(5, 1);
        }
        return ret;
    }

    public String[] getPostalAddressArray() {
        return this.postalAddress.split("\n");
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    @Override
    public OrderAddress accept(OrderAddressVisitor visitor) {
        return visitor.getOrderAddress(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!OrganisationPerson.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        OrganisationPerson other = (OrganisationPerson)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public OrganisationPerson getDirectCertificationRequestIssuer() {
        return this.directCertificationRequestIssuer;
    }

    public void setDirectCertificationRequestIssuer(OrganisationPerson directCertificationRequestIssuer) {
        this.directCertificationRequestIssuer = directCertificationRequestIssuer;
    }

    public boolean isCertificateHasExpired() {
        return this.certificateHasExpired;
    }

    public void setCertificateHasExpired(boolean certificateHasExpired) {
        this.certificateHasExpired = certificateHasExpired;
    }
}

