/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.cycle.ReviewCycle;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.network.NetworkPerson;
import at.cdes.bo.data.network.NetworkType;
import at.cdes.bo.data.object.ObjectPlannerDefinitionTemplate;
import at.cdes.bo.data.organisation.Organisation;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;

public class NetworkDAOHibernate
extends HibernateDaoSupport
implements NetworkDAO {
    @Override
    public Network get(Integer id) {
        return (Network)this.getSession().load(Network.class, (Serializable)id);
    }

    @Override
    public List getAll() {
        Criteria criteria = this.getSession().createCriteria(Network.class);
        criteria.addOrder(Order.asc((String)"name"));
        return criteria.list();
    }

    @Override
    public Network save(Network network) {
        return this.get((Integer)this.getSession().save((Object)network));
    }

    @Override
    public void delete(Network network) {
        if (network == null) {
            return;
        }
        this.getSession().delete((Object)network);
    }

    @Override
    public Network save(Network network, Map networkPersons) {
        Integer id = (Integer)this.getSession().save((Object)network);
        return this.get(id);
    }

    @Override
    public Network merge(Network network) {
        ArrayList<Object> orgs = network.getOrganisations() != null ? new ArrayList(network.getOrganisations().values()) : new ArrayList();
        ArrayList<Object> reviewCycles = network.getReviewCycles() != null ? new ArrayList(network.getReviewCycles().values()) : new ArrayList();
        ArrayList<Object> opDefs = network.getObjectPlannerDefinitions() != null ? new ArrayList(network.getObjectPlannerDefinitions().values()) : new ArrayList();
        network = (Network)this.getSession().merge((Object)network);
        for (Organisation organisation : orgs) {
            network.getOrganisations().put(organisation.getId(), organisation);
        }
        for (ReviewCycle reviewCycle : reviewCycles) {
            network.getReviewCycles().put(reviewCycle.getId(), reviewCycle);
        }
        for (ObjectPlannerDefinitionTemplate objectPlannerDefinitionTemplate : opDefs) {
            network.getObjectPlannerDefinitions().put(objectPlannerDefinitionTemplate.getId(), objectPlannerDefinitionTemplate);
        }
        this.getSession().update((Object)network);
        return network;
    }

    @Override
    public List getNetworkTypes() {
        return this.loadAllHibernate(NetworkType.class);
    }

    @Override
    public NetworkType getNetworkType(Integer id) {
        return (NetworkType)this.getSession().get(NetworkType.class, (Serializable)id);
    }

    @Override
    public NetworkPerson save(NetworkPerson np) {
        return (NetworkPerson)this.getSession().get(NetworkPerson.class, (Serializable)((Integer)this.getSession().save((Object)np)));
    }

    @Override
    public NetworkPerson update(NetworkPerson np) {
        this.getSession().merge((Object)np);
        return np;
    }

    @Override
    public void delete(NetworkPerson np) {
        this.getSession().delete((Object)np);
    }

    @Override
    public NetworkPerson getNetworkPerson(Integer id) {
        return (NetworkPerson)this.getSession().load(NetworkPerson.class, (Serializable)id);
    }

    @Override
    public Network update(Network network) {
        this.getSession().update((Object)network);
        return network;
    }

    @Override
    public List getNetworksByNetworkPersonsOrgPersonId(Integer orgPersonId) {
        ArrayList<Network> res = new ArrayList<Network>();
        List networks = this.getAll();
        for (Network network : networks) {
            ArrayList networkPersons = new ArrayList(network.getNetworkPersons().values());
            for (NetworkPerson networkPerson : networkPersons) {
                if (!networkPerson.getOrganisationPerson().getId().equals(orgPersonId)) continue;
                res.add(network);
            }
        }
        return res;
    }
}

