/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.bo.file.FileFinder;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.preview.api.Annotation;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PDFProperty;
import at.cdes.preview.api.PDFPropertyType;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.ByteArrayMimeInputStream;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.LabelOperations;
import at.cdes.util.ImplContextHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.clazzes.util.http.osgi.DefaultHttpContext;
import org.xnap.commons.i18n.I18n;

public class LabelPdfMimeSource
implements VisitlessMimeSource {
    private IHPGLRenderer hpglRenderer;
    private LabelOperations labelOperations;
    private FileFinder fileFinder;

    public String getActionName() {
        return "labelsOverview";
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        Integer id = (Integer)parameters[0];
        LabelContent label = this.getLabelOperations().getLabelContent(id);
        Collection networks = label.getLabel().getOrganisation().getNetworks().values();
        ArrayList ret = new ArrayList(networks.size());
        ret.addAll(networks);
        return ret;
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        Integer id = (Integer)parameters[0];
        Integer reviewCycleId = (Integer)parameters[1];
        boolean withoutAnnotations = false;
        if (parameters.length > 2) {
            withoutAnnotations = (Boolean)parameters[2];
        }
        LabelContent labelContent = this.getLabelOperations().getLabelContent(id);
        try (FileMimeInputStream stream = null;){
            IMimeInputStream ret;
            File file = this.getFileFinder().findFile(labelContent.getFileName(), CDESFileRepository.LABELREPOSITORY);
            String unique = this.getFileFinder().makeUniqueName(labelContent.getFileName(), CDESFileRepository.LABELREPOSITORY);
            stream = new FileMimeInputStream(file, unique, labelContent.getName() + "." + labelContent.getFileType(), DefaultHttpContext.getInstance().getMimeType(labelContent.getFileName()));
            Locale locale = ImplContextHelper.getLocale();
            I18n i18n = I18nFactory.getI18n(locale);
            ArrayList<PDFProperty> properties = new ArrayList<PDFProperty>();
            properties.add(new PDFProperty(PDFPropertyType.ANNOTATION, i18n.tr("Automatisch generiert durch die Planpr\u00fcfplattform c.des")));
            properties.add(new PDFProperty(PDFPropertyType.TITLE, labelContent.getName()));
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            if (!withoutAnnotations) {
                Date creationDate = new Date();
                creationDate.setTime(file.lastModified());
                byte[] fdf_data = this.labelOperations.formatFDFSample(labelContent, creationDate, reviewCycleId);
                ByteArrayMimeInputStream fdf_is = new ByteArrayMimeInputStream(fdf_data, 0.001 * (double)file.lastModified(), labelContent.getName() + ".fdf", "application/vnd.fdf");
                annotations.add(new Annotation((IMimeInputStream)fdf_is, "", "", "", 2));
            }
            IMimeInputStream iMimeInputStream = ret = this.hpglRenderer.renderPdf((IMimeInputStream)stream, properties, labelContent.getRotationAngle(), "", annotations);
            return iMimeInputStream;
        }
    }

    protected FileFinder getFileFinder() {
        return this.fileFinder;
    }

    protected IHPGLRenderer getHpglRenderer() {
        return this.hpglRenderer;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setHpglRenderer(IHPGLRenderer hpglRenderer) {
        this.hpglRenderer = hpglRenderer;
    }

    protected LabelOperations getLabelOperations() {
        return this.labelOperations;
    }

    public void setLabelOperations(LabelOperations labelOperations) {
        this.labelOperations = labelOperations;
    }
}

