/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.sec;

import at.cdes.api.guiService.TabSessionCreatorService;
import at.cdes.api.sec.CdesGwtLoginInfo;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.sec.ClientConfiguration;
import at.cdes.api.sec.PasswordStatus;
import at.cdes.api.sec.PersonVariablesDTO;
import at.cdes.api.sec.UserPolicyStatus;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.data.sec.TabSession;
import at.cdes.bo.sec.TapestryPasswordStatusChecker;
import at.cdes.bo.sec.TapestryUserPolicyStatusChecker;
import at.cdes.impl.sec.CdesSessionControllerImpl;
import at.cdes.service.PersonOperations;
import javax.servlet.http.HttpServletRequest;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.http.sec.HttpLoginService;
import org.clazzes.util.http.sec.LoginRequiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabSessionCreatorServiceImpl
implements TabSessionCreatorService {
    private CdesSessionControllerImpl sessionController;
    private ClientConfiguration clientConfiguration;
    private HttpLoginService delegate;
    private PersonOperations personOperations;
    private String requestThreadLocalKey;
    private TapestryPasswordStatusChecker tapestryPasswordStatusChecker;
    private TapestryUserPolicyStatusChecker tapestryUserPolicyStatusChecker;
    private static final Logger log = LoggerFactory.getLogger(TabSessionCreatorService.class);

    public void setSessionController(CdesSessionControllerImpl sessionController) {
        this.sessionController = sessionController;
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public void setDelegate(HttpLoginService delegate) {
        this.delegate = delegate;
    }

    public void setPersonOperations(PersonOperations personOperations) {
        this.personOperations = personOperations;
    }

    public void setRequestThreadLocalKey(String requestThreadLocalKey) {
        this.requestThreadLocalKey = requestThreadLocalKey;
    }

    public void setTapestryPasswordStatusChecker(TapestryPasswordStatusChecker tapestryPasswordStatusChecker) {
        this.tapestryPasswordStatusChecker = tapestryPasswordStatusChecker;
    }

    public void setTapestryUserPolicyStatusChecker(TapestryUserPolicyStatusChecker tapestryUserPolicyStatusChecker) {
        this.tapestryUserPolicyStatusChecker = tapestryUserPolicyStatusChecker;
    }

    public CdesGwtLoginInfo openTabSession() {
        HttpServletRequest request = (HttpServletRequest)ThreadLocalManager.getBoundResource((String)this.requestThreadLocalKey);
        log.info("Received request [" + request + "] for key [" + this.requestThreadLocalKey + "] of current thread [" + Thread.currentThread().getName() + "]");
        CdesPrincipal principal = (CdesPrincipal)this.delegate.checkLogin(request);
        if (principal != null) {
            String userName = principal.getUserName();
            TabSession tabSession = this.personOperations.openTabSession(userName);
            this.sessionController.registerTabSession(tabSession);
            Integer personId = tabSession.getPersonId();
            Person person = this.personOperations.getPerson(personId);
            PersonVariablesDTO personVariables = this.personOperations.getPersonVariablesDTO(personId);
            if (personVariables == null) {
                return null;
            }
            CdesGwtLoginInfo loginInfo = new CdesGwtLoginInfo();
            loginInfo.setTabSessionId(tabSession.getTabSessionId());
            loginInfo.setClientConfig(this.clientConfiguration);
            loginInfo.setPersonVariables(personVariables);
            loginInfo.setPasswordExpired(Boolean.valueOf(this.tapestryPasswordStatusChecker.checkPasswordStatus(personId) != PasswordStatus.VALID));
            loginInfo.setUserPolicyExpired(Boolean.valueOf(this.tapestryUserPolicyStatusChecker.checkStatus(personId) != UserPolicyStatus.UP_TO_DATE));
            return loginInfo;
        }
        throw new LoginRequiredException(this.delegate.getLoginUrl());
    }

    private ClientConfiguration getClientConfiguration() {
        ClientConfiguration clientConfig = new ClientConfiguration();
        return clientConfig;
    }
}

